/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.renderer;

import com.gildedgames.aether.api.entity.IEntityEyesComponent;
import com.gildedgames.aether.client.renderer.ModelBaseAether;
import com.gildedgames.aether.client.renderer.ModelRendererAether;
import com.gildedgames.aether.common.entities.util.eyes.IEntityEyesComponentProvider;
import com.gildedgames.aether.common.util.helpers.EntityUtil;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class EyeUtil {
    private static final List<ModelRenderer> boxesToUnhide = Lists.newArrayList();

    public static <T extends ModelBase> void renderEyes(RenderManager renderManager, T model, ModelRenderer eyeModel, EntityLivingBase entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale, ResourceLocation pupilLeft, ResourceLocation pupilRight, ResourceLocation eyesClosed, boolean eyeTracking) {
        EyeUtil.renderEyes(renderManager, model, eyeModel, eyeModel, entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, pupilLeft, pupilRight, eyesClosed, eyeTracking);
    }

    public static boolean modelContains(ModelRenderer model, ModelRenderer part) {
        if (model.field_78805_m != null) {
            for (ModelRenderer child : model.field_78805_m) {
                if (child == part) {
                    return true;
                }
                if (child.field_78805_m == null || !EyeUtil.modelContains(child, part)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends ModelBase> void renderEyes(RenderManager renderManager, T model, ModelRenderer leftEye, ModelRenderer rightEye, EntityLivingBase entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale, ResourceLocation pupilLeft, ResourceLocation pupilRight, ResourceLocation eyesClosed, boolean eyeTracking) {
        for (ModelRenderer box : model.field_78092_r) {
            if (box.field_78807_k) continue;
            boxesToUnhide.add(box);
            if (EyeUtil.modelContains(box, leftEye) || EyeUtil.modelContains(box, rightEye)) continue;
            box.field_78807_k = true;
        }
        if (entity instanceof IEntityEyesComponentProvider) {
            IEntityEyesComponent info = ((IEntityEyesComponentProvider)entity).getEyes();
            if (info.getTicksEyesClosed() <= 0) {
                float eyeCentering;
                leftEye.field_78807_k = false;
                rightEye.field_78807_k = false;
                float eyeTranslate = 0.0f;
                float f = eyeCentering = eyeTracking ? 0.03f : 0.0f;
                if (info.lookingAtEntity() != null && eyeTracking) {
                    double yawBetweenLookingEntity = EntityUtil.getYawFacingPosition((Entity)entity, info.lookingAtEntity().field_70165_t, info.lookingAtEntity().field_70161_v);
                    double yawDif = MathHelper.func_76138_g((double)(yawBetweenLookingEntity - (double)entity.field_70759_as));
                    double clampYawDif = MathHelper.func_151237_a((double)yawDif, (double)-45.0, (double)45.0);
                    float percent = (float)(clampYawDif / 90.0);
                    eyeTranslate = -0.05f * percent;
                }
                GlStateManager.func_179094_E();
                renderManager.field_78724_e.func_110577_a(pupilLeft);
                float oldOffsetX = leftEye.field_82906_o;
                float oldOffsetZ = leftEye.field_82907_q;
                leftEye.field_82906_o = -eyeCentering + eyeTranslate;
                leftEye.field_82907_q = -1.0E-4f;
                model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                leftEye.field_82906_o = oldOffsetX;
                leftEye.field_82907_q = oldOffsetZ;
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                renderManager.field_78724_e.func_110577_a(pupilRight);
                oldOffsetX = rightEye.field_82906_o;
                oldOffsetZ = rightEye.field_82907_q;
                rightEye.field_82906_o = eyeCentering + eyeTranslate;
                rightEye.field_82907_q = -1.0E-4f;
                model.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, (Entity)entity);
                model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                rightEye.field_82906_o = oldOffsetX;
                rightEye.field_82907_q = oldOffsetZ;
                GlStateManager.func_179121_F();
            } else {
                leftEye.field_78807_k = false;
                rightEye.field_78807_k = false;
                renderManager.field_78724_e.func_110577_a(eyesClosed);
                GlStateManager.func_179094_E();
                float oldOffsetZ = rightEye.field_82907_q;
                float oldOffsetZLeft = leftEye.field_82907_q;
                rightEye.field_82907_q = -1.0E-4f;
                leftEye.field_82907_q = -1.0E-4f;
                model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                rightEye.field_82907_q = oldOffsetZ;
                leftEye.field_82907_q = oldOffsetZLeft;
                GlStateManager.func_179121_F();
            }
        } else {
            throw new IllegalStateException("Entity " + entity + " does not implement IEntityEyesComponent");
        }
        for (ModelRenderer box : boxesToUnhide) {
            box.field_78807_k = false;
        }
        boxesToUnhide.clear();
    }

    public static <T extends ModelBaseAether> void renderEyesFast(T model, ModelRendererAether leftEye, ModelRendererAether rightEye, EntityLivingBase entity, float scale, ResourceLocation pupilLeft, ResourceLocation pupilRight, ResourceLocation eyesClosed, ResourceLocation beforeTexture, boolean eyeTracking) {
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        if (entity instanceof IEntityEyesComponentProvider) {
            IEntityEyesComponent info = ((IEntityEyesComponentProvider)entity).getEyes();
            if (info.getTicksEyesClosed() <= 0) {
                float eyeCentering;
                float eyeTranslate = 0.0f;
                float f = eyeCentering = eyeTracking ? 0.03f : 0.0f;
                if (info.lookingAtEntity() != null && eyeTracking) {
                    double yawBetweenLookingEntity = EntityUtil.getYawFacingPosition((Entity)entity, info.lookingAtEntity().field_70165_t, info.lookingAtEntity().field_70161_v);
                    double yawDif = MathHelper.func_76138_g((double)(yawBetweenLookingEntity - (double)entity.field_70759_as));
                    double clampYawDif = MathHelper.func_151237_a((double)yawDif, (double)-45.0, (double)45.0);
                    float percent = (float)(clampYawDif / 90.0);
                    eyeTranslate = -0.05f * percent;
                }
                renderManager.field_78724_e.func_110577_a(pupilLeft);
                float oldOffsetX = leftEye.field_82906_o;
                float oldOffsetZ = leftEye.field_82907_q;
                leftEye.field_82906_o = -eyeCentering + eyeTranslate;
                leftEye.field_82907_q = -1.0E-4f;
                leftEye.render(scale, true, false);
                leftEye.field_82906_o = oldOffsetX;
                leftEye.field_82907_q = oldOffsetZ;
                renderManager.field_78724_e.func_110577_a(pupilRight);
                oldOffsetX = rightEye.field_82906_o;
                oldOffsetZ = rightEye.field_82907_q;
                rightEye.field_82906_o = eyeCentering + eyeTranslate;
                rightEye.field_82907_q = -1.0E-4f;
                rightEye.render(scale, true, false);
                rightEye.field_82906_o = oldOffsetX;
                rightEye.field_82907_q = oldOffsetZ;
            } else {
                renderManager.field_78724_e.func_110577_a(eyesClosed);
                float oldOffsetZ = rightEye.field_82907_q;
                float oldOffsetZLeft = leftEye.field_82907_q;
                rightEye.field_82907_q = -1.0E-4f;
                leftEye.field_82907_q = -1.0E-4f;
                leftEye.render(scale, true, false);
                rightEye.render(scale, true, false);
            }
        } else {
            throw new IllegalStateException("Entity " + entity + " does not implement IEntityEyesComponent");
        }
        renderManager.field_78724_e.func_110577_a(beforeTexture);
    }

    public static <T extends ModelBaseAether> void renderEyesBasic(RenderManager renderManager, T model, EntityLivingBase entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale, ResourceLocation eyesClosed) {
        if (entity instanceof IEntityEyesComponentProvider) {
            IEntityEyesComponent info = ((IEntityEyesComponentProvider)entity).getEyes();
            if (info.getTicksEyesClosed() <= 0) {
                GlStateManager.func_179094_E();
                model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                model.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, (Entity)entity);
                model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179121_F();
            } else {
                renderManager.field_78724_e.func_110577_a(eyesClosed);
                GlStateManager.func_179094_E();
                model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179121_F();
            }
        } else {
            throw new IllegalStateException("Entity " + entity + " does not implement IEntityEyesComponent");
        }
    }
}

