/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.models.entities.player;

import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerPatronRewardModule;
import com.gildedgames.aether.common.patron.armor.PatronRewardArmor;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;

public class LayerAetherPatronArmor
implements LayerRenderer<EntityLivingBase> {
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();
    private final RenderLivingBase<?> renderer;
    private PatronRewardArmor previewArmor;
    private ModelBiped modelLeggings;
    private ModelBiped modelArmor;

    public LayerAetherPatronArmor(RenderLivingBase<?> rendererIn) {
        this.renderer = rendererIn;
        this.initArmor();
    }

    public void setPreviewArmor(PatronRewardArmor armor) {
        this.previewArmor = armor;
    }

    public void func_177141_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        PatronRewardArmor armor = this.previewArmor;
        if (armor == null) {
            PlayerAether aePlayer = PlayerAether.getPlayer((EntityPlayer)entity);
            armor = aePlayer.getModule(PlayerPatronRewardModule.class).getChoices().getArmorChoice();
        }
        if (armor != null && armor.getArmorTextureName() != null) {
            this.renderArmorLayer(entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.CHEST, armor.getArmorTextureName());
            this.renderArmorLayer(entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.LEGS, armor.getArmorTextureName());
            this.renderArmorLayer(entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.FEET, armor.getArmorTextureName());
            this.renderArmorLayer(entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.HEAD, armor.getArmorTextureName());
        }
    }

    public boolean func_177142_b() {
        return false;
    }

    protected void renderArmorLayer(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale, EntityEquipmentSlot slot, String res) {
        ResourceLocation texture = ARMOR_TEXTURE_RES_MAP.computeIfAbsent(AetherCore.getResourcePath("textures/armor/" + res + "_layer_" + (slot == EntityEquipmentSlot.LEGS ? 2 : 1) + ".png"), ResourceLocation::new);
        ModelBiped model = this.getModelFromSlot(slot);
        model.func_178686_a(this.renderer.func_177087_b());
        model.func_78086_a(entity, limbSwing, limbSwingAmount, partialTicks);
        this.setModelSlotVisible(model, slot);
        this.renderer.func_110776_a(texture);
        float alpha = 1.0f;
        float colorR = 1.0f;
        float colorG = 1.0f;
        float colorB = 1.0f;
        GlStateManager.func_179131_c((float)colorR, (float)colorG, (float)colorB, (float)alpha);
        model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    private ModelBiped getModelFromSlot(EntityEquipmentSlot slotIn) {
        return this.isLegSlot(slotIn) ? this.modelLeggings : this.modelArmor;
    }

    private boolean isLegSlot(EntityEquipmentSlot slotIn) {
        return slotIn == EntityEquipmentSlot.LEGS;
    }

    private void initArmor() {
        this.modelLeggings = new ModelBiped(0.5f);
        this.modelArmor = new ModelBiped(1.0f);
    }

    private void setModelSlotVisible(ModelBiped model, EntityEquipmentSlot slot) {
        this.setModelVisible(model);
        switch (slot) {
            case HEAD: {
                model.field_78116_c.field_78806_j = true;
                model.field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                model.field_78115_e.field_78806_j = true;
                model.field_178723_h.field_78806_j = true;
                model.field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                model.field_78115_e.field_78806_j = true;
                model.field_178721_j.field_78806_j = true;
                model.field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                model.field_178721_j.field_78806_j = true;
                model.field_178722_k.field_78806_j = true;
            }
        }
    }

    private void setModelVisible(ModelBiped model) {
        model.func_178719_a(false);
    }
}

