/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.gui.overlays;

import com.gildedgames.aether.client.gui.overlays.IOverlay;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerSwetTrackerModule;
import com.gildedgames.aether.common.entities.monsters.EntitySwet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class SwetOverlay
implements IOverlay {
    private final Minecraft mc = Minecraft.func_71410_x();

    @Override
    public boolean isEnabled() {
        return this.mc.field_71441_e != null;
    }

    @Override
    public void draw() {
        boolean hasBlue = false;
        boolean hasGreen = false;
        boolean hasPurple = false;
        PlayerAether player = PlayerAether.getPlayer((EntityPlayer)this.mc.field_71439_g);
        for (EntitySwet swet : player.getModule(PlayerSwetTrackerModule.class).getLatchedSwets()) {
            switch (swet.getType()) {
                case BLUE: {
                    hasBlue = true;
                    break;
                }
                case GREEN: {
                    hasGreen = true;
                    break;
                }
                case PURPLE: {
                    hasPurple = true;
                    break;
                }
            }
        }
        if (hasBlue) {
            this.drawSwet(EntitySwet.Type.BLUE);
        }
        if (hasGreen) {
            this.drawSwet(EntitySwet.Type.GREEN);
        }
        if (hasPurple) {
            this.drawSwet(EntitySwet.Type.PURPLE);
        }
    }

    private void drawSwet(EntitySwet.Type type) {
        ScaledResolution scaledRes = new ScaledResolution(this.mc);
        int y = scaledRes.func_78328_b() - 64;
        this.drawCorner(0, y, type.left1, type.left2, 2.0f);
        this.drawCorner((int)((float)scaledRes.func_78326_a() - 128.0f), y, type.right1, type.right2, 2.0f);
    }

    private void drawCorner(int x, int y, ResourceLocation corner1, ResourceLocation corner2, float scale) {
        float startRange = 0.1f;
        float endRange = 0.7f;
        float oscilationRange = 0.29999998f;
        float oscilationOffset = 0.39999998f;
        this.drawSingle(x, y, corner1, 0.39999998f + (float)Math.sin((double)System.currentTimeMillis() / 200.0) * 0.29999998f, scale);
        this.drawSingle(x, y, corner2, 0.39999998f + (float)Math.sin((double)System.currentTimeMillis() / 200.0 + 60.0) * 0.29999998f, scale);
    }

    private void drawSingle(int x, int y, ResourceLocation texture, float alpha, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179132_a((boolean)true);
        double width = 64.0;
        double height = 64.0;
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)(-(64.0 * (double)scale - 64.0)), (double)0.0);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        this.mc.func_110434_K().func_110577_a(texture);
        Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)64, (int)64, (float)64.0f, (float)64.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

