/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.gui.misc;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.patron.IPatronReward;
import com.gildedgames.aether.client.gui.misc.GuiPatronRewardEntry;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerPatronRewardModule;
import com.gildedgames.aether.common.patron.PatronChoices;
import com.gildedgames.aether.common.patron.PatronRewards;
import com.gildedgames.aether.common.patron.armor.PatronRewardArmor;
import com.gildedgames.orbis.lib.client.gui.data.Text;
import com.gildedgames.orbis.lib.client.gui.data.list.IListNavigator;
import com.gildedgames.orbis.lib.client.gui.data.list.IListNavigatorListener;
import com.gildedgames.orbis.lib.client.gui.data.list.ListNavigator;
import com.gildedgames.orbis.lib.client.gui.util.GuiAbstractButton;
import com.gildedgames.orbis.lib.client.gui.util.GuiText;
import com.gildedgames.orbis.lib.client.gui.util.GuiTexture;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiViewer;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiContext;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.gui.util.list.GuiListViewer;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.client.rect.RectHolder;
import com.gildedgames.orbis.lib.util.InputHelper;
import com.gildedgames.orbis.lib.util.mc.IText;
import java.io.IOException;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class GuiPatronRewards
extends GuiViewer
implements IListNavigatorListener<IPatronReward> {
    private static final ResourceLocation BACKDROP = AetherCore.getResource("textures/gui/patron/backdrop.png");
    private static final ResourceLocation QUESTION = AetherCore.getResource("textures/gui/patron/reward_question.png");
    private static final ResourceLocation QUESTION_HOVERED = AetherCore.getResource("textures/gui/patron/reward_question_hovered.png");
    private static final ResourceLocation USE = AetherCore.getResource("textures/gui/patron/reward_use.png");
    private static final ResourceLocation USE_HOVERED = AetherCore.getResource("textures/gui/patron/reward_use_hovered.png");
    private GuiListViewer<IPatronReward, GuiPatronRewardEntry> rewardViewer;
    private final IListNavigator<IPatronReward> rewards = new ListNavigator();
    private GuiText patronRewardText;
    private GuiAbstractButton use;
    private GuiAbstractButton question;
    private GuiTexture backdrop;
    private IPatronReward selected;
    private final PatronRewardArmor defaultArmor = new PatronRewardArmor("aether.reward.none.name", PatronRewards.armorIcon("none"), null, null, null, d -> true);
    private GuiText useText;
    private final PlayerPatronRewardModule patronRewards;
    private final Text useString = new Text((ITextComponent)new TextComponentTranslation("gui.aether.patreon.rewards.button.use", new Object[0]), 1.0f);
    private final Text lockedString = new Text((ITextComponent)new TextComponentTranslation("gui.aether.patreon.rewards.button.locked", new Object[0]), 1.0f);

    public GuiPatronRewards() {
        super((IGuiElement)new GuiElement(Dim2D.flush(), false));
        PlayerAether playerAether = PlayerAether.getPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        this.patronRewards = playerAether.getModule(PlayerPatronRewardModule.class);
        this.field_146291_p = true;
    }

    public void func_146281_b() {
        super.func_146281_b();
        GuiPatronRewardEntry.SELECTED_INDEX = -1;
    }

    public void build(IGuiContext context) {
        this.setDrawDefaultBackground(true);
        this.getViewing().dim().mod().width((float)this.field_146294_l).height((float)this.field_146295_m).flush();
        Pos2D center = InputHelper.getCenter().clone().addY(10.0f).flush();
        this.backdrop = new GuiTexture(Dim2D.build().width(256.0f).height(213.0f).pos(center).center(true).flush(), BACKDROP);
        this.patronRewardText = new GuiText(Dim2D.build().pos(center).addX(-83.0f).addY(-89.0f).flush(), (IText)new Text((ITextComponent)new TextComponentString("Cosmetic Patron Rewards"), 1.0f));
        this.use = new GuiAbstractButton(Dim2D.build().pos(center).addX(16.0f).addY(61.0f).width(70.0f).height(21.0f).flush(), new GuiTexture(Dim2D.build().width(70.0f).height(21.0f).flush(), USE), new GuiTexture(Dim2D.build().width(70.0f).height(21.0f).flush(), USE_HOVERED), new GuiTexture(Dim2D.build().width(70.0f).height(21.0f).flush(), USE), new GuiTexture(Dim2D.build().width(70.0f).height(21.0f).flush(), USE_HOVERED));
        this.useText = new GuiText(Dim2D.build().x(this.use.dim().originalState().width() / 2.0f).y(this.use.dim().originalState().height() / 2.0f).addY(1.0f).center(true).flush(), (IText)this.useString);
        this.question = new GuiAbstractButton(Dim2D.build().pos(center).addX(92.0f).addY(61.0f).width(21.0f).height(21.0f).flush(), new GuiTexture(Dim2D.build().width(21.0f).height(21.0f).flush(), QUESTION), new GuiTexture(Dim2D.build().width(21.0f).height(21.0f).flush(), QUESTION_HOVERED), new GuiTexture(Dim2D.build().width(21.0f).height(21.0f).flush(), QUESTION));
        this.rewardViewer = new GuiListViewer(Dim2D.build().width(110.0f).height(154.0f).pos(center).addX(-100.0f).addY(-71.0f).flush(), navigator -> navigator.getNodes().inverse().values().stream().max(Comparator.naturalOrder()).orElse(-1) + 1, this.rewards, (pos, node, index) -> {
            GuiPatronRewardEntry entry = new GuiPatronRewardEntry(node.getUnlocalizedName(), node.getRewardIcon(), index);
            entry.dim().mod().pos(pos).flush();
            return entry;
        }, i -> null, 22).allowModifications(false);
        this.rewards.addListener((IListNavigatorListener)this);
        this.rewards.put((Object)this.defaultArmor, 0, false);
        int i2 = 1;
        for (IPatronReward reward : AetherAPI.content().patronRewards().getRewards()) {
            this.rewards.put((Object)reward, i2, false);
            ++i2;
        }
        context.addChildren(new IGuiElement[]{this.backdrop, this.patronRewardText, this.use, this.question, this.rewardViewer});
        this.use.context().addChildren((IGuiElement)this.useText);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.selected != null) {
            GlStateManager.func_179094_E();
            this.selected.getPreviewRenderer().renderPreview(this.field_146294_l / 2 + 64, this.field_146295_m / 2 + 40);
            GlStateManager.func_179121_F();
        }
    }

    public void drawElements() {
        super.drawElements();
        if (this.selected != null) {
            if (this.selected.isUnlocked(this.patronRewards.getFeatures())) {
                this.useText.setText((IText)this.useString);
                this.use.state().setEnabled(true);
            } else {
                this.useText.setText((IText)this.lockedString);
                this.use.state().setEnabled(false);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (InputHelper.isHovered((RectHolder)this.use) && this.selected instanceof PatronRewardArmor) {
            PatronChoices choices = this.patronRewards.getChoices();
            if (this.selected == this.defaultArmor) {
                choices.setArmorChoice(null);
            } else if (choices.getArmorChoice() != this.selected) {
                choices.setArmorChoice((PatronRewardArmor)this.selected);
            }
        }
    }

    public void onRemoveNode(IPatronReward node, int index) {
    }

    public void onAddNode(IPatronReward node, int index, boolean newNode) {
    }

    public void onNodeClicked(IPatronReward node, int index) {
        this.selected = node;
        this.selected.getPreviewRenderer().renderInit();
    }
}

