/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.gui.misc;

import com.gildedgames.aether.client.events.listeners.gui.GuiLoadingListener;
import com.gildedgames.aether.client.gui.misc.CustomLoadingRenderer;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.util.helpers.MathUtil;
import com.gildedgames.orbis.lib.client.PartialTicks;
import com.gildedgames.orbis.lib.client.gui.data.Text;
import com.gildedgames.orbis.lib.client.gui.util.GuiText;
import com.gildedgames.orbis.lib.client.gui.util.GuiTexture;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiViewer;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiContext;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.util.InputHelper;
import com.gildedgames.orbis.lib.util.mc.IText;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import org.lwjgl.opengl.GL11;

public class GuiAetherLoading
extends GuiViewer
implements CustomLoadingRenderer.ICustomLoading {
    private static final String[] SPINNER_STATES = new String[]{"0oo", "o0o", "oo0"};
    private static final ResourceLocation HIGHLANDS = AetherCore.getResource("textures/gui/intro/highlands.png");
    private static final ResourceLocation HUE_BACKGROUND = AetherCore.getResource("textures/gui/intro/hue_background.png");
    public static float PERCENT = 0.0f;
    private GuiTexture highlands;
    private GuiText loading;
    private GuiText spinner;
    private float lastPercent;
    private long millis;

    public GuiAetherLoading() {
        super((IGuiElement)new GuiElement(Dim2D.flush(), false));
    }

    public void build(IGuiContext context) {
        this.getViewing().dim().mod().width((float)this.field_146294_l).height((float)this.field_146295_m).flush();
        Pos2D center = InputHelper.getCenter();
        this.highlands = new GuiTexture(Dim2D.build().scale(0.5f).width(512.0f).height(235.0f).center(true).pos(center).flush(), HIGHLANDS);
        this.loading = new GuiText(Dim2D.build().pos(InputHelper.getBottomLeft()).addY(-16.0f).addX(8.0f).flush(), (IText)new Text((ITextComponent)new TextComponentTranslation("gui.aether.loading.indeterminate", new Object[0]), 1.0f));
        this.spinner = new GuiText(Dim2D.build().pos(InputHelper.getBottomRight()).addY(-16.0f).addX(-24.0f).flush(), (IText)new Text((ITextComponent)new TextComponentString(SPINNER_STATES[0]), 1.0f));
        context.addChildren(new IGuiElement[]{this.highlands, this.loading, this.spinner});
        this.millis = System.currentTimeMillis();
    }

    public void drawElements() {
        GuiAetherLoading.preventInnerTyping();
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GL11.glEnable((int)3008);
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(HUE_BACKGROUND);
        GuiAetherLoading.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.field_146294_l, (int)this.field_146295_m, (float)this.field_146294_l, (float)this.field_146295_m);
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179121_F();
        if (this.field_146297_k.field_71441_e != null && !MathUtil.epsilonEquals(PERCENT, this.lastPercent) && PERCENT > 0.0f) {
            this.lastPercent = PERCENT;
            String percentString = String.valueOf(MathHelper.func_76141_d((float)PERCENT));
            this.loading.setText((IText)new Text((ITextComponent)new TextComponentTranslation("gui.aether.loading.progress", new Object[]{percentString}), 1.0f));
        }
        int spinnerStateIndex = (int)((System.currentTimeMillis() - this.millis) / 150L) % SPINNER_STATES.length;
        this.spinner.setText((IText)new Text((ITextComponent)new TextComponentString(SPINNER_STATES[spinnerStateIndex]), 1.0f));
        super.drawElements();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GuiLoadingListener.drawFade(false);
    }

    @Override
    public void drawCustomLoading() {
        this.func_73863_a(InputHelper.getMouseX(), InputHelper.getMouseY(), PartialTicks.get());
    }
}

