/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.gui.dialog;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.player.IPlayerAether;
import com.gildedgames.aether.client.gui.dialog.GuiExpandableCoinTab;
import com.gildedgames.aether.client.gui.dialog.GuiFlatButton;
import com.gildedgames.aether.client.gui.dialog.GuiTextBox;
import com.gildedgames.aether.client.gui.util.IRemoteClose;
import com.gildedgames.aether.client.gui.util.ToolTipCurrencyHelper;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerCurrencyModule;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerTradeModule;
import com.gildedgames.aether.common.containers.ContainerTrade;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.trade.PacketChangeCoinAmount;
import com.gildedgames.aether.common.network.packets.trade.PacketTradeMessage;
import com.gildedgames.aether.common.shop.ShopCurrencyGilt;
import com.gildedgames.orbis.lib.client.gui.util.GuiAbstractButton;
import com.gildedgames.orbis.lib.client.gui.util.GuiTexture;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiViewer;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiContext;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiEvent;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiViewer;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.client.rect.RectHolder;
import com.gildedgames.orbis.lib.util.InputHelper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiTrade
extends GuiViewer
implements IRemoteClose {
    private static final ResourceLocation INVENTORY = AetherCore.getResource("textures/gui/trade/inventory.png");
    private static final ResourceLocation TRADE_INVENTORY = AetherCore.getResource("textures/gui/trade/trade.png");
    private static final ResourceLocation TRADE_VIEW = AetherCore.getResource("textures/gui/trade/view.png");
    private static final ResourceLocation LEFT_ARROW = AetherCore.getResource("textures/gui/trade/left_button.png");
    private static final ResourceLocation LEFT_ARROW_HOVER = AetherCore.getResource("textures/gui/trade/left_button_hover.png");
    private static final ResourceLocation RIGHT_ARROW = AetherCore.getResource("textures/gui/trade/right_button.png");
    private static final ResourceLocation RIGHT_ARROW_HOVER = AetherCore.getResource("textures/gui/trade/right_button_hover.png");
    private static final ResourceLocation SLOT_BLOCKED = AetherCore.getResource("textures/gui/trade/prevent_tile.png");
    private static final ToolTipCurrencyHelper TOOLTIP_HELPER = new ToolTipCurrencyHelper();
    private final NonNullList<ItemStack> offeredContents;
    private final List<TradeChatLine> chatLines = Lists.newArrayList();
    private final PlayerAether playerAether;
    private final PlayerTradeModule module;
    private final String lockinLocalText;
    private final String unlockLocalText;
    private GuiAbstractButton leftArrow;
    private GuiAbstractButton rightArrow;
    private GuiExpandableCoinTab coinTab;
    private GuiExpandableCoinTab tradeTab;
    private GuiExpandableCoinTab viewTab;
    private GuiTextBox tradePlate;
    private GuiTextBox tradeStatus;
    private GuiFlatButton lockStateButton;
    private GuiFlatButton confirmButton;
    private GuiTextField textField;
    private boolean pressLongEnough;
    private boolean rightArrowHeld;
    private boolean leftArrowHeld;
    private boolean labelUpdated;
    private long lastBuyCountChangeTime;
    private double transferCoins;
    private double viewValue;

    public GuiTrade(GuiViewer prevViewer, EntityPlayer player) {
        super((IGuiElement)new GuiElement(Dim2D.flush(), false), (IGuiViewer)prevViewer, (Container)new ContainerTrade(player.field_71071_by));
        this.playerAether = PlayerAether.getPlayer(player);
        this.module = this.playerAether.getModule(PlayerTradeModule.class);
        this.offeredContents = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
        this.lockinLocalText = I18n.func_135052_a((String)"aether.trade.gui.lock", (Object[])new Object[0]);
        this.unlockLocalText = I18n.func_135052_a((String)"aether.trade.gui.unlock", (Object[])new Object[0]);
    }

    public void initContainerSize() {
        Pos2D center = InputHelper.getCenter().clone().addX(15.0f).flush();
        this.field_147003_i = (int)center.x() - 189 - 7;
        this.field_147009_r = this.field_146295_m - 198 - 14;
        this.field_146999_f = 385;
        this.field_147000_g = 180;
    }

    public void build(IGuiContext context) {
        this.getViewing().dim().mod().width(300.0f).height(300.0f).flush();
        Pos2D center = InputHelper.getCenter().clone().flush();
        GuiTexture inventory = new GuiTexture(Dim2D.build().center(true).width(176.0f).height(110.0f).pos(center).y((float)this.field_146295_m).addX(-98.0f).addY(-157.0f).flush(), INVENTORY);
        GuiTexture tradeInventory = new GuiTexture(Dim2D.build().center(true).width(86.0f).height(110.0f).pos(center).y((float)this.field_146295_m).addX(54.0f).addY(-157.0f).flush(), TRADE_INVENTORY);
        tradeInventory.state().addEvent(new IGuiEvent(){

            public void onPostDraw(IGuiElement element) {
                GlStateManager.func_179094_E();
                GuiTrade.this.field_146297_k.func_110434_K().func_110577_a(SLOT_BLOCKED);
                for (int i = GuiTrade.this.module.getTradeSlots(); i < 16; ++i) {
                    Gui.func_146110_a((int)(GuiTrade.this.field_147003_i + 199 + i % 4 * 18), (int)(GuiTrade.this.field_146295_m - 183 + i / 4 * 18), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
                }
                GlStateManager.func_179121_F();
            }
        });
        GuiTexture tradeView = new GuiTexture(Dim2D.build().center(true).width(86.0f).height(110.0f).pos(center).y((float)this.field_146295_m).addX(147.0f).addY(-157.0f).flush(), TRADE_VIEW);
        tradeView.state().addEvent(new IGuiEvent(){

            public void onPostDraw(IGuiElement element) {
                GlStateManager.func_179094_E();
                GuiTrade.this.field_146297_k.func_110434_K().func_110577_a(SLOT_BLOCKED);
                for (int i = GuiTrade.this.module.getOpenSlots(); i < 16; ++i) {
                    Gui.func_146110_a((int)(GuiTrade.this.field_147003_i + 292 + i % 4 * 18), (int)(GuiTrade.this.field_146295_m - 183 + i / 4 * 18), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
                }
                GlStateManager.func_179121_F();
            }
        });
        this.leftArrow = new GuiAbstractButton(Dim2D.build().width(9.0f).height(15.0f).pos(center).y((float)this.field_146295_m).addX(-9.0f).addY(-205.0f).flush(), new GuiTexture(Dim2D.build().width(9.0f).height(15.0f).flush(), LEFT_ARROW), new GuiTexture(Dim2D.build().width(9.0f).height(15.0f).flush(), LEFT_ARROW_HOVER), new GuiTexture(Dim2D.build().width(9.0f).height(15.0f).flush(), LEFT_ARROW));
        this.rightArrow = new GuiAbstractButton(Dim2D.build().width(9.0f).height(15.0f).pos(center).y((float)this.field_146295_m).addX(1.0f).addY(-205.0f).flush(), new GuiTexture(Dim2D.build().width(9.0f).height(15.0f).flush(), RIGHT_ARROW), new GuiTexture(Dim2D.build().width(9.0f).height(15.0f).flush(), RIGHT_ARROW_HOVER), new GuiTexture(Dim2D.build().width(9.0f).height(15.0f).flush(), RIGHT_ARROW));
        this.coinTab = new GuiExpandableCoinTab(Dim2D.build().width(9.0f).height(15.0f).flush(), true, true, false, -15.0f, this.field_146295_m - 212);
        this.tradeTab = new GuiExpandableCoinTab(Dim2D.build().width(9.0f).height(15.0f).flush(), true, false, false, 17.0f, this.field_146295_m - 212);
        this.viewTab = new GuiExpandableCoinTab(Dim2D.build().width(9.0f).height(15.0f).flush(), true, true, false, 185.0f, this.field_146295_m - 212);
        context.addChildren(new IGuiElement[]{inventory, tradeInventory, tradeView, this.leftArrow, this.rightArrow, this.coinTab, this.tradeTab, this.viewTab});
        String name = I18n.func_135052_a((String)"aether.trade.gui.firsttrade", (Object[])new Object[0]);
        String nameOther = I18n.func_135052_a((String)"aether.trade.gui.thirdtrade", (Object[])new Object[]{""});
        String status = I18n.func_135052_a((String)"aether.trade.status.waitingboth", (Object[])new Object[0]);
        TextComponentTranslation clientTextComp = new TextComponentTranslation(name, new Object[0]);
        TextComponentTranslation traderTextComp = new TextComponentTranslation(nameOther, new Object[0]);
        TextComponentTranslation statusComp = new TextComponentTranslation(status, new Object[0]);
        this.tradePlate = new GuiTextBox(0, (int)center.x() + 104, this.field_146295_m - 229, 86, 15);
        this.tradeStatus = new GuiTextBox(0, this.field_146294_l - 88, this.field_146295_m - 60, 76, 40);
        GuiTextBox namePlate = new GuiTextBox(0, (int)center.x() + 10, this.field_146295_m - 229, 86, 15);
        clientTextComp.func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW).func_150217_b(Boolean.valueOf(true)));
        traderTextComp.func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW).func_150217_b(Boolean.valueOf(true)));
        statusComp.func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
        this.tradePlate.setText((ITextComponent)traderTextComp);
        this.tradePlate.setCentered(true);
        this.tradeStatus.setText((ITextComponent)statusComp);
        this.tradeStatus.setCentered(true);
        namePlate.setText((ITextComponent)clientTextComp);
        namePlate.setCentered(true);
        this.field_146292_n.add(this.tradePlate);
        this.field_146292_n.add(this.tradeStatus);
        this.field_146292_n.add(namePlate);
        this.lockStateButton = new GuiFlatButton(1, this.field_146294_l - 88, this.field_146295_m - 80, 25, 15, this.lockinLocalText);
        String unlockText = I18n.func_135052_a((String)"aether.trade.gui.confirm", (Object[])new Object[0]);
        this.confirmButton = new GuiFlatButton(2, this.field_146294_l - 88, this.field_146295_m - 17, 37, 15, unlockText);
        this.confirmButton.field_146124_l = false;
        this.textField = new GuiTextField(0, this.field_146289_q, 4, this.field_146295_m - 12, this.field_146294_l - 104, 12);
        this.textField.func_146203_f(256);
        this.textField.func_146185_a(false);
        this.field_146292_n.add(this.lockStateButton);
        this.field_146292_n.add(this.confirmButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || !this.textField.func_146201_a(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
        if (keyCode == 28 && !this.textField.func_146179_b().isEmpty()) {
            String text = this.textField.func_146179_b();
            NetworkingAether.sendPacketToServer(new PacketTradeMessage(text));
            this.sendTradeMessage(this.playerAether.getEntity(), (ITextComponent)new TextComponentString(this.textField.func_146179_b()));
            this.textField.func_146180_a("");
        }
    }

    public void sendTradeMessage(EntityPlayer sender, ITextComponent textComponent) {
        TextComponentString name = new TextComponentString("<" + sender.getDisplayNameString() + "> ");
        this.sendMessage(name.func_150257_a(textComponent));
    }

    public void sendMessage(ITextComponent textComponent) {
        List split = GuiUtilRenderComponents.func_178908_a((ITextComponent)textComponent, (int)(this.field_146294_l - 104), (FontRenderer)this.field_146289_q, (boolean)true, (boolean)true);
        for (ITextComponent text : split) {
            this.chatLines.add(new TradeChatLine(text));
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.rightArrowHeld = false;
        this.leftArrowHeld = false;
        this.lastBuyCountChangeTime = 0L;
        this.pressLongEnough = false;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (InputHelper.isHovered((RectHolder)this.rightArrow)) {
            this.addTradeCoins(1.0);
            this.rightArrowHeld = true;
            this.lastBuyCountChangeTime = System.currentTimeMillis();
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                this.addTradeCoins(64.0);
            }
        }
        if (InputHelper.isHovered((RectHolder)this.leftArrow)) {
            this.leftArrowHeld = true;
            this.addTradeCoins(-1.0);
            this.lastBuyCountChangeTime = System.currentTimeMillis();
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                this.addTradeCoins(-64.0);
            }
        }
        this.textField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int scroll = MathHelper.func_76125_a((int)Mouse.getEventDWheel(), (int)-1, (int)1);
        if (scroll != 0 && (InputHelper.isHovered((RectHolder)this.rightArrow) || InputHelper.isHovered((RectHolder)this.leftArrow))) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                this.addTradeCoins(scroll * 64);
            } else {
                this.addTradeCoins(scroll);
            }
        }
    }

    private void addTradeCoins(double val) {
        if (this.module.isLockedIn()) {
            return;
        }
        long currency = this.playerAether.getModule(PlayerCurrencyModule.class).getCurrencyValue();
        this.transferCoins += val;
        if (this.transferCoins > (double)currency) {
            this.transferCoins = currency;
        }
        if (this.transferCoins < 0.0) {
            this.transferCoins = 0.0;
        }
        NetworkingAether.sendPacketToServer(new PacketChangeCoinAmount(this.transferCoins));
    }

    public void setCoinCount(double count) {
        this.viewTab.setCurrencyValue(count);
    }

    private void renderToolTip(int x, int y) {
        ItemStack stack = null;
        Slot hoveredSlot = this.getSlotUnderMouse();
        if (hoveredSlot != null && hoveredSlot.func_75216_d()) {
            stack = hoveredSlot.func_75211_c();
        } else {
            for (int i = 0; i < 16; ++i) {
                ItemStack offeredStack = (ItemStack)this.offeredContents.get(i);
                if (offeredStack.func_190926_b()) continue;
                int slotX = this.field_147003_i + 293 + i % 4 * 18;
                int slotY = this.field_146295_m - 182 + i / 4 * 18;
                if (x < slotX || x >= slotX + 18 || y < slotY || y >= slotY + 18) continue;
                stack = offeredStack;
            }
        }
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && stack != null) {
            FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
            FontRenderer renderer = font == null ? this.field_146289_q : font;
            GuiUtils.preItemToolTip((ItemStack)stack);
            List stackText = this.func_191927_a(stack);
            this.drawHoveringText(stackText, x, y, renderer);
            GuiUtils.postItemToolTip();
        }
    }

    public void func_73876_c() {
        this.textField.func_146178_a();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        Gui.func_73734_a((int)0, (int)(this.field_146295_m - 90), (int)this.field_146294_l, (int)this.field_146295_m, (int)Integer.MIN_VALUE);
        if (!this.labelUpdated) {
            this.updateTraderLabel();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        if (this.field_147002_h instanceof ContainerTrade) {
            ContainerTrade container = (ContainerTrade)this.field_147002_h;
            container.updateSlots(this.module.getTradeSlots());
        }
        for (int i = 0; i < 16; ++i) {
            ItemStack stack = (ItemStack)this.offeredContents.get(i);
            this.drawItemStack(stack, this.field_147003_i + 293 + i % 4 * 18, this.field_146295_m - 182 + i / 4 * 18);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        this.renderToolTip(mouseX, mouseY);
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if ((this.rightArrowHeld || this.leftArrowHeld) && !this.pressLongEnough && System.currentTimeMillis() - this.lastBuyCountChangeTime >= 300L) {
            this.lastBuyCountChangeTime = System.currentTimeMillis();
            this.pressLongEnough = true;
        }
        if (this.pressLongEnough && System.currentTimeMillis() - this.lastBuyCountChangeTime >= 50L) {
            this.lastBuyCountChangeTime = System.currentTimeMillis();
            if (this.rightArrowHeld) {
                this.addTradeCoins(1.0);
            } else if (this.leftArrowHeld) {
                this.addTradeCoins(-1.0);
            }
        }
        long currency = this.playerAether.getModule(PlayerCurrencyModule.class).getCurrencyValue();
        if (this.coinTab != null) {
            this.coinTab.setCurrencyValue((double)currency - this.transferCoins);
        }
        if (this.tradeTab != null) {
            this.tradeTab.setCurrencyValue(this.transferCoins);
        }
        Gui.func_73734_a((int)2, (int)(this.field_146295_m - 14), (int)(this.field_146294_l - 102), (int)(this.field_146295_m - 2), (int)Integer.MIN_VALUE);
        Gui.func_73734_a((int)2, (int)(this.field_146295_m - 80), (int)(this.field_146294_l - 102), (int)(this.field_146295_m - 16), (int)Integer.MIN_VALUE);
        this.textField.func_146194_f();
        for (int i = 0; i < Math.min(7, this.chatLines.size()); ++i) {
            TradeChatLine tradeChatLine = this.chatLines.get(this.chatLines.size() - i - 1);
            int y = this.field_146295_m - 25 - this.field_146289_q.field_78288_b * i;
            if (tradeChatLine instanceof TriggerChatLine) {
                this.func_73731_b(this.field_146289_q, tradeChatLine.text.func_150260_c(), 4, y - this.field_146289_q.field_78288_b / 2, 0xFFFFFF);
                ++i;
                continue;
            }
            this.func_73731_b(this.field_146289_q, tradeChatLine.text.func_150260_c(), 4, y, 0xFFFFFF);
        }
        double value = 0.0;
        if (this.tradeTab.intersected(mouseX, mouseY)) {
            value = this.module.getValue();
        } else if (this.viewTab.intersected(mouseX, mouseY)) {
            value = this.viewValue;
        }
        if (value != 0.0) {
            List<String> text = TOOLTIP_HELPER.getText(value);
            int i = 0;
            for (String s : text) {
                int j = this.field_146289_q.func_78256_a(s);
                if (j <= i) continue;
                i = j;
            }
            int l1 = mouseX + 12;
            int i2 = mouseY - 12;
            int k = 8;
            if (text.size() > 1) {
                k += 2 + (text.size() - 1) * 10;
            }
            if (l1 + i + 4 > this.field_146294_l) {
                l1 -= 28 + i;
            }
            if (i2 + k + 6 > this.field_146295_m) {
                i2 = this.field_146295_m - k - 6;
            }
            this.func_146283_a(text, mouseX, mouseY);
            TOOLTIP_HELPER.render(this.field_146289_q, l1, i2, 8 + (text.size() - 1) * 10, value);
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, null);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    @Override
    public int getConfirmID() {
        return 14;
    }

    protected void func_146284_a(GuiButton button) {
        boolean locked = this.module.isLockedIn();
        if (button.field_146127_k == 1) {
            this.module.setLockedIn(!locked);
            this.updateLockedButton();
        } else if (button.field_146127_k == 2 && locked) {
            this.module.setConfirmed(true);
        }
    }

    private void updateLockedButton() {
        this.lockStateButton.setText(this.module.isLockedIn() ? this.unlockLocalText : this.lockinLocalText);
        this.lockStateButton.field_146128_h = this.field_146294_l - (this.module.isLockedIn() ? 85 : 88);
    }

    public void setTradeOffer(List<Pair<Integer, ItemStack>> changes) {
        int count = 0;
        this.viewValue = 0.0;
        for (Pair<Integer, ItemStack> pair : changes) {
            this.viewValue += AetherAPI.content().currency().getValue((ItemStack)pair.getValue(), ShopCurrencyGilt.class);
            this.offeredContents.set(((Integer)pair.getKey()).intValue(), pair.getValue());
            ++count;
        }
        for (int i = count; i < this.offeredContents.size(); ++i) {
            this.offeredContents.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public void setTradeState(int state) {
        String append;
        this.updateLockedButton();
        String string = append = state < 3 ? "waiting" : "confirm";
        if (state == -1) {
            this.lockStateButton.field_146124_l = false;
            append = "sizeerror";
        } else {
            this.lockStateButton.field_146124_l = true;
            int modState = state % 3;
            append = modState == 0 ? append + "both" : (modState == 1 ? append + "you" : append + "them");
        }
        this.confirmButton.field_146124_l = state >= 3 && state < 5;
        String status = I18n.func_135052_a((String)("aether.trade.status." + append), (Object[])new Object[0]);
        TextComponentTranslation statusComp = new TextComponentTranslation(status, new Object[0]);
        statusComp.func_150255_a(new Style().func_150238_a(state == -1 ? TextFormatting.RED : TextFormatting.YELLOW));
        this.tradeStatus.setText((ITextComponent)statusComp);
    }

    private void updateTraderLabel() {
        IPlayerAether target = this.module.getTarget();
        if (target != null) {
            String nameOther = I18n.func_135052_a((String)"aether.trade.gui.thirdtrade", (Object[])new Object[]{target.getEntity().getDisplayNameString()});
            TextComponentTranslation traderTextComp = new TextComponentTranslation(nameOther, new Object[0]);
            traderTextComp.func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW).func_150217_b(Boolean.valueOf(true)));
            int count = GuiUtilRenderComponents.func_178908_a((ITextComponent)traderTextComp, (int)(this.tradePlate.field_146120_f - 10), (FontRenderer)this.field_146289_q, (boolean)true, (boolean)true).size() - 1;
            this.tradePlate.field_146129_i = this.field_146295_m - 229 - this.field_146289_q.field_78288_b * count;
            this.tradePlate.setText((ITextComponent)traderTextComp);
            this.labelUpdated = true;
        }
    }

    public String getTrader() {
        return this.module.getTarget().getEntity().getDisplayNameString();
    }

    class TriggerChatLine
    extends TradeChatLine {
        protected int id;

        public TriggerChatLine(int id, ITextComponent text) {
            super(text);
            this.id = id;
        }
    }

    class TradeChatLine {
        protected ITextComponent text;

        public TradeChatLine(ITextComponent text) {
            this.text = text;
        }
    }
}

