/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.gui.dialog;

import com.gildedgames.aether.api.shop.IGuiCurrencyValue;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.orbis.lib.client.gui.data.Text;
import com.gildedgames.orbis.lib.client.gui.util.GuiText;
import com.gildedgames.orbis.lib.client.gui.util.GuiTexture;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.client.rect.Rect;
import com.gildedgames.orbis.lib.util.mc.IText;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class GuiPumpkinCurrency
extends GuiElement
implements IGuiCurrencyValue {
    private static final ResourceLocation COIN_ICON = AetherCore.getResource("textures/gui/shop/plumproot_coin.png");
    private PlumprootCount plumprootCount;

    public GuiPumpkinCurrency(Rect rect) {
        super(rect, true);
        this.dim().mod().width(51.0f).height(19.0f).flush();
    }

    @Override
    public void setCurrencyValue(double value) {
        this.plumprootCount.setCount(value);
        this.plumprootCount.state().setVisible(true);
        Pos2D center = Pos2D.flush((float)(this.dim().width() / 2.0f), (float)(this.dim().height() / 2.0f));
        this.plumprootCount.dim().mod().pos(center).center(true).flush();
    }

    @Override
    public void setNonFilteredCurrencyValue(double value) {
    }

    public void build() {
        this.plumprootCount = new PlumprootCount(Dim2D.build().width(7.0f).height(7.0f).addX(0.0f).addY(0.0f).flush(), COIN_ICON);
        this.context().addChildren((IGuiElement)this.plumprootCount);
    }

    private static class PlumprootCount
    extends GuiElement {
        private GuiTexture icon;
        private final ResourceLocation iconResource;
        private GuiText count;

        public PlumprootCount(Rect rect, ResourceLocation icon) {
            super(rect, false);
            this.iconResource = icon;
        }

        public void setCount(double count) {
            String text = count < 1.0 && count > 0.0 ? TextFormatting.GRAY + String.format("%.2f", count) : String.valueOf((int)count);
            this.count.setText((IText)new Text((ITextComponent)new TextComponentString(text), 1.0f));
            this.dim().mod().width((float)(9 + this.viewer().fontRenderer().func_78256_a(text))).height(8.0f).flush();
        }

        public void build() {
            this.icon = new GuiTexture(Dim2D.build().width(7.0f).height(7.0f).addX(0.0f).addY(0.0f).flush(), this.iconResource);
            this.count = new GuiText(Dim2D.build().addX(9.0f).addY(0.0f).flush(), (IText)new Text((ITextComponent)new TextComponentString(String.valueOf(0)), 1.0f));
            this.context().addChildren(new IGuiElement[]{this.icon, this.count});
        }
    }
}

