/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.gui.dialog;

import com.gildedgames.aether.client.gui.dialog.GuiCoins;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.orbis.lib.client.gui.util.GuiTexture;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.client.rect.Rect;
import com.gildedgames.orbis.lib.util.InputHelper;
import net.minecraft.util.ResourceLocation;

public class GuiExpandableCoinTab
extends GuiElement {
    private static final ResourceLocation GILT_BAG = AetherCore.getResource("textures/gui/shop/gilt_bag.png");
    private static final ResourceLocation GILT_GROW = AetherCore.getResource("textures/gui/trade/gilt_grow.png");
    private static final ResourceLocation GILT_GROW_LEFT = AetherCore.getResource("textures/gui/trade/gilt_grow_left.png");
    private static final ResourceLocation GILT_GROW_RIGHT = AetherCore.getResource("textures/gui/trade/gilt_grow_right.png");
    private GuiCoins coinsCount;
    private GuiTexture giltBag;
    private GuiTexture shape;
    private GuiTexture extent;
    private boolean left;
    private boolean inactive;
    private float x;
    private float y;
    private float width;

    public GuiExpandableCoinTab(Rect rect, boolean shouldDisplayAlways, boolean left, boolean inactive, float x, float y) {
        super(rect, shouldDisplayAlways);
        this.left = left;
        this.inactive = inactive;
        this.x = x;
        this.y = y;
    }

    public void build() {
        this.giltBag = new GuiTexture(Dim2D.build().width(16.0f).height(16.0f).flush(), GILT_BAG);
        this.coinsCount = new GuiCoins(Dim2D.build().flush(), true);
        this.extent = new GuiTexture(Dim2D.build().width(1.0f).height(23.0f).flush(), GILT_GROW);
        this.shape = this.left ? new GuiTexture(Dim2D.build().width(3.0f).height(23.0f).flush(), GILT_GROW_LEFT) : new GuiTexture(Dim2D.build().width(3.0f).height(23.0f).flush(), GILT_GROW_RIGHT);
        this.update();
        this.context().addChildren(new IGuiElement[]{this.shape, this.extent, this.coinsCount, this.giltBag});
    }

    private void update() {
        Pos2D center = InputHelper.getCenter().clone().flush();
        float off = this.coinsCount.dim().width();
        this.dim().mod().pos(center).addX(this.x - (this.left ? off : 0.0f)).y(this.y).flush();
        this.giltBag.dim().mod().pos(this.left ? -18.0f : off + 2.0f, 4.0f).flush();
        this.coinsCount.dim().mod().pos(0.0f, 4.0f).flush();
        this.extent.dim().mod().width(off + 21.0f).pos((float)(this.left ? -19 : -2), 0.0f).flush();
        if (this.left) {
            this.shape.dim().mod().pos(-22.0f, 0.0f).flush();
        } else {
            this.shape.dim().mod().pos(off + 19.0f, 0.0f).flush();
        }
        this.width = off + 27.0f;
    }

    public boolean intersected(int mouseX, int mouseY) {
        Pos2D center = InputHelper.getCenter().clone().flush();
        float off = this.left ? this.width - 12.0f : 0.0f;
        return (float)mouseX > center.x() - 7.0f + this.x - off && (float)mouseX < center.x() - 7.0f + this.x - off + this.width && (float)mouseY > this.y && (float)mouseY < this.y + 21.0f;
    }

    public void setCurrencyValue(double value) {
        this.coinsCount.setCurrencyValue(value);
        this.update();
    }
}

