/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.gui.dialog;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.dialog.IDialogButton;
import com.gildedgames.aether.api.dialog.IDialogChangeListener;
import com.gildedgames.aether.api.dialog.IDialogController;
import com.gildedgames.aether.api.dialog.IDialogLine;
import com.gildedgames.aether.api.dialog.IDialogNode;
import com.gildedgames.aether.api.dialog.IDialogSlide;
import com.gildedgames.aether.api.dialog.IDialogSlideRenderer;
import com.gildedgames.aether.api.dialog.IDialogSpeaker;
import com.gildedgames.aether.api.dialog.ISceneInstance;
import com.gildedgames.aether.client.gui.dialog.GuiDialogButton;
import com.gildedgames.aether.client.gui.dialog.GuiTextBox;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.containers.ContainerDialogController;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiViewer;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiContext;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.Sys;
import org.lwjgl.input.Mouse;

public class GuiDialogViewer
extends GuiViewer
implements IDialogChangeListener {
    private static final ResourceLocation NEXT_ARROW = AetherCore.getResource("textures/gui/conversation/next_arrow.png");
    public static boolean preventDialogControllerClose;
    private final IDialogController controller;
    private final LinkedList<GuiDialogButton> buttons = Lists.newLinkedList();
    private GuiTextBox topTextBox;
    private GuiTextBox bottomTextBox;
    private GuiTextBox namePlate;
    private double nextArrowAnim;
    private double prevTime;
    private boolean canApplyNextAction = true;
    private IDialogNode node;
    private IDialogSpeaker speaker;
    private IDialogSlide slide;
    private IDialogSlideRenderer renderer;
    private int currentScroll;
    private int maxScroll;
    private ISceneInstance sceneInstance;

    public GuiDialogViewer(EntityPlayer player, IDialogController controller, ISceneInstance sceneInstance) {
        super((IGuiElement)new GuiElement(Dim2D.flush(), false), null, (Container)new ContainerDialogController(player));
        this.sceneInstance = sceneInstance;
        this.controller = controller;
        this.controller.addListener(this);
        this.setDrawDefaultBackground(false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146270_b(0);
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((GuiScreen)this));
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.slide != null && this.renderer != null) {
            this.renderer.draw(this.slide, this.field_146294_l, this.field_146295_m, mouseX, mouseY, partialTicks);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
        Gui.func_73734_a((int)0, (int)(this.field_146295_m - 90), (int)this.field_146294_l, (int)this.field_146295_m, (int)Integer.MIN_VALUE);
        if (this.maxScroll > 0 && this.controller.isNodeFinished() && this.controller.getCurrentNode().getButtons().size() > 0) {
            int baseBoxSize = 350;
            int x = this.field_146294_l / 2 - baseBoxSize / 2;
            int y = this.field_146295_m - 85;
            Gui.func_73734_a((int)(x - 17), (int)(this.field_146295_m - 85), (int)(x - 7), (int)(this.field_146295_m - 10), (int)Integer.MIN_VALUE);
            int scrollYOffset = this.currentScroll == 0 ? 0 : MathHelper.func_76141_d((float)((float)this.currentScroll * (55.0f / (float)this.maxScroll)));
            Gui.func_73734_a((int)(x - 17), (int)(y + scrollYOffset), (int)(x - 7), (int)(y + 20 + scrollYOffset), (int)-1761607681);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        if (!this.controller.isNodeFinished() || this.controller.isNodeFinished() && this.node.getButtons().isEmpty()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179097_i();
            double time = Sys.getTime() * 1000L / Sys.getTimerResolution();
            double timePassed = time - this.prevTime;
            this.prevTime = time;
            this.nextArrowAnim = this.nextArrowAnim < 1000.0 ? (this.nextArrowAnim += timePassed) : 0.0;
            double anim = this.nextArrowAnim;
            if (this.nextArrowAnim < 500.0) {
                GlStateManager.func_179137_b((double)0.0, (double)(anim / 500.0), (double)0.0);
            } else if (this.nextArrowAnim >= 500.0) {
                GlStateManager.func_179137_b((double)0.0, (double)(-((anim - 500.0) / 500.0)), (double)0.0);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)302.0f);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(NEXT_ARROW);
            if (this.controller.isNodeFinished() && this.controller.getCurrentNode().getButtons().size() > 0) {
                Gui.func_146110_a((int)(this.topTextBox.field_146128_h + this.topTextBox.field_146120_f + 5), (int)(this.topTextBox.field_146129_i + this.topTextBox.field_146121_g - 20), (float)0.0f, (float)0.0f, (int)13, (int)12, (float)13.0f, (float)12.0f);
            } else {
                Gui.func_146110_a((int)(this.bottomTextBox.field_146128_h + this.bottomTextBox.field_146120_f), (int)(this.bottomTextBox.field_146129_i + this.bottomTextBox.field_146121_g - 20), (float)0.0f, (float)0.0f, (int)13, (int)12, (float)13.0f, (float)12.0f);
            }
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
    }

    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    }

    public void func_146276_q_() {
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof GuiDialogButton) {
            GuiDialogButton dialogButton = (GuiDialogButton)button;
            this.controller.activateButton(dialogButton.getButtonData());
            if (this.controller.getCurrentScene() == null) {
                Minecraft.func_71410_x().func_147108_a(null);
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.buildGui(this.controller.getCurrentNode());
    }

    private void resetGui() {
        this.field_146292_n.clear();
    }

    private void buildGui(IDialogNode node) {
        boolean resize;
        if (this.node != node) {
            this.canApplyNextAction = false;
        }
        this.node = node;
        this.resetGui();
        if (this.field_146297_k == null) {
            return;
        }
        Collection<IDialogButton> beforeConditionButtons = node.getButtons();
        int baseBoxSize = 350;
        boolean bl = resize = this.field_146294_l - 40 > baseBoxSize;
        if (!resize) {
            baseBoxSize = this.field_146294_l - 40;
        }
        if (this.controller.isNodeFinished()) {
            this.buttons.clear();
            int index = 0;
            for (IDialogButton btn : beforeConditionButtons) {
                if (!this.controller.conditionsMet(btn)) continue;
                GuiDialogButton button = new GuiDialogButton(index, this.field_146294_l / 2 - baseBoxSize / 2, this.field_146295_m - 85 + index * 20, btn);
                button.field_146125_m = false;
                button.field_146124_l = false;
                this.field_146292_n.add(button);
                this.buttons.add(button);
                ++index;
            }
        }
        this.currentScroll = 0;
        this.topTextBox = new GuiTextBox(this.buttons.size(), resize ? this.field_146294_l / 2 - baseBoxSize / 2 : 20, this.field_146295_m - 175, baseBoxSize, 80);
        this.bottomTextBox = new GuiTextBox(this.buttons.size() + 1, resize ? this.field_146294_l / 2 - baseBoxSize / 2 : 20, this.field_146295_m - 85, baseBoxSize, 70);
        this.topTextBox.showBackdrop = true;
        this.topTextBox.bottomToTop = true;
        this.refreshButtonsWithScroll();
        this.maxScroll = Math.max(0, this.buttons.size() - 4);
        IDialogLine line = this.controller.getCurrentLine();
        if (this.controller.isNodeFinished() && this.controller.getCurrentNode().getButtons().size() > 0) {
            this.topTextBox.setText(line.getLocalizedBody());
        } else {
            this.bottomTextBox.setText(line.getLocalizedBody());
        }
        if (this.controller.getCurrentLine().getSpeaker().isPresent()) {
            Map<String, IDialogSlide> slides;
            ResourceLocation speakerPath = this.controller.getCurrentLine().getSpeaker().get();
            this.speaker = AetherAPI.content().dialog().getSpeaker(speakerPath).orElseThrow(() -> new IllegalArgumentException("Couldn't getByte speaker: " + speakerPath));
            if (speakerPath.func_110623_a().contains("#")) {
                String address = speakerPath.func_110623_a().substring(speakerPath.func_110623_a().indexOf("#") + 1);
                this.slide = AetherAPI.content().dialog().findSlide(address, this.speaker).orElseThrow(() -> new IllegalArgumentException("Couldn't find slide: " + address));
            } else if (this.speaker.getSlides().isPresent() && !(slides = this.speaker.getSlides().get()).isEmpty() && slides.containsKey("default")) {
                this.slide = slides.get("default");
            }
            if (this.slide != null && this.slide.getRenderer().isPresent()) {
                String renderType = this.slide.getRenderer().get();
                this.renderer = AetherAPI.content().dialog().findRenderer(renderType).orElseThrow(() -> new IllegalArgumentException("Couldn't find slide renderer: " + renderType));
                this.renderer.setup(this.slide);
            }
            this.field_146289_q = Minecraft.func_71410_x().field_71466_p;
            boolean topText = this.controller.isNodeFinished() && this.controller.getCurrentNode().getButtons().size() > 0;
            String name = I18n.func_135052_a((String)this.speaker.getUnlocalizedName(), (Object[])new Object[0]);
            this.namePlate = new GuiTextBox(this.buttons.size() + 2, resize ? this.field_146294_l / 2 - baseBoxSize / 2 : 20, this.field_146295_m - (topText ? 122 + this.topTextBox.getTextHeight(this.field_146289_q) : 107), this.field_146289_q.func_78256_a(name + 10), 20);
            TextComponentTranslation textComponent = new TextComponentTranslation(name, new Object[0]);
            textComponent.func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW).func_150217_b(Boolean.valueOf(true)));
            this.namePlate.setText((ITextComponent)textComponent);
            this.field_146292_n.add(this.namePlate);
        }
        this.field_146292_n.add(this.topTextBox);
        this.field_146292_n.add(this.bottomTextBox);
    }

    private void nextAction() {
        if (!this.canApplyNextAction) {
            this.canApplyNextAction = true;
            return;
        }
        this.controller.advance();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.nextAction();
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        this.nextAction();
        super.func_146286_b(mouseX, mouseY, state);
    }

    @Override
    public void onDialogChanged() {
        this.buildGui(this.controller.getCurrentNode());
    }

    @Override
    public void beforeSceneCloses() {
    }

    public void build(IGuiContext context) {
        this.getViewing().dim().mod().width((float)this.field_146294_l).height((float)this.field_146295_m).flush();
    }

    private void refreshButtonsWithScroll() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            GuiDialogButton button = this.buttons.get(i);
            if (i >= this.currentScroll && i <= this.currentScroll + 3) {
                button.field_146129_i = this.field_146295_m - 85 + (i - this.currentScroll) * 20;
                button.field_146124_l = true;
                button.field_146125_m = true;
                continue;
            }
            button.field_146124_l = false;
            button.field_146125_m = false;
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int scroll = MathHelper.func_76125_a((int)Mouse.getEventDWheel(), (int)-1, (int)1);
        if (scroll != 0) {
            this.currentScroll = MathHelper.func_76125_a((int)(this.currentScroll - scroll), (int)0, (int)this.maxScroll);
            this.refreshButtonsWithScroll();
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.controller.getCurrentScene() != null) {
            if (preventDialogControllerClose) {
                preventDialogControllerClose = false;
            } else {
                this.controller.closeScene(this.sceneInstance);
            }
        }
    }
}

