/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.gui.dialog;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.dialog.IDialogSlide;
import com.gildedgames.aether.api.dialog.IDialogSlideRenderer;
import com.gildedgames.aether.api.shop.ICurrencyListener;
import com.gildedgames.aether.api.shop.IGuiCurrencyValue;
import com.gildedgames.aether.api.shop.IShopBuy;
import com.gildedgames.aether.api.shop.IShopInstance;
import com.gildedgames.aether.api.shop.ShopUtil;
import com.gildedgames.aether.client.gui.container.IExtendedContainer;
import com.gildedgames.aether.client.gui.dialog.GuiShopBuy;
import com.gildedgames.aether.client.gui.dialog.GuiTextBox;
import com.gildedgames.aether.client.gui.util.GuiItemStack;
import com.gildedgames.aether.common.AetherCelebrations;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.PacketShopBack;
import com.gildedgames.aether.common.network.packets.PacketShopBuy;
import com.gildedgames.aether.common.network.packets.PacketShopSell;
import com.gildedgames.aether.common.util.helpers.ItemHelper;
import com.gildedgames.aether.common.util.helpers.MathUtil;
import com.gildedgames.orbis.lib.client.gui.data.Text;
import com.gildedgames.orbis.lib.client.gui.util.GuiAbstractButton;
import com.gildedgames.orbis.lib.client.gui.util.GuiTexture;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiViewer;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiContext;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiViewer;
import com.gildedgames.orbis.lib.client.gui.util.vanilla.GuiButtonVanilla;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.client.rect.RectHolder;
import com.gildedgames.orbis.lib.util.InputHelper;
import com.gildedgames.orbis.lib.util.mc.IText;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ContainerShop
extends GuiViewer
implements ICurrencyListener,
IExtendedContainer {
    private static final ResourceLocation INVENTORY = AetherCore.getResource("textures/gui/shop/inventory.png");
    private static final ResourceLocation STOCK = AetherCore.getResource("textures/gui/shop/stock.png");
    private static final ResourceLocation UP_ARROW = AetherCore.getResource("textures/gui/shop/up_button.png");
    private static final ResourceLocation DOWN_ARROW = AetherCore.getResource("textures/gui/shop/down_button.png");
    private static final ResourceLocation UP_ARROW_HOVER = AetherCore.getResource("textures/gui/shop/up_button_hover.png");
    private static final ResourceLocation DOWN_ARROW_HOVER = AetherCore.getResource("textures/gui/shop/down_button_hover.png");
    private static final ResourceLocation LOCK = AetherCore.getResource("textures/gui/shop/lock.png");
    private static final ResourceLocation UNLOCK = AetherCore.getResource("textures/gui/shop/unlock.png");
    private static final ResourceLocation GILT_BAG = AetherCore.getResource("textures/gui/shop/gilt_bag.png");
    private static final ResourceLocation HOLIDAY_NOTICE = AetherCore.getResource("textures/gui/shop/shop_notice.png");
    private static final ResourceLocation HOLIDAY_ICON = AetherCore.getResource("textures/gui/shop/holiday_icon.png");
    private static int buyCount = 1;
    private static int prevBuyCount = 1;
    private static boolean isCountLocked;
    private final IDialogSlide slide;
    private final IDialogSlideRenderer renderer;
    private final IShopInstance shopInstance;
    private final List<GuiShopBuy> buys = Lists.newArrayList();
    private final com.gildedgames.aether.common.containers.ContainerShop container;
    private final PlayerAether playerAether;
    private final int shopIndex;
    private int buyCountUnlocked = 1;
    private int prevBuyCountUnlocked = 1;
    private GuiButtonVanilla sell;
    private GuiButtonVanilla buy;
    private IGuiCurrencyValue playerCoins;
    private IGuiCurrencyValue sellCoins;
    private IGuiCurrencyValue buyCoins;
    private ItemStack lastSellStack;
    private int lastSellStackCount;
    private GuiItemStack stackGui;
    private com.gildedgames.orbis.lib.client.gui.util.GuiTextBox buyTitle;
    private GuiTextBox npcDialogue;
    private GuiTextBox npcGreeting;
    private int selectedBuy = -1;
    private int prevBuy = -1;
    private GuiButtonVanilla back;
    private GuiAbstractButton upArrow;
    private GuiAbstractButton downArrow;
    private GuiButtonVanilla lockButton;
    private GuiTexture lock;
    private GuiTexture unlock;
    private GuiTexture giltBag;
    private boolean upArrowHeld;
    private boolean downArrowHeld;
    private boolean pressLongEnough;
    private long lastBuyCountChangeTime;
    private List<String> hoverDescription;
    private ItemStack hoveredStack;
    private GuiTexture holidayNotice;
    private GuiTexture holidayIcon;
    private com.gildedgames.orbis.lib.client.gui.util.GuiTextBox holidayNoticeText;

    public ContainerShop(GuiViewer prevViewer, EntityPlayer player, IDialogSlide slide, IDialogSlideRenderer renderer, IShopInstance shopInstance, int shopIndex) {
        super((IGuiElement)new GuiElement(Dim2D.flush(), false), (IGuiViewer)prevViewer, (Container)new com.gildedgames.aether.common.containers.ContainerShop(player.field_71071_by, shopInstance));
        this.shopIndex = shopIndex;
        this.setDrawDefaultBackground(false);
        this.container = (com.gildedgames.aether.common.containers.ContainerShop)this.field_147002_h;
        this.slide = slide;
        this.renderer = renderer;
        this.shopInstance = shopInstance;
        this.playerAether = PlayerAether.getPlayer(player);
    }

    private IShopBuy getSelectedBuy() {
        return this.selectedBuy == -1 ? null : this.shopInstance.getStock().get(this.selectedBuy);
    }

    public void initContainerSize() {
        Pos2D center = InputHelper.getCenter().clone().addX(15.0f).flush();
        this.field_147003_i = (int)center.x() - 189 - 7;
        this.field_147009_r = this.field_146295_m - 198 - 14;
        this.field_146999_f = 385;
        this.field_147000_g = 180;
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.shopInstance.getCurrencyType().unlistenForCurrency(this.playerAether, this);
    }

    public void build(IGuiContext context) {
        this.getViewing().dim().mod().width(300.0f).height(300.0f).flush();
        Pos2D center = InputHelper.getCenter().clone().addX(17.0f).flush();
        this.holidayNotice = new GuiTexture(Dim2D.build().width(110.0f).height(50.0f).flush(), HOLIDAY_NOTICE);
        this.holidayIcon = new GuiTexture(Dim2D.build().width(14.0f).height(16.0f).x(8.0f).y(18.0f).flush(), HOLIDAY_ICON);
        this.holidayNoticeText = new com.gildedgames.orbis.lib.client.gui.util.GuiTextBox(Dim2D.build().width(80.0f).height(40.0f).x(27.0f).y(17.0f).flush(), false, new IText[]{new Text((ITextComponent)new TextComponentTranslation("edison.shop.holiday_notice", new Object[0]), 1.0f)});
        this.sellCoins = this.shopInstance.getCurrencyType().createSellItemCurrencyValueGui(Dim2D.build().center(true).pos(center).y((float)this.field_146295_m).addX(23.0f).addY(-197.0f).flush());
        this.sellCoins.state().setVisible(false);
        this.buyCoins = this.shopInstance.getCurrencyType().createBuyItemCurrencyValueGui(Dim2D.build().center(true).pos(center).y((float)this.field_146295_m).addX(-167.0f).addY(-157.0f).flush());
        this.buyCoins.state().setVisible(false);
        this.playerCoins = this.shopInstance.getCurrencyType().createCurrencyValueGui(Dim2D.build().centerY(true).pos(center).y((float)this.field_146295_m).addX(168.0f).addY(-113.0f).flush());
        this.playerCoins.state().setVisible(true);
        GuiTexture inventory = new GuiTexture(Dim2D.build().center(true).width(176.0f).height(120.0f).pos(center).y((float)this.field_146295_m).addX(75.0f).addY(-157.0f).flush(), INVENTORY);
        GuiTexture stock = new GuiTexture(Dim2D.build().center(true).width(176.0f).height(80.0f).pos(center).y((float)this.field_146295_m).addX(-115.0f).addY(-137.0f).flush(), STOCK);
        this.sell = new GuiButtonVanilla(Dim2D.build().width(72.0f).height(20.0f).pos(center).y((float)this.field_146295_m).addX(84.0f).addY(-207.0f).flush());
        this.sell.getInner().field_146126_j = I18n.func_135052_a((String)"aether.shop.sell", (Object[])new Object[0]);
        this.sell.getInner().field_146124_l = false;
        if (AetherCelebrations.isEdisonNewYearsSale(this.shopInstance)) {
            context.addChildren(new IGuiElement[]{this.holidayNotice, this.holidayNoticeText, this.holidayIcon});
        }
        context.addChildren(new IGuiElement[]{stock, inventory, this.sell});
        this.stackGui = new GuiItemStack(Dim2D.build().pos(center).y((float)this.field_146295_m).addX(-132.0f).addY(-166.0f).scale(1.0f).flush());
        this.buy = new GuiButtonVanilla(Dim2D.build().width(44.0f).height(20.0f).pos(center).y((float)this.field_146295_m).addX(-106.0f).addY(-167.0f).flush());
        this.buy.getInner().field_146126_j = I18n.func_135052_a((String)"aether.shop.buy", (Object[])new Object[]{isCountLocked ? buyCount : this.buyCountUnlocked});
        this.buy.state().setEnabled(false);
        this.back = new GuiButtonVanilla(Dim2D.build().width(20.0f).height(20.0f).pos(center).y((float)this.field_146295_m).addX(-236.0f).addY(-125.0f).flush());
        this.back.getInner().field_146126_j = "<";
        context.addChildren(new IGuiElement[]{this.stackGui, this.buy, this.back});
        int baseBoxSize = 350;
        boolean resize = this.field_146294_l - 40 > baseBoxSize;
        this.npcDialogue = new GuiTextBox(0, resize ? this.field_146294_l / 2 - baseBoxSize / 2 : 20, this.field_146295_m - 85, baseBoxSize, 70);
        int greetingBoxSize = 350;
        boolean greetingResize = this.field_146294_l - 40 > greetingBoxSize;
        this.npcGreeting = new GuiTextBox(1, greetingResize ? this.field_146294_l / 2 - greetingBoxSize / 2 : 20, this.field_146295_m - 85, greetingBoxSize, 70);
        String greeting = MathUtil.getRandomElement(this.shopInstance.getUnlocalizedGreetings(), new Random());
        this.npcGreeting.setText((ITextComponent)new TextComponentTranslation(greeting, new Object[0]));
        this.buyTitle = new com.gildedgames.orbis.lib.client.gui.util.GuiTextBox(Dim2D.build().centerX(true).pos(center).width(60.0f).height(50.0f).y((float)this.field_146295_m).addX(-178.0f).addY(-40.0f).flush(), true, new IText[0]);
        this.field_146292_n.add(this.npcDialogue);
        this.field_146292_n.add(this.npcGreeting);
        for (int i = 0; i < this.shopInstance.getStock().size(); ++i) {
            GuiShopBuy gui = new GuiShopBuy(Dim2D.build().width(18.0f).height(18.0f).pos(center).y((float)this.field_146295_m).addX((float)(-196 + i * 18 - i / 9 * 162)).addY(-140.0f + (float)(i / 9 * 18)).flush(), i, this.shopInstance);
            this.buys.add(gui);
            context.addChildren((IGuiElement)gui);
        }
        this.upArrow = new GuiAbstractButton(Dim2D.build().width(15.0f).height(10.0f).pos(center).y((float)this.field_146295_m).addX(-49.0f).addY(-167.0f).flush(), new GuiTexture(Dim2D.build().width(15.0f).height(10.0f).flush(), UP_ARROW), new GuiTexture(Dim2D.build().width(15.0f).height(10.0f).flush(), UP_ARROW_HOVER), new GuiTexture(Dim2D.build().width(15.0f).height(10.0f).flush(), UP_ARROW));
        this.downArrow = new GuiAbstractButton(Dim2D.build().width(15.0f).height(10.0f).pos(center).y((float)this.field_146295_m).addX(-49.0f).addY(-157.0f).flush(), new GuiTexture(Dim2D.build().width(15.0f).height(10.0f).flush(), DOWN_ARROW), new GuiTexture(Dim2D.build().width(15.0f).height(10.0f).flush(), DOWN_ARROW_HOVER), new GuiTexture(Dim2D.build().width(15.0f).height(10.0f).flush(), DOWN_ARROW));
        this.lockButton = new GuiButtonVanilla(Dim2D.build().width(14.0f).height(20.0f).pos(center).y((float)this.field_146295_m).addX(-63.0f).addY(-167.0f).flush());
        this.lock = new GuiTexture(Dim2D.build().center(true).height(16.0f).width(16.0f).pos(center).y((float)this.field_146295_m).addX(-56.0f).addY(-157.0f).flush(), LOCK);
        this.unlock = new GuiTexture(Dim2D.build().center(true).height(16.0f).width(16.0f).pos(center).y((float)this.field_146295_m).addX(-56.0f).addY(-157.0f).flush(), UNLOCK);
        context.addChildren((IGuiElement)this.playerCoins);
        this.giltBag = new GuiTexture(Dim2D.build().center(true).height(16.0f).width(16.0f).pos(center).y((float)this.field_146295_m).x(this.playerCoins.state().dim().x() + this.playerCoins.state().dim().width() / 2.0f - 1.0f).addY(-138.0f).scale(1.5f).flush(), GILT_BAG);
        this.playerCoins.setCurrencyValue(this.shopInstance.getCurrencyType().getValue(this.playerAether));
        context.addChildren(new IGuiElement[]{this.upArrow, this.downArrow, this.sellCoins, this.buyCoins, this.lockButton, this.lock, this.unlock, this.giltBag});
    }

    public void addBuyCount(int buyCount) {
        if (isCountLocked) {
            ContainerShop.buyCount = MathHelper.func_76125_a((int)(ContainerShop.buyCount + buyCount), (int)1, (int)64);
            if (this.getSelectedBuy() != null) {
                int count = (int)Math.min((long)this.getSelectedBuy().getStock(), Math.min((long)ContainerShop.buyCount, Math.min((long)this.getSelectedBuy().getItemStack().func_77976_d(), this.shopInstance.getCurrencyType().getValue(this.playerAether) / (long)ShopUtil.getFilteredPrice(this.shopInstance, this.getSelectedBuy()))));
                if (count <= 0) {
                    count = 1;
                }
                if (this.stackGui.getItemStack() != null) {
                    this.stackGui.getItemStack().func_190920_e(count);
                }
                int value = ShopUtil.getFilteredPrice(this.shopInstance, this.getSelectedBuy()) * count;
                this.buyCoins.setCurrencyValue(value);
                this.buyCoins.setNonFilteredCurrencyValue(this.getSelectedBuy().getPrice() * count);
                this.buyCoins.state().setVisible(true);
            }
        } else if (this.getSelectedBuy() != null) {
            int max = (int)Math.min((long)this.getSelectedBuy().getStock(), Math.min((long)this.getSelectedBuy().getItemStack().func_77976_d(), this.shopInstance.getCurrencyType().getValue(this.playerAether) / (long)ShopUtil.getFilteredPrice(this.shopInstance, this.getSelectedBuy())));
            if (max <= 0) {
                max = 1;
            }
            this.buyCountUnlocked = MathHelper.func_76125_a((int)(this.buyCountUnlocked + buyCount), (int)1, (int)max);
            if (this.stackGui.getItemStack() != null) {
                this.stackGui.getItemStack().func_190920_e(this.buyCountUnlocked);
            }
            int value = ShopUtil.getFilteredPrice(this.shopInstance, this.getSelectedBuy()) * this.buyCountUnlocked;
            this.buyCoins.setCurrencyValue(value);
            this.buyCoins.setNonFilteredCurrencyValue(this.getSelectedBuy().getPrice() * this.buyCountUnlocked);
            this.buyCoins.state().setVisible(true);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.shopInstance.getCurrencyType().listenForCurrency(this.playerAether, this);
        this.shopInstance.getCurrencyType().update(this.playerAether);
        if (InputHelper.isHovered((RectHolder)this.back)) {
            this.setHoveredDescription(null, Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"aether.shop.back", (Object[])new Object[0])}));
        }
        this.stackGui.setDrawCount(isCountLocked);
        this.lock.state().setVisible(isCountLocked);
        this.unlock.state().setVisible(!isCountLocked);
        if ((this.upArrowHeld || this.downArrowHeld) && !this.pressLongEnough && System.currentTimeMillis() - this.lastBuyCountChangeTime >= 300L) {
            this.lastBuyCountChangeTime = System.currentTimeMillis();
            this.pressLongEnough = true;
        }
        if (this.pressLongEnough && System.currentTimeMillis() - this.lastBuyCountChangeTime >= 50L) {
            this.lastBuyCountChangeTime = System.currentTimeMillis();
            if (this.upArrowHeld) {
                this.addBuyCount(1);
            } else if (this.downArrowHeld) {
                this.addBuyCount(-1);
            }
        }
        this.func_146270_b(0);
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((GuiScreen)this));
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.slide != null && this.renderer != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-100.0f, (float)0.0f, (float)0.0f);
            this.renderer.draw(this.slide, this.field_146294_l, this.field_146295_m, mouseX, mouseY, partialTicks);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
        Gui.func_73734_a((int)0, (int)(this.field_146295_m - 90), (int)this.field_146294_l, (int)this.field_146295_m, (int)Integer.MIN_VALUE);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        if (this.hoverDescription != null && this.hoverDescription.size() > 0) {
            if (this.hoveredStack != null) {
                GuiUtils.preItemToolTip((ItemStack)this.hoveredStack);
                GuiUtils.drawHoveringText(this.hoverDescription, (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
                GuiUtils.postItemToolTip();
            } else {
                GuiUtils.drawHoveringText(this.hoverDescription, (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
            }
        }
        if (InputHelper.isHovered((RectHolder)this.lockButton)) {
            GuiUtils.drawHoveringText((List)Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"aether.shop.lockTooltip", (Object[])new Object[0])}), (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)120, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }
        this.hoverDescription = null;
        this.func_191948_b(mouseX, mouseY);
        ItemStack stack = this.container.func_75139_a(0).func_75211_c();
        if (stack != this.lastSellStack || stack.func_190916_E() != this.lastSellStackCount) {
            double value;
            int hash = ItemHelper.getKeyForItemStack(stack);
            IShopBuy shopBuy = null;
            for (IShopBuy buy : this.shopInstance.getStock()) {
                int buyHash = ItemHelper.getKeyForItemStack(buy.getItemStack());
                if (buyHash != hash) continue;
                shopBuy = buy;
                break;
            }
            if (shopBuy != null) {
                value = ShopUtil.getFilteredPrice(this.shopInstance, stack, shopBuy.getSellingPrice()) * (double)stack.func_190916_E();
                this.sellCoins.setNonFilteredCurrencyValue(shopBuy.getSellingPrice() * (double)stack.func_190916_E());
            } else {
                double originalValue = AetherAPI.content().currency().getValue(stack, this.shopInstance.getCurrencyType().getClass());
                value = ShopUtil.getFilteredPrice(this.shopInstance, stack, originalValue);
                this.sellCoins.setNonFilteredCurrencyValue(originalValue);
            }
            this.sellCoins.setCurrencyValue(value);
            this.lastSellStack = stack;
            this.lastSellStackCount = stack.func_190916_E();
            this.sell.state().setEnabled(value >= 1.0);
            this.sellCoins.state().setVisible(true);
        }
        if (this.getSelectedBuy() != null) {
            this.npcGreeting.field_146125_m = false;
            int maxAllowedWithHeldStack = this.getSelectedBuy().getItemStack().func_77976_d() - this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190916_E();
            int amount = Math.min(maxAllowedWithHeldStack, Math.min(buyCount, this.getSelectedBuy().getStock()));
            boolean canAfford = this.shopInstance.getCurrencyType().getValue(this.playerAether) >= (long)ShopUtil.getFilteredPrice(this.shopInstance, this.getSelectedBuy());
            boolean isHandFree = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b();
            boolean isBuyItem = ItemHelper.getKeyForItemStack(this.field_146297_k.field_71439_g.field_71071_by.func_70445_o()) == ItemHelper.getKeyForItemStack(this.getSelectedBuy().getItemStack());
            boolean canStack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_77985_e();
            boolean isAtStackLimit = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190916_E() >= this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_77976_d();
            boolean hasStock = this.getSelectedBuy().getStock() > 0 && amount > 0;
            this.buy.state().setEnabled(hasStock && !isAtStackLimit && canStack && canAfford && (isHandFree || isBuyItem) && this.getSelectedBuy().getStock() > 0);
        } else {
            this.npcGreeting.field_146125_m = true;
        }
        if (this.getSelectedBuy() != null && this.prevBuy != this.selectedBuy) {
            this.stackGui.setItemStack(this.getSelectedBuy().getItemStack());
            String chosenDesc = MathUtil.getRandomElement(this.getSelectedBuy().getUnlocalizedDescriptions(), new Random());
            this.npcDialogue.setText((ITextComponent)new TextComponentTranslation(chosenDesc, new Object[0]));
            this.prevBuy = this.selectedBuy;
            int count = (int)Math.min(isCountLocked ? (long)buyCount : (long)this.buyCountUnlocked, Math.min((long)this.getSelectedBuy().getItemStack().func_77976_d(), this.shopInstance.getCurrencyType().getValue(this.playerAether) / (long)ShopUtil.getFilteredPrice(this.shopInstance, this.getSelectedBuy())));
            if (count <= 0) {
                count = 1;
            }
            int value = ShopUtil.getFilteredPrice(this.shopInstance, this.getSelectedBuy()) * count;
            this.buyCoins.setCurrencyValue(value);
            this.buyCoins.setNonFilteredCurrencyValue(this.getSelectedBuy().getPrice() * count);
            this.buyCoins.state().setVisible(true);
        }
        if (buyCount != prevBuyCount && isCountLocked) {
            prevBuyCount = buyCount;
            this.buy.getInner().field_146126_j = I18n.func_135052_a((String)"aether.shop.buy", (Object[])new Object[]{buyCount});
        }
        if (this.buyCountUnlocked != this.prevBuyCountUnlocked && !isCountLocked) {
            this.prevBuyCountUnlocked = this.buyCountUnlocked;
            this.buy.getInner().field_146126_j = I18n.func_135052_a((String)"aether.shop.buy", (Object[])new Object[]{this.buyCountUnlocked});
        }
    }

    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    }

    public void func_146276_q_() {
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.upArrowHeld = false;
        this.downArrowHeld = false;
        this.lastBuyCountChangeTime = 0L;
        this.pressLongEnough = false;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (InputHelper.isHovered((RectHolder)this.lockButton)) {
            boolean bl = isCountLocked = !isCountLocked;
            if (isCountLocked) {
                this.buy.getInner().field_146126_j = I18n.func_135052_a((String)"aether.shop.buy", (Object[])new Object[]{buyCount});
                if (this.getSelectedBuy() != null) {
                    int count = (int)Math.min((long)this.getSelectedBuy().getStock(), Math.min((long)buyCount, Math.min((long)this.getSelectedBuy().getItemStack().func_77976_d(), this.shopInstance.getCurrencyType().getValue(this.playerAether) / (long)ShopUtil.getFilteredPrice(this.shopInstance, this.getSelectedBuy()))));
                    if (this.stackGui.getItemStack() != null) {
                        this.stackGui.getItemStack().func_190920_e(count);
                    }
                    int value = ShopUtil.getFilteredPrice(this.shopInstance, this.getSelectedBuy()) * count;
                    this.buyCoins.setCurrencyValue(value);
                    this.buyCoins.setNonFilteredCurrencyValue(this.getSelectedBuy().getPrice() * count);
                    this.buyCoins.state().setVisible(true);
                }
                this.addBuyCount(0);
            } else {
                this.buy.getInner().field_146126_j = I18n.func_135052_a((String)"aether.shop.buy", (Object[])new Object[]{this.buyCountUnlocked});
                if (this.stackGui.getItemStack() != null) {
                    this.stackGui.getItemStack().func_190920_e(this.buyCountUnlocked);
                }
                if (this.getSelectedBuy() != null) {
                    int value = ShopUtil.getFilteredPrice(this.shopInstance, this.getSelectedBuy()) * this.buyCountUnlocked;
                    this.buyCoins.setCurrencyValue(value);
                    this.buyCoins.setNonFilteredCurrencyValue(this.getSelectedBuy().getPrice() * this.buyCountUnlocked);
                    this.buyCoins.state().setVisible(true);
                }
            }
        }
        if (InputHelper.isHovered((RectHolder)this.upArrow)) {
            this.upArrowHeld = true;
            this.addBuyCount(1);
            this.lastBuyCountChangeTime = System.currentTimeMillis();
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                this.addBuyCount(64);
            }
        }
        if (InputHelper.isHovered((RectHolder)this.downArrow)) {
            this.downArrowHeld = true;
            this.addBuyCount(-1);
            this.lastBuyCountChangeTime = System.currentTimeMillis();
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                this.addBuyCount(-64);
            }
        }
        if (InputHelper.isHovered((RectHolder)this.back)) {
            NetworkingAether.sendPacketToServer(new PacketShopBack());
        }
        if (InputHelper.isHovered((RectHolder)this.buy) && this.buy.state().isEnabled()) {
            boolean isBuyItem;
            int index = 0;
            for (int i = 0; i < this.shopInstance.getStock().size(); ++i) {
                IShopBuy shopBuy = this.shopInstance.getStock().get(i);
                if (shopBuy != this.getSelectedBuy()) continue;
                index = i;
                break;
            }
            NetworkingAether.sendPacketToServer(new PacketShopBuy(index, isCountLocked ? buyCount : this.buyCountUnlocked, this.shopIndex));
            int maxAllowedWithHeldStack = this.getSelectedBuy().getItemStack().func_77976_d() - this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190916_E();
            int amount = Math.min(maxAllowedWithHeldStack, Math.min(isCountLocked ? buyCount : this.buyCountUnlocked, this.getSelectedBuy().getStock()));
            boolean isHandFree = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b();
            boolean bl = isBuyItem = ItemHelper.getKeyForItemStack(this.field_146297_k.field_71439_g.field_71071_by.func_70445_o()) == ItemHelper.getKeyForItemStack(this.getSelectedBuy().getItemStack());
            if (isHandFree) {
                this.getSelectedBuy().addStock(-amount);
                ItemStack stack = this.getSelectedBuy().getItemStack().func_77946_l();
                stack.func_190920_e(amount);
                this.field_146297_k.field_71439_g.field_71071_by.func_70437_b(stack);
            } else if (isBuyItem) {
                this.getSelectedBuy().addStock(-amount);
                this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190920_e(this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190916_E() + amount);
            }
            this.addBuyCount(0);
        }
        if (InputHelper.isHovered((RectHolder)this.sell) && this.sell.state().isEnabled()) {
            ItemStack stack = this.container.func_75139_a(0).func_75211_c();
            double singleValue = ShopUtil.getFilteredPrice(this.shopInstance, stack, AetherAPI.content().currency().getSingleValue(stack, this.shopInstance.getCurrencyType().getClass()));
            if (singleValue < 1.0) {
                double wholeValue = ShopUtil.getFilteredPrice(this.shopInstance, stack, AetherAPI.content().currency().getValue(stack, this.shopInstance.getCurrencyType().getClass()));
                double decimals = wholeValue - (double)MathHelper.func_76128_c((double)wholeValue);
                double howManyTimesDivInto = decimals / singleValue;
                int leftover = MathHelper.func_76128_c((double)howManyTimesDivInto);
                this.container.func_75139_a(0).func_75211_c().func_190920_e(leftover);
            } else {
                this.container.func_75139_a(0).func_75215_d(ItemStack.field_190927_a);
            }
            NetworkingAether.sendPacketToServer(new PacketShopSell(this.shopIndex));
        }
        for (GuiShopBuy b : this.buys) {
            if (!InputHelper.isHovered((RectHolder)b)) continue;
            this.buyCountUnlocked = 1;
            this.selectedBuy = b.getBuyIndex();
            break;
        }
    }

    @Override
    public void onCurrencyChange(long prevCurrency, long newCurrency) {
        this.playerCoins.setCurrencyValue(newCurrency);
        this.giltBag.dim().mod().x(this.playerCoins.dim().x() + this.playerCoins.dim().width() / 2.0f - 1.0f).flush();
        this.addBuyCount(0);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int scroll = MathHelper.func_76125_a((int)Mouse.getEventDWheel(), (int)-1, (int)1);
        if (scroll != 0 && (InputHelper.isHovered((RectHolder)this.buy) || InputHelper.isHovered((RectHolder)this.upArrow) || InputHelper.isHovered((RectHolder)this.downArrow) || InputHelper.isHovered((RectHolder)this.lockButton))) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                this.addBuyCount(scroll * 64);
            } else {
                this.addBuyCount(scroll);
            }
        }
    }

    @Override
    public void setHoveredDescription(ItemStack stack, List<String> desc) {
        this.hoveredStack = stack;
        this.hoverDescription = desc;
    }
}

