/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.gui.container.masonry_bench;

import com.gildedgames.aether.client.gui.container.IExtendedContainer;
import com.gildedgames.aether.client.gui.container.masonry_bench.GuiMasonryCraftingOption;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.containers.tiles.ContainerMasonryBench;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.PacketMasonryProcessOutput;
import com.gildedgames.aether.common.network.packets.PacketMasonryProcessOutputShift;
import com.gildedgames.aether.common.recipes.MasonryRecipes;
import com.gildedgames.aether.common.util.helpers.ItemHelper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiMasonryBench
extends GuiContainer
implements IExtendedContainer {
    private static final ResourceLocation MASONRY_BENCH = AetherCore.getResource("textures/gui/inventory/masonry_bench.png");
    private static final ResourceLocation SCROLL_BAR = AetherCore.getResource("textures/gui/inventory/scroll_bar.png");
    private final int ySize = 206;
    private final List<GuiMasonryCraftingOption> options = new ArrayList<GuiMasonryCraftingOption>(20);
    public final List<ItemStack> recipes = Lists.newArrayList();
    private final InventoryPlayer playerInventory;
    private final IInventory tileMasonry;
    private ContainerMasonryBench container;
    public List<String> hoverDescription;
    private ItemStack hoveredStack;
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;

    public GuiMasonryBench(EntityPlayer player, InventoryPlayer playerInv, IInventory masonryInv) {
        super((Container)new ContainerMasonryBench(player, playerInv, masonryInv));
        this.playerInventory = playerInv;
        this.tileMasonry = masonryInv;
        this.container = new ContainerMasonryBench(player, playerInv, masonryInv);
        this.field_146291_p = true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiLeft = 134 + (this.field_146294_l - this.field_146999_f) / 2;
        int guiTop = (this.field_146295_m - this.ySize) / 2 - 3;
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 4; ++j) {
                GuiMasonryCraftingOption option = new GuiMasonryCraftingOption(j + i * 4, guiLeft - 126 + j * 18, guiTop + (21 + i * 18), ItemStack.field_190927_a);
                this.field_146292_n.add(option);
                this.options.add(j + i * 4, option);
            }
        }
        this.updateCraftingOptions();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        boolean flag = Mouse.isButtonDown((int)0);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        int k = i - 48;
        int l = j + 22;
        int i1 = k + 14;
        int j1 = l + 108;
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.scrollTo(this.currentScroll);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.hoverDescription != null && this.hoverDescription.size() > 0) {
            if (this.hoveredStack != null) {
                GuiUtils.preItemToolTip((ItemStack)this.hoveredStack);
                GuiUtils.drawHoveringText(this.hoverDescription, (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
                GuiUtils.postItemToolTip();
            } else {
                GuiUtils.drawHoveringText(this.hoverDescription, (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
            }
        }
        this.hoverDescription = null;
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!((Slot)this.container.field_75151_b.get(0)).func_75216_d()) {
            this.container.setOutput(ItemStack.field_190927_a);
            this.updateCraftingOptions();
        }
        if (((Slot)this.container.field_75151_b.get(0)).func_75216_d()) {
            this.updateCraftingOptions();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.tileMasonry.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, -14, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.ySize - 116 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(MASONRY_BENCH);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.ySize);
        int i = 88 + this.field_147003_i;
        int j = this.field_147009_r - 2;
        int k = j + 108;
        this.field_146297_k.func_110434_K().func_110577_a(SCROLL_BAR);
        this.func_73729_b(i, j + (int)((float)(k - j - 17) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.getSlotUnderMouse() != null && this.getSlotUnderMouse().field_75222_d == 0) {
            this.updateCraftingOptions();
        }
        if (this.getSlotUnderMouse() != null && this.getSlotUnderMouse().field_75222_d == 1 && ((Slot)this.container.field_75151_b.get(1)).func_75216_d()) {
            if (!Keyboard.isKeyDown((int)42)) {
                NetworkingAether.sendPacketToServer(new PacketMasonryProcessOutput());
                ItemStack outputStack = ((Slot)this.container.field_75151_b.get(1)).func_75211_c();
                if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                    this.field_146297_k.field_71439_g.field_71071_by.func_70437_b(outputStack.func_77946_l());
                } else if (ItemHelper.getKeyForItemStack(this.field_146297_k.field_71439_g.field_71071_by.func_70445_o()) == ItemHelper.getKeyForItemStack(((Slot)this.container.field_75151_b.get(1)).func_75211_c())) {
                    this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190920_e(this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190916_E() + 1);
                }
                ((Slot)this.container.field_75151_b.get(0)).func_75209_a(1);
            } else {
                NetworkingAether.sendPacketToServer(new PacketMasonryProcessOutputShift());
                ItemStack newOutputStack = ((Slot)this.container.field_75151_b.get(1)).func_75211_c().func_77946_l();
                newOutputStack.func_190920_e(((Slot)this.container.field_75151_b.get(0)).func_75211_c().func_190916_E());
                this.field_146297_k.field_71439_g.field_71071_by.func_70441_a(newOutputStack);
                ((Slot)this.container.field_75151_b.get(0)).func_75209_a(((Slot)this.container.field_75151_b.get(0)).func_75211_c().func_190916_E());
            }
        }
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        super.func_184098_a(slotIn, slotId, mouseButton, type);
        if (slotIn != null && slotIn.field_75222_d == 1) {
            this.updateCraftingOptions();
        }
    }

    protected void func_146284_a(GuiButton button) {
        GuiMasonryCraftingOption option;
        if (button instanceof GuiMasonryCraftingOption && (option = (GuiMasonryCraftingOption)button).getOutputItemStack() != null && option.getOutputItemStack() != ((Slot)this.container.field_75151_b.get(1)).func_75211_c()) {
            this.container.setOutput(option.getOutputItemStack().func_77946_l());
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = (this.recipes.size() + 4 - 1) / 4 - 6;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.scrollTo(this.currentScroll);
        }
    }

    private void scrollTo(float scroll) {
        int i = (this.recipes.size() + 4 - 1) / 4 - 6;
        int j = (int)((double)(scroll * (float)i) + 0.5);
        if (j < 0) {
            j = 0;
        }
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 4; ++l) {
                int i1 = l + (k + j) * 4;
                if (i1 >= 0 && i1 < this.recipes.size()) {
                    this.options.get(l + k * 4).setOutputItemStack(this.recipes.get(i1));
                    continue;
                }
                this.options.get(l + k * 4).setOutputItemStack(ItemStack.field_190927_a);
            }
        }
    }

    private boolean canScroll() {
        return this.recipes.size() > this.options.size();
    }

    private boolean needsScrollBars() {
        return this.canScroll();
    }

    private void updateCraftingOptions() {
        ItemStack[] outputStack;
        this.recipes.clear();
        if (!this.tileMasonry.func_70301_a(0).func_190926_b() && (outputStack = MasonryRecipes.instance().getOutput(this.tileMasonry.func_70301_a(0))) != null) {
            this.recipes.addAll(Arrays.asList(outputStack));
        }
        this.currentScroll = 0.0f;
        this.scrollTo(0.0f);
    }

    @Override
    public void setHoveredDescription(ItemStack stack, List<String> desc) {
        this.hoveredStack = stack;
        this.hoverDescription = desc;
    }
}

