/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.gui.container.guidebook.discovery;

import com.gildedgames.aether.api.cache.IEntityStats;
import com.gildedgames.aether.api.travellers_guidebook.ITGManager;
import com.gildedgames.aether.client.gui.container.guidebook.discovery.BestiarySlot;
import com.gildedgames.aether.client.gui.container.guidebook.discovery.GuiGuidebookDiscovery;
import com.gildedgames.aether.client.gui.container.guidebook.discovery.stats.GuiStat;
import com.gildedgames.aether.client.gui.misc.GuiScrollableGuidebook;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.travellers_guidebook.entries.TGEntryBestiaryPage;
import com.gildedgames.orbis.lib.client.gui.data.Text;
import com.gildedgames.orbis.lib.client.gui.util.GuiText;
import com.gildedgames.orbis.lib.client.gui.util.GuiTextBox;
import com.gildedgames.orbis.lib.client.gui.util.GuiTexture;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.GuiLibHelper;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiContext;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiViewer;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.client.rect.Rect;
import com.gildedgames.orbis.lib.client.rect.RectBuilder;
import com.gildedgames.orbis.lib.client.rect.RectHolder;
import com.gildedgames.orbis.lib.util.InputHelper;
import com.gildedgames.orbis.lib.util.mc.IText;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiGuidebookDiscoveryBestiary
extends GuiGuidebookDiscovery {
    private static final ResourceLocation RIGHT_PAGE_MOB = AetherCore.getResource("textures/gui/guidebook/discovery/guidebook_discovery_right_mob.png");
    private static final ResourceLocation HEALTH_ICON = AetherCore.getResource("textures/gui/guidebook/icons/heart.png");
    private static final ResourceLocation SLASH_DEFENSE_ICON = AetherCore.getResource("textures/gui/overlay/slash_damage.png");
    private static final ResourceLocation PIERCE_DEFENSE_ICON = AetherCore.getResource("textures/gui/overlay/pierce_damage.png");
    private static final ResourceLocation IMPACT_DEFENSE_ICON = AetherCore.getResource("textures/gui/overlay/impact_damage.png");
    private List<TGEntryBestiaryPage> bestiaryEntries;
    private List<BestiarySlot> slots;
    private GuiTexture beastFrame;
    private GuiText beastTitle;
    private GuiTextBox beastDescription;
    private GuiScrollableGuidebook statsArea;

    public GuiGuidebookDiscoveryBestiary(IGuiViewer prevViewer, PlayerAether aePlayer) {
        super(prevViewer, aePlayer);
    }

    @Override
    public void build(IGuiContext context) {
        super.build(context);
    }

    private IGuiElement buildStats(TGEntryBestiaryPage page) {
        IEntityStats stats = page.getEntityStats();
        GuiElement statsElement = new GuiElement(Dim2D.build().width(52.0f).flush(), false);
        GuiStat healthStat = new GuiStat(new GuiTexture(Dim2D.build().width(14.0f).height(14.0f).flush(), HEALTH_ICON), new Text((ITextComponent)new TextComponentString(String.valueOf(MathHelper.func_76141_d((float)stats.getMaxHealth()))), 1.0f));
        GuiStat slashStat = new GuiStat(new GuiTexture(Dim2D.build().width(14.0f).height(14.0f).flush(), SLASH_DEFENSE_ICON), new Text((ITextComponent)new TextComponentString(String.valueOf(MathHelper.func_76128_c((double)stats.getSlashDefenseLevel()))), 1.0f));
        GuiStat pierceStat = new GuiStat(new GuiTexture(Dim2D.build().width(14.0f).height(14.0f).flush(), PIERCE_DEFENSE_ICON), new Text((ITextComponent)new TextComponentString(String.valueOf(MathHelper.func_76128_c((double)stats.getPierceDefenseLevel()))), 1.0f));
        GuiStat impactStat = new GuiStat(new GuiTexture(Dim2D.build().width(14.0f).height(14.0f).flush(), IMPACT_DEFENSE_ICON), new Text((ITextComponent)new TextComponentString(String.valueOf(MathHelper.func_76128_c((double)stats.getImpactDefenseLevel()))), 1.0f));
        statsElement.build((IGuiViewer)this);
        GuiLibHelper.alignVertically((IGuiViewer)this, (Pos2D)Pos2D.flush((float)5.0f, (float)5.0f), (float)5.0f, (GuiElement[])new GuiElement[]{healthStat, slashStat, pierceStat, impactStat});
        statsElement.context().addChildren(new IGuiElement[]{healthStat, slashStat, pierceStat, impactStat});
        GuiLibHelper.assembleMinMaxArea((IGuiElement)statsElement);
        return statsElement;
    }

    private IGuiElement resetStats(TGEntryBestiaryPage page) {
        GuiElement statsElement = new GuiElement(Dim2D.build().width(52.0f).flush(), false);
        statsElement.build((IGuiViewer)this);
        return statsElement;
    }

    @Override
    protected List<IGuiElement> createLeftPage(int screenX, int screenY, float u, float v) {
        List<IGuiElement> elements = super.createLeftPage(screenX, screenY, u, v);
        ITGManager tgManager = AetherCore.PROXY.content().tgManager();
        this.bestiaryEntries = tgManager.getEntriesWithTagAndClass("bestiary", TGEntryBestiaryPage.class);
        this.slots = Lists.newArrayList();
        for (int i = 0; i < this.bestiaryEntries.size(); ++i) {
            TGEntryBestiaryPage page = this.bestiaryEntries.get(i);
            int x = screenX + 29 + i % 6 * 18;
            int y = screenY + 58 + i / 6 * 18;
            BestiarySlot slot = new BestiarySlot(this.aePlayer, Pos2D.flush((float)x, (float)y), page);
            slot.addClickEvent(() -> {
                boolean isUnderstood = page.isUnderstood(this.aePlayer);
                boolean completeOverview = page.hasUnlockedCompleteOverview(this.aePlayer);
                this.beastFrame.setResourceLocation(page.isUnlocked(this.aePlayer) ? page.getDiscoveredTexture() : page.getSilhouetteTexture());
                this.beastFrame.state().setVisible(true);
                this.beastTitle.setText((IText)new Text((ITextComponent)new TextComponentTranslation(page.getEntityName(), new Object[0]), 1.0f));
                if (!isUnderstood) {
                    this.beastTitle.setTextMutator(text -> text.replaceAll("[^\\s]", "?"));
                }
                this.beastDescription.setText(new IText[]{new Text((ITextComponent)new TextComponentTranslation(completeOverview ? page.getUnlocalizedDescription() : "?", new Object[0]), 0.65f)});
                this.beastDescription.tryRebuild();
                if (isUnderstood) {
                    IGuiElement statsContent = this.buildStats(page);
                    statsContent.dim().mod().pos(this.statsArea.dim().min()).flush();
                    this.statsArea.setDecorated(statsContent);
                } else {
                    IGuiElement statsContent = this.resetStats(page);
                    statsContent.dim().mod().pos(this.statsArea.dim().min()).flush();
                    this.statsArea.setDecorated(statsContent);
                }
            });
            this.slots.add(slot);
            elements.add((IGuiElement)slot);
        }
        return elements;
    }

    @Override
    protected List<IGuiElement> createRightPage(int screenX, int screenY, float u, float v) {
        this.beastFrame = new GuiTexture(Dim2D.build().x((float)(screenX + 25)).y((float)(screenY + 25)).width(58.0f).height(71.0f).flush(), null);
        this.beastFrame.state().setVisible(false);
        this.beastTitle = new GuiText(Dim2D.build().x((float)(screenX + 88)).y((float)(screenY + 10)).flush(), (IText)new Text((ITextComponent)new TextComponentString(""), 1.0f));
        this.beastTitle.dim().mod().centerX(true).flush();
        this.beastDescription = new GuiTextBox(Dim2D.build().x((float)(screenX + 92)).y((float)(screenY + 24)).width(52.0f).flush(), false, new IText[]{new Text((ITextComponent)new TextComponentString(""), 0.65f)});
        this.statsArea = new GuiScrollableGuidebook((IGuiElement)new GuiElement(Dim2D.build().x((float)(screenX + 25)).y((float)(screenY + 114)).flush(), false), Dim2D.build().width(60.0f).height(56.0f).flush(), true);
        Rect beastDescriptionScrollArea = Dim2D.build().width(61.0f).height(73.0f).flush();
        RectBuilder rectBuilder = Dim2D.build();
        ((Object)((Object)this)).getClass();
        RectBuilder rectBuilder2 = rectBuilder.width(176.0f);
        ((Object)((Object)this)).getClass();
        GuiTexture rightPage = new GuiTexture(rectBuilder2.height(185.0f).x((float)screenX).y((float)screenY).flush(), RIGHT_PAGE_MOB);
        GuiText stats = new GuiText(Dim2D.build().x((float)(screenX + 40)).y((float)(screenY + 102)).flush(), (IText)new Text((ITextComponent)new TextComponentTranslation("gui.guidebook.discovery.stats", new Object[0]), 1.0f));
        GuiText moves = new GuiText(Dim2D.build().x((float)(screenX + 105)).y((float)(screenY + 102)).flush(), (IText)new Text((ITextComponent)new TextComponentTranslation("gui.guidebook.discovery.moves", new Object[0]), 1.0f));
        return Lists.newArrayList((Object[])new IGuiElement[]{rightPage, this.beastFrame, this.beastTitle, new GuiScrollableGuidebook((IGuiElement)this.beastDescription, beastDescriptionScrollArea, true), stats, moves, this.statsArea});
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        for (BestiarySlot slot : this.slots) {
            String beastName = slot.getPage().getEntityName();
            if (!slot.getPage().isUnderstood(this.aePlayer)) {
                beastName = beastName.replaceAll("[^\\s]", "?");
            }
            if (!InputHelper.isHovered((RectHolder)slot)) continue;
            this.drawHoveringText(beastName, Mouse.getX() * scaledresolution.func_78326_a() / mc.field_71443_c, scaledresolution.func_78328_b() - (Mouse.getY() - 42) * scaledresolution.func_78328_b() / mc.field_71440_d - 1, mc.field_71466_p);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawHoveringText(String text, int x, int y, FontRenderer font) {
        GL11.glDisable((int)2929);
        int k = font.func_78256_a(text);
        int x1 = x + 12;
        int y1 = y - 12;
        int z1 = 8;
        this.field_73735_i = 300.0f;
        int color1 = -267386864;
        this.func_73733_a(x1 - 3, y1 - 4, x1 + k + 3, y1 - 3, color1, color1);
        this.func_73733_a(x1 - 3, y1 + z1 + 3, x1 + k + 3, y1 + z1 + 4, color1, color1);
        this.func_73733_a(x1 - 3, y1 - 3, x1 + k + 3, y1 + z1 + 3, color1, color1);
        this.func_73733_a(x1 - 4, y1 - 3, x1 - 3, y1 + z1 + 3, color1, color1);
        this.func_73733_a(x1 + k + 3, y1 - 3, x1 + k + 4, y1 + z1 + 3, color1, color1);
        int color2 = 0x505000FF;
        int color2BG = (color2 & 0xFEFEFE) >> 1 | color2 & 0xFF000000;
        this.func_73733_a(x1 - 3, y1 - 3 + 1, x1 - 3 + 1, y1 + z1 + 3 - 1, color2, color2BG);
        this.func_73733_a(x1 + k + 2, y1 - 3 + 1, x1 + k + 3, y1 + z1 + 3 - 1, color2, color2BG);
        this.func_73733_a(x1 - 3, y1 - 3, x1 + k + 3, y1 - 3 + 1, color2, color2);
        this.func_73733_a(x1 - 3, y1 + z1 + 2, x1 + k + 3, y1 + z1 + 3, color2BG, color2BG);
        font.func_78276_b(text, x1, y1, -1);
        this.field_73735_i = 0.0f;
        GL11.glEnable((int)2929);
    }
}

