/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.gui.container.guidebook.discovery;

import com.gildedgames.aether.client.gui.container.guidebook.AbstractGuidebookPage;
import com.gildedgames.aether.client.gui.container.guidebook.discovery.DiscoveryTab;
import com.gildedgames.aether.client.gui.container.guidebook.discovery.GuiGuidebookDiscoveryBestiary;
import com.gildedgames.aether.client.gui.container.guidebook.discovery.GuiGuidebookDiscoveryCharacters;
import com.gildedgames.aether.client.gui.container.guidebook.discovery.GuiGuidebookDiscoveryEffects;
import com.gildedgames.aether.client.gui.container.guidebook.discovery.GuiGuidebookDiscoveryLandmarks;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.capabilities.entity.player.PlayerAether;
import com.gildedgames.aether.common.capabilities.entity.player.modules.PlayerProgressModule;
import com.gildedgames.aether.common.containers.guidebook.EmptyContainer;
import com.gildedgames.orbis.lib.client.gui.data.Text;
import com.gildedgames.orbis.lib.client.gui.util.GuiText;
import com.gildedgames.orbis.lib.client.gui.util.GuiTexture;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiContext;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiElement;
import com.gildedgames.orbis.lib.client.gui.util.gui_library.IGuiViewer;
import com.gildedgames.orbis.lib.client.rect.Dim2D;
import com.gildedgames.orbis.lib.client.rect.Pos2D;
import com.gildedgames.orbis.lib.client.rect.RectBuilder;
import com.gildedgames.orbis.lib.util.mc.IText;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class GuiGuidebookDiscovery
extends AbstractGuidebookPage {
    private static final ResourceLocation LEFT_PAGE = AetherCore.getResource("textures/gui/guidebook/discovery/guidebook_discovery_left.png");
    private static final ResourceLocation RIGHT_PAGE_GENERAL = AetherCore.getResource("textures/gui/guidebook/discovery/guidebook_discovery_right_general.png");
    private static final ResourceLocation BESTIARY_ICON = AetherCore.getResource("textures/gui/guidebook/discovery/icon_bestiary.png");
    private static final ResourceLocation EFFECTS_ICON = AetherCore.getResource("textures/gui/guidebook/discovery/icon_effects.png");
    private static final ResourceLocation LANDMARK_ICON = AetherCore.getResource("textures/gui/guidebook/discovery/icon_landmark.png");
    private static final ResourceLocation CHARACTER_ICON = AetherCore.getResource("textures/gui/guidebook/discovery/icon_character.png");
    private DiscoveryTab bestiaryTab;
    private DiscoveryTab effectTab;
    private DiscoveryTab landmarkTab;
    private DiscoveryTab characterTab;

    public GuiGuidebookDiscovery(IGuiViewer prevViewer, PlayerAether aePlayer) {
        super(prevViewer, aePlayer, new EmptyContainer());
    }

    @Override
    public void build(IGuiContext context) {
        super.build(context);
    }

    private void onClickTab(DiscoveryTab tab) {
        this.bestiaryTab.setSelected(false);
        this.effectTab.setSelected(false);
        this.landmarkTab.setSelected(false);
        this.characterTab.setSelected(false);
        this.aePlayer.getModule(PlayerProgressModule.class).setOpenedDiscoveryTabType(tab.getType());
        tab.setSelected(true);
        switch (tab.getType()) {
            case BESTIARY: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiGuidebookDiscoveryBestiary((IGuiViewer)this, this.aePlayer));
                break;
            }
            case EFFECTS: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiGuidebookDiscoveryEffects((IGuiViewer)this, this.aePlayer));
                break;
            }
            case LANDMARKS: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiGuidebookDiscoveryLandmarks((IGuiViewer)this, this.aePlayer));
                break;
            }
            case CHARACTERS: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiGuidebookDiscoveryCharacters((IGuiViewer)this, this.aePlayer));
            }
        }
    }

    @Override
    protected List<IGuiElement> createLeftPage(int screenX, int screenY, float u, float v) {
        RectBuilder rectBuilder = Dim2D.build();
        ((Object)((Object)this)).getClass();
        RectBuilder rectBuilder2 = rectBuilder.width(176.0f);
        ((Object)((Object)this)).getClass();
        GuiTexture leftPage = new GuiTexture(rectBuilder2.height(185.0f).x((float)screenX).y((float)screenY).flush(), LEFT_PAGE);
        DiscoveryTab.DiscoveryTabType openedTab = this.aePlayer.getModule(PlayerProgressModule.class).getOpenedDiscoveryTabType();
        GuiText header = new GuiText(Dim2D.build().x((float)(screenX + 63)).y((float)(screenY + 13)).flush(), (IText)new Text((ITextComponent)new TextComponentTranslation("tab.guidebook.discovery", new Object[0]), 1.0f));
        Pos2D screen = Pos2D.flush((float)screenX, (float)screenY);
        this.bestiaryTab = new DiscoveryTab(screen.clone().addX(24.0f).addY(26.0f).flush(), DiscoveryTab.DiscoveryTabType.BESTIARY, openedTab, BESTIARY_ICON);
        this.effectTab = new DiscoveryTab(screen.clone().addX(56.0f).addY(26.0f).flush(), DiscoveryTab.DiscoveryTabType.EFFECTS, openedTab, EFFECTS_ICON);
        this.landmarkTab = new DiscoveryTab(screen.clone().addX(88.0f).addY(26.0f).flush(), DiscoveryTab.DiscoveryTabType.LANDMARKS, openedTab, LANDMARK_ICON);
        this.characterTab = new DiscoveryTab(screen.clone().addX(120.0f).addY(26.0f).flush(), DiscoveryTab.DiscoveryTabType.CHARACTERS, openedTab, CHARACTER_ICON);
        this.bestiaryTab.addAdvancedClickEvent(this::onClickTab);
        this.effectTab.addAdvancedClickEvent(this::onClickTab);
        this.landmarkTab.addAdvancedClickEvent(this::onClickTab);
        this.characterTab.addAdvancedClickEvent(this::onClickTab);
        GuiText text = new GuiText(Dim2D.build().x((float)(screenX + 26)).y((float)(screenY + 48)).flush(), (IText)new Text((ITextComponent)new TextComponentTranslation("tab.guidebook.discovery" + this.getTypeName(openedTab), new Object[0]), 1.0f));
        return Lists.newArrayList((Object[])new IGuiElement[]{leftPage, header, this.bestiaryTab, this.effectTab, this.landmarkTab, this.characterTab, text});
    }

    @Override
    protected List<IGuiElement> createRightPage(int screenX, int screenY, float u, float v) {
        RectBuilder rectBuilder = Dim2D.build();
        ((Object)((Object)this)).getClass();
        RectBuilder rectBuilder2 = rectBuilder.width(176.0f);
        ((Object)((Object)this)).getClass();
        GuiTexture rightPage = new GuiTexture(rectBuilder2.height(185.0f).x((float)screenX).y((float)screenY).flush(), RIGHT_PAGE_GENERAL);
        return Lists.newArrayList((Object[])new IGuiElement[]{rightPage});
    }

    public String getTypeName(DiscoveryTab.DiscoveryTabType type) {
        switch (type) {
            case BESTIARY: {
                return ".bestiary";
            }
            case EFFECTS: {
                return ".effects";
            }
            case LANDMARKS: {
                return ".landmarks";
            }
            case CHARACTERS: {
                return ".characters";
            }
        }
        return "";
    }
}

