/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.events.listeners.tooltip;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.entity.damage.IDamageLevelsHolder;
import com.gildedgames.aether.api.items.equipment.ItemEquipmentSlot;
import com.gildedgames.aether.api.items.equipment.effects.EffectInstance;
import com.gildedgames.aether.api.items.equipment.effects.IEffectFactory;
import com.gildedgames.aether.api.items.equipment.effects.IEffectPool;
import com.gildedgames.aether.api.items.equipment.effects.IEffectProvider;
import com.gildedgames.aether.api.items.properties.IItemProperties;
import com.gildedgames.aether.api.items.properties.ItemRarity;
import com.gildedgames.aether.client.gui.util.ToolTipCurrencyHelper;
import com.gildedgames.aether.common.shop.ShopCurrencyGilt;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class TooltipItemPropertiesListener {
    private static final ToolTipCurrencyHelper toolTipHelper = new ToolTipCurrencyHelper();

    @SubscribeEvent
    public static void onTooltipConstruction(ItemTooltipEvent event) {
        IItemProperties properties = AetherAPI.content().items().getProperties(event.getItemStack().func_77973_b());
        double value = AetherAPI.content().currency().getValue(event.getItemStack(), ShopCurrencyGilt.class);
        String durability = null;
        String modID = null;
        String NBT2 = null;
        for (String tooltip2 : event.getToolTip()) {
            if (tooltip2.contains("Durability:")) {
                durability = tooltip2;
            }
            if (tooltip2.contains(event.getItemStack().func_77973_b().getCreatorModId(event.getItemStack()) + ":")) {
                modID = tooltip2;
            }
            if (!tooltip2.contains("NBT:")) continue;
            NBT2 = tooltip2;
        }
        event.getToolTip().removeIf(tooltip -> tooltip.contains(event.getItemStack().func_77973_b().getCreatorModId(event.getItemStack()) + ":") || tooltip.contains("NBT:") || tooltip.contains("Durability:"));
        if (event.getItemStack().func_77973_b() instanceof IDamageLevelsHolder) {
            int n;
            IDamageLevelsHolder item = (IDamageLevelsHolder)event.getItemStack().func_77973_b();
            event.getToolTip().removeIf(tooltip -> tooltip.contains("Attack Damage"));
            if (item.getSlashDamageLevel() > 0.0f) {
                String slashValue;
                if (item.getSlashDamageLevel() % 1.0f == 0.0f) {
                    n = Math.round(item.getSlashDamageLevel());
                    slashValue = String.valueOf(n);
                } else {
                    float n2 = item.getSlashDamageLevel();
                    slashValue = String.valueOf(n2);
                }
                event.getToolTip().add(String.format(" %s %s", slashValue, String.format("%s %s", TextFormatting.BLUE + I18n.func_135052_a((String)"attribute.name.aether.slash", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"attribute.name.aether.damageLevel", (Object[])new Object[0]))));
            }
            if (item.getPierceDamageLevel() > 0.0f) {
                String pierceValue;
                if (item.getPierceDamageLevel() % 1.0f == 0.0f) {
                    n = Math.round(item.getPierceDamageLevel());
                    pierceValue = String.valueOf(n);
                } else {
                    float n3 = item.getPierceDamageLevel();
                    pierceValue = String.valueOf(n3);
                }
                event.getToolTip().add(String.format(" %s %s", pierceValue, String.format("%s %s", TextFormatting.RED + I18n.func_135052_a((String)"attribute.name.aether.pierce", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"attribute.name.aether.damageLevel", (Object[])new Object[0]))));
            }
            if (item.getImpactDamageLevel() > 0.0f) {
                String impactValue;
                if (item.getImpactDamageLevel() % 1.0f == 0.0f) {
                    n = Math.round(item.getImpactDamageLevel());
                    impactValue = String.valueOf(n);
                } else {
                    float n4 = item.getImpactDamageLevel();
                    impactValue = String.valueOf(n4);
                }
                event.getToolTip().add(String.format(" %s %s", impactValue, String.format("%s %s", TextFormatting.YELLOW + I18n.func_135052_a((String)"attribute.name.aether.impact", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"attribute.name.aether.damageLevel", (Object[])new Object[0]))));
            }
        }
        for (IEffectProvider provider : properties.getEffectProviders()) {
            IEffectFactory<IEffectProvider> factory = AetherAPI.content().effects().getFactory(provider.getFactory());
            EffectPoolTemporary<IEffectProvider> pool = new EffectPoolTemporary<IEffectProvider>(event.getItemStack(), provider);
            TextFormatting textFormatting1 = TextFormatting.BLUE;
            TextFormatting textFormatting2 = TextFormatting.RED;
            if (properties.getEquipmentSlot() == ItemEquipmentSlot.NONE) {
                textFormatting1 = TextFormatting.GRAY;
                textFormatting2 = TextFormatting.GRAY;
            }
            factory.createInstance(pool).addInformation(event.getToolTip(), textFormatting1, textFormatting2);
        }
        if (properties.getEquipmentSlot() != ItemEquipmentSlot.NONE) {
            ItemEquipmentSlot slot = properties.getEquipmentSlot();
            event.getToolTip().add("");
            event.getToolTip().add(I18n.func_135052_a((String)slot.getUnlocalizedName(), (Object[])new Object[0]));
        }
        if (properties.getRarity() != ItemRarity.NONE) {
            event.getToolTip().add(I18n.func_135052_a((String)properties.getRarity().getUnlocalizedName(), (Object[])new Object[0]));
        }
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            if (durability != null) {
                event.getToolTip().add(durability);
            }
            if (modID != null) {
                event.getToolTip().add(modID);
            }
            if (event.getItemStack().func_77942_o() && NBT2 != null) {
                event.getToolTip().add(NBT2);
            }
        }
        if (value >= 1.0 && value < 100.0) {
            event.getToolTip().add("");
        } else if (value >= 100.0 && value < 10000.0) {
            event.getToolTip().add("            ");
        } else if (value >= 10000.0) {
            event.getToolTip().add("            ");
            event.getToolTip().add("");
        }
    }

    @SubscribeEvent
    public static void onToolTipRender(RenderTooltipEvent.PostText event) {
        double value = AetherAPI.content().currency().getValue(event.getStack(), ShopCurrencyGilt.class);
        toolTipHelper.render(event.getFontRenderer(), event.getX(), event.getY(), event.getHeight(), value);
    }

    private static class EffectPoolTemporary<T extends IEffectProvider>
    implements IEffectPool<T> {
        private final ItemStack stack;
        private final T provider;

        public EffectPoolTemporary(ItemStack stack, T provider) {
            this.stack = stack;
            this.provider = provider;
        }

        @Override
        public ItemStack getProvider(IEffectProvider instance) {
            return this.provider == instance ? this.stack : ItemStack.field_190927_a;
        }

        @Override
        public Collection<T> getActiveProviders() {
            return Collections.singleton(this.provider);
        }

        @Override
        public Optional<EffectInstance> getInstance() {
            return Optional.empty();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }
}

