/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.events.listeners.gui;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.registry.tab.ITabClient;
import com.gildedgames.aether.api.registry.tab.ITabGroup;
import com.gildedgames.aether.api.registry.tab.ITabGroupHandler;
import com.gildedgames.aether.client.gui.tab.RenderTabGroup;
import com.gildedgames.aether.common.network.NetworkingAether;
import com.gildedgames.aether.common.network.packets.PacketOpenTab;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class GuiTabListener {
    @SideOnly(value=Side.CLIENT)
    private static final RenderTabGroup tabGroupRenderer = new RenderTabGroup();

    @SubscribeEvent
    public static void onGuiOpen(GuiOpenEvent event) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        GuiScreen gui = event.getGui();
        ITabGroupHandler groupHandler = AetherAPI.content().tabs().getActiveGroup();
        if (groupHandler != null) {
            ITabClient selectedTab = groupHandler.getClientGroup().getSelectedTab();
            if (gui != null && selectedTab.isTabValid(gui)) {
                return;
            }
            AetherAPI.content().tabs().setActiveGroup(null);
        }
        for (ITabGroupHandler tabGroupHandler : AetherAPI.content().tabs().getRegisteredTabGroups().values()) {
            ITabGroup<ITabClient> tabGroup = tabGroupHandler.getClientGroup();
            for (ITabClient tab : tabGroup.getTabs()) {
                if (event.getGui() == null || !tab.isTabValid(gui)) continue;
                if (tabGroup.getRememberSelectedTab() && tabGroup.getRememberedTab() != null) {
                    tabGroup.setSelectedTab(tabGroup.getRememberedTab());
                } else {
                    tabGroup.setSelectedTab(tab);
                }
                AetherAPI.content().tabs().setActiveGroup(tabGroupHandler);
                tabGroup.getSelectedTab().onOpen((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                NetworkingAether.sendPacketToServer(new PacketOpenTab(tabGroup.getSelectedTab()));
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onGuiMouseEvent(GuiScreenEvent.MouseInputEvent.Pre event) {
        ITabGroup<ITabClient> activeGroup;
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || !player.field_71071_by.func_70445_o().func_190926_b()) {
            return;
        }
        ITabGroupHandler groupHandler = AetherAPI.content().tabs().getActiveGroup();
        if (groupHandler != null && (activeGroup = groupHandler.getClientGroup()) != null) {
            ITabClient hoveredTab = tabGroupRenderer.getHoveredTab(activeGroup);
            if (Mouse.getEventButtonState() && hoveredTab != null && hoveredTab != activeGroup.getSelectedTab()) {
                activeGroup.getSelectedTab().onClose((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                activeGroup.setSelectedTab(hoveredTab);
                if (hoveredTab != activeGroup.getRememberedTab() && hoveredTab.isRemembered()) {
                    if (activeGroup.getRememberedTab() != null) {
                        activeGroup.getRememberedTab().onClose((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                    }
                    activeGroup.setRememberedTab(hoveredTab);
                }
                hoveredTab.onOpen((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                NetworkingAether.sendPacketToServer(new PacketOpenTab(hoveredTab));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void tickEnd(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ITabGroup<ITabClient> activeGroup;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || !player.field_71071_by.func_70445_o().func_190926_b()) {
                return;
            }
            ITabGroupHandler groupHandler = AetherAPI.content().tabs().getActiveGroup();
            if (groupHandler != null && (activeGroup = groupHandler.getClientGroup()) != null) {
                tabGroupRenderer.render(activeGroup);
            }
        }
    }
}

