/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.events.listeners.gui;

import com.gildedgames.aether.api.world.IWorldObjectHoverable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class GuiOverlayTooltipListener {
    @SubscribeEvent
    public static void onRenderIngameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft.field_71462_r == null && minecraft.field_71476_x != null) {
                IWorldObjectHoverable hoverable = null;
                if (minecraft.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
                    BlockPos pos = minecraft.field_71476_x.func_178782_a();
                    Block block = minecraft.field_71441_e.func_180495_p(pos).func_177230_c();
                    if (!(block instanceof IWorldObjectHoverable)) {
                        return;
                    }
                    hoverable = (IWorldObjectHoverable)block;
                } else if (minecraft.field_71476_x.field_72313_a == RayTraceResult.Type.ENTITY) {
                    Entity entity = minecraft.field_71476_x.field_72308_g;
                    if (!(entity instanceof IWorldObjectHoverable)) {
                        return;
                    }
                    hoverable = (IWorldObjectHoverable)entity;
                }
                if (hoverable != null) {
                    ITextComponent body = hoverable.getHoverText((World)minecraft.field_71441_e, minecraft.field_71476_x);
                    if (body == null) {
                        return;
                    }
                    String button = minecraft.field_71474_y.field_74313_G.getDisplayName();
                    String label = String.format("%s[%s]%s %s", TextFormatting.YELLOW, button, TextFormatting.WHITE, body.func_150254_d());
                    ScaledResolution resolution = new ScaledResolution(minecraft);
                    int width = minecraft.field_71466_p.func_78256_a(label);
                    int x = resolution.func_78326_a() / 2 - width / 2;
                    int y = resolution.func_78328_b() / 2 - 1 + 20;
                    Gui.func_73734_a((int)(x - 3), (int)(y - 3), (int)(x + width + 3), (int)(y + 10), (int)Integer.MIN_VALUE);
                    minecraft.field_71466_p.func_78276_b(label, x, y, 0xFFFFFF);
                }
            }
        }
    }
}

