/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.events.listeners.gui;

import com.gildedgames.aether.client.gui.overlays.IOverlay;
import com.gildedgames.aether.client.gui.overlays.PortalOverlay;
import com.gildedgames.aether.client.gui.overlays.SwetOverlay;
import com.gildedgames.aether.client.models.entities.player.LayerAetherPatronArmor;
import com.gildedgames.aether.client.models.entities.player.LayerAetherPlayerGloves;
import com.gildedgames.aether.client.models.entities.player.LayerArmorProxy;
import com.gildedgames.aether.client.models.entities.player.LayerHeadShadow;
import com.gildedgames.aether.client.models.entities.player.LayerSwetLatch;
import com.gildedgames.aether.client.renderer.particles.ParticleRainProxyFactory;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class GuiOverlayListener {
    private static final List<IOverlay> overlays = Lists.newArrayList();

    public static void init() {
        for (RenderLivingBase playerRender : new HashSet(Minecraft.func_71410_x().func_175598_ae().getSkinMap().values())) {
            playerRender.func_177094_a((LayerRenderer)new LayerArmorProxy(playerRender, new LayerAetherPlayerGloves(playerRender)));
            playerRender.func_177094_a((LayerRenderer)new LayerArmorProxy(playerRender, new LayerHeadShadow(playerRender)));
            playerRender.func_177094_a((LayerRenderer)new LayerArmorProxy(playerRender, new LayerSwetLatch(playerRender)));
            playerRender.func_177094_a((LayerRenderer)new LayerAetherPatronArmor(playerRender));
        }
        overlays.add(new PortalOverlay());
        overlays.add(new SwetOverlay());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(EnumParticleTypes.WATER_DROP.func_179348_c(), (IParticleFactory)new ParticleRainProxyFactory());
    }

    @SubscribeEvent
    public static void onRenderIngameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            for (IOverlay overlay : overlays) {
                if (!overlay.isEnabled()) continue;
                overlay.draw();
            }
        }
    }
}

