/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client.events.listeners.gui;

import com.gildedgames.aether.client.gui.misc.CustomLoadingRenderer;
import com.gildedgames.aether.client.gui.misc.GuiAetherLoading;
import com.gildedgames.aether.client.gui.misc.GuiBlackScreen;
import com.gildedgames.aether.common.init.DimensionsAether;
import com.gildedgames.orbis.lib.client.PartialTicks;
import com.gildedgames.orbis.lib.client.gui.util.GuiFrameUtils;
import com.gildedgames.orbis.lib.util.InputHelper;
import net.minecraft.client.LoadingScreenRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class GuiLoadingListener {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static boolean DRAW_BLACK_SCREEN = false;
    private static boolean DRAW_LOADING_SCREEN = false;
    private static boolean DRAWING_BLACK_FADE_OUT = false;
    private static boolean DRAWING_BLACK_FADE_IN = false;
    private static boolean CHANGE_FROM_BLACK_TO_LOAD = false;
    private static double TIME_STARTED_FADE = -1.0;
    private static double TIME_TO_FADE;
    private static Runnable AFTER_FADE;
    private static GuiAetherLoading LOADING;
    private static final CustomLoadingRenderer.ICustomLoading BLACK_LOADING;

    public static boolean isFadingIn() {
        return DRAWING_BLACK_FADE_IN;
    }

    public static void drawBlackFade(double time) {
        TIME_STARTED_FADE = System.currentTimeMillis();
        DRAWING_BLACK_FADE_IN = false;
        DRAWING_BLACK_FADE_OUT = true;
        TIME_TO_FADE = time;
    }

    public static void drawBlackFadeIn(double time, Runnable after) {
        TIME_STARTED_FADE = System.currentTimeMillis();
        DRAWING_BLACK_FADE_OUT = false;
        DRAWING_BLACK_FADE_IN = true;
        TIME_TO_FADE = time;
        AFTER_FADE = after;
    }

    public static boolean isLoadingScreen() {
        return DRAW_LOADING_SCREEN;
    }

    public static void setDrawBlackScreen(boolean flag) {
        DRAW_BLACK_SCREEN = flag;
        if (flag) {
            CustomLoadingRenderer.CURRENT = BLACK_LOADING;
        } else if (CustomLoadingRenderer.CURRENT == BLACK_LOADING) {
            CustomLoadingRenderer.CURRENT = null;
        }
    }

    public static void setChangeFromBlackToLoad(boolean flag) {
        CHANGE_FROM_BLACK_TO_LOAD = flag;
    }

    public static void setDrawLoading(boolean flag) {
        DRAW_LOADING_SCREEN = flag;
        if (flag) {
            LOADING = new GuiAetherLoading();
            LOADING.func_146280_a(Minecraft.func_71410_x(), MathHelper.func_76141_d((float)InputHelper.getScreenWidth()), MathHelper.func_76141_d((float)InputHelper.getScreenHeight()));
            LOADING.func_73866_w_();
            CustomLoadingRenderer.CURRENT = LOADING;
        } else if (CustomLoadingRenderer.CURRENT == LOADING) {
            CustomLoadingRenderer.CURRENT = null;
        }
    }

    @SubscribeEvent
    public static void onOpenGui(GuiOpenEvent event) {
        if (GuiLoadingListener.mc.field_71441_e != null && event.getGui() instanceof GuiInventory) {
            boolean necro;
            boolean bl = necro = GuiLoadingListener.mc.field_71441_e.field_73011_w.func_186058_p() == DimensionsAether.NECROMANCER_TOWER;
            if (necro && !GuiLoadingListener.mc.field_71439_g.func_184812_l_()) {
                event.setCanceled(true);
            }
        }
        if (DRAW_BLACK_SCREEN && event.getGui() instanceof GuiDownloadTerrain) {
            event.setGui((GuiScreen)new GuiBlackScreen());
        }
    }

    private static double getSecondsSinceStart() {
        return ((double)System.currentTimeMillis() - TIME_STARTED_FADE) / 1000.0;
    }

    public static void drawFade(boolean disableDepth) {
        if (DRAWING_BLACK_FADE_OUT || DRAWING_BLACK_FADE_IN) {
            float bgAlpha = Math.max(0.0f, DRAWING_BLACK_FADE_OUT ? 1.0f - (float)(GuiLoadingListener.getSecondsSinceStart() / TIME_TO_FADE) : (float)(GuiLoadingListener.getSecondsSinceStart() / TIME_TO_FADE));
            int bg = GuiFrameUtils.changeAlpha((int)-16777216, (int)((int)(bgAlpha * 255.0f)));
            GlStateManager.func_179094_E();
            if (disableDepth) {
                GlStateManager.func_179097_i();
            }
            GuiUtils.drawGradientRect((int)0, (int)0, (int)0, (int)MathHelper.func_76141_d((float)InputHelper.getScreenWidth()), (int)MathHelper.func_76141_d((float)InputHelper.getScreenHeight()), (int)bg, (int)bg);
            if (disableDepth) {
                GlStateManager.func_179126_j();
            }
            GlStateManager.func_179121_F();
            if (GuiLoadingListener.getSecondsSinceStart() >= TIME_TO_FADE) {
                DRAWING_BLACK_FADE_OUT = false;
                DRAWING_BLACK_FADE_IN = false;
                if (AFTER_FADE != null) {
                    AFTER_FADE.run();
                    AFTER_FADE = null;
                }
            }
        }
    }

    public static void drawOverlay() {
        if (CHANGE_FROM_BLACK_TO_LOAD && DRAW_BLACK_SCREEN) {
            GuiLoadingListener.setChangeFromBlackToLoad(false);
            GuiLoadingListener.setDrawBlackScreen(false);
            GuiLoadingListener.drawBlackFade(2.0);
            GuiLoadingListener.setDrawLoading(true);
        }
        if (DRAW_LOADING_SCREEN) {
            if (Minecraft.func_71410_x().field_71441_e != null) {
                Minecraft.func_71410_x().func_147118_V().func_147690_c();
            }
            GuiLoadingListener.setChangeFromBlackToLoad(false);
            CustomLoadingRenderer.CURRENT = LOADING;
            GlStateManager.func_179094_E();
            if (!DRAWING_BLACK_FADE_OUT) {
                // empty if block
            }
            LOADING.func_73863_a(InputHelper.getMouseX(), InputHelper.getMouseY(), PartialTicks.get());
            if (!DRAWING_BLACK_FADE_OUT) {
                // empty if block
            }
            GlStateManager.func_179121_F();
        } else {
            if (DRAW_BLACK_SCREEN) {
                CustomLoadingRenderer.CURRENT = BLACK_LOADING;
                GlStateManager.func_179094_E();
                GlStateManager.func_179097_i();
                GuiUtils.drawGradientRect((int)0, (int)0, (int)0, (int)MathHelper.func_76141_d((float)InputHelper.getScreenWidth()), (int)MathHelper.func_76141_d((float)InputHelper.getScreenHeight()), (int)-16777216, (int)-16777216);
                GlStateManager.func_179126_j();
                GlStateManager.func_179121_F();
            }
            GuiLoadingListener.drawFade(true);
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            GuiLoadingListener.drawOverlay();
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71461_s.getClass() == LoadingScreenRenderer.class) {
            Minecraft.func_71410_x().field_71461_s = new CustomLoadingRenderer(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71461_s);
        }
    }

    static {
        LOADING = new GuiAetherLoading();
        BLACK_LOADING = GuiLoadingListener::drawOverlay;
    }
}

