/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.client;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.client.events.listeners.gui.GuiOverlayListener;
import com.gildedgames.aether.client.gui.misc.CustomLoadingRenderer;
import com.gildedgames.aether.client.renderer.AetherRenderers;
import com.gildedgames.aether.client.renderer.particles.ParticleAetherStatusEffect;
import com.gildedgames.aether.client.renderer.particles.ParticleImpact;
import com.gildedgames.aether.client.renderer.particles.ParticlePierce;
import com.gildedgames.aether.client.renderer.particles.ParticleSlash;
import com.gildedgames.aether.common.AetherCore;
import com.gildedgames.aether.common.CommonProxy;
import com.gildedgames.aether.common.ConfigAether;
import com.gildedgames.aether.common.analytics.GAReporter;
import com.gildedgames.aether.common.analytics.GameAnalytics;
import com.gildedgames.aether.common.containers.overlays.tabs.guidebook.TabDiscovery;
import com.gildedgames.aether.common.containers.overlays.tabs.guidebook.TabEquipment;
import com.gildedgames.aether.common.containers.overlays.tabs.guidebook.TabGuidebook;
import com.gildedgames.aether.common.containers.overlays.tabs.guidebook.TabLoreTome;
import com.gildedgames.aether.common.containers.overlays.tabs.guidebook.TabStatus;
import com.gildedgames.aether.common.util.helpers.PerfHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
extends CommonProxy {
    @Override
    public void spawnSlashParticleFrom(World world, double x, double y, double z, double offsetX, double offsetY, double offsetZ) {
        ParticleSlash effect = new ParticleSlash(world, x, y, z, 1.0, 1.0, 1.0, 1.0f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)effect);
    }

    @Override
    public void spawnPierceParticleFrom(World world, double x, double y, double z, double offsetX, double offsetY, double offsetZ) {
        ParticlePierce effect = new ParticlePierce(world, x, y, z, 1.0, 1.0, 1.0, 1.0f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)effect);
    }

    @Override
    public void spawnImpactParticleFrom(World world, double x, double y, double z, double offsetX, double offsetY, double offsetZ) {
        ParticleImpact effect = new ParticleImpact(world, x, y, z, 1.0, 1.0, 1.0, 1.0f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)effect);
    }

    @Override
    public void spawnEffectParticles(World world, double x, double y, double z, double motionX, double motionY, double motionZ, float particleRed, float particleGreen, float particleBlue) {
        ParticleAetherStatusEffect particle = new ParticleAetherStatusEffect(world, x, y, z, motionX, motionY, motionZ, particleRed, particleGreen, particleBlue);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
    }

    @Override
    public void turnOffScreen() {
        Minecraft.func_71410_x().func_147108_a(null);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        Minecraft.func_71410_x().field_71461_s = new CustomLoadingRenderer(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71461_s);
        MinecraftForge.EVENT_BUS.register((Object)this);
        PerfHelper.measure("Pre-initialize special renders", AetherRenderers::preInit);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        PerfHelper.measure("Initialize analytics", () -> {
            GAReporter gAReporter = AetherCore.ANALYTICS = AetherCore.isInsideDevEnvironment() ? new GameAnalytics() : new GameAnalytics("c8e4d94251ce253e138ae8a702e20301", "1ba3cb91e03cbb578b97c26f872e812dd05f5bbb");
            if (Minecraft.func_71410_x().func_70002_Q()) {
                if (ConfigAether.analyticsEnabled) {
                    AetherCore.ANALYTICS.setup();
                    return;
                }
            }
            AetherCore.LOGGER.info("GameAnalytics disabled by user preference (by config or vanilla snooper settings)");
            AetherCore.ANALYTICS.disable();
        });
        PerfHelper.measure("Initialize special renders", AetherRenderers::init);
        GuiOverlayListener.init();
        AetherAPI.content().tabs().getInventoryGroup().registerClientTab(new TabGuidebook.Client());
        AetherAPI.content().tabs().getInventoryGroup().registerClientTab(new TabEquipment.Client());
        AetherAPI.content().tabs().getInventoryGroup().registerClientTab(new TabStatus.Client());
        AetherAPI.content().tabs().getInventoryGroup().registerClientTab(new TabDiscovery.Client());
        AetherAPI.content().tabs().getInventoryGroup().registerClientTab(new TabLoreTome.Client());
        AetherAPI.content().dialog().attachReloadListener();
        AetherAPI.content().tgManager().attachReloadListener();
    }

    @Override
    public void displayDismountMessage(EntityPlayer player) {
        if (player == Minecraft.func_71410_x().field_71439_g) {
            Minecraft.func_71410_x().field_71456_v.func_110326_a(I18n.func_135052_a((String)"mount.onboard", (Object[])new Object[]{Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName()}), false);
        }
    }

    @Override
    public void modifyEntityQuicksoil(EntityLivingBase entity) {
        if (entity == Minecraft.func_71410_x().field_71439_g) {
            KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151463_i(), (boolean)false);
        }
        super.modifyEntityQuicksoil(entity);
    }

    @Override
    public void spawnCampfireStartParticles(World world, double x, double y, double z) {
        Random r = world.field_73012_v;
        for (int i = 0; i < 50; ++i) {
            double range = r.nextDouble() * 0.9;
            if (r.nextInt(10) == 0) {
                world.func_175688_a(EnumParticleTypes.LAVA, x + r.nextDouble() * (r.nextBoolean() ? range : -range), y, z + r.nextDouble() * (r.nextBoolean() ? range : -range), r.nextDouble() * (r.nextBoolean() ? range : -range) * 0.2, 0.075 * r.nextDouble(), r.nextDouble() * (r.nextBoolean() ? range : -range) * 0.2, new int[0]);
            }
            if (r.nextInt(4) == 0) {
                world.func_175688_a(EnumParticleTypes.FLAME, x + r.nextDouble() * (r.nextBoolean() ? range : -range), y, z + r.nextDouble() * (r.nextBoolean() ? range : -range), r.nextDouble() * (r.nextBoolean() ? range : -range) * 0.1, 0.1 * r.nextDouble(), r.nextDouble() * (r.nextBoolean() ? range : -range) * 0.1, new int[0]);
            }
            if (r.nextInt(4) != 0) continue;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + r.nextDouble() * (r.nextBoolean() ? range : -range), y, z + r.nextDouble() * (r.nextBoolean() ? range : -range), r.nextDouble() * (r.nextBoolean() ? range : -range) * 0.1, 0.1 * r.nextDouble(), r.nextDouble() * (r.nextBoolean() ? range : -range) * 0.1, new int[0]);
        }
    }

    @Override
    public void spawnCampfireParticles(World world, double x, double y, double z) {
        Random r = world.field_73012_v;
        for (int i = 0; i < 10; ++i) {
            double range = r.nextDouble() * 0.75;
            if (r.nextInt(800) == 0) {
                world.func_175688_a(EnumParticleTypes.LAVA, r.nextDouble() * (r.nextBoolean() ? range : -range), y, z + r.nextDouble() * (r.nextBoolean() ? range : -range), r.nextDouble() * (r.nextBoolean() ? range : -range) * 0.001, 0.075 * r.nextDouble(), r.nextDouble() * (r.nextBoolean() ? range : -range) * 0.001, new int[0]);
            }
            if (r.nextInt(4) == 0) {
                world.func_175688_a(EnumParticleTypes.FLAME, x + r.nextDouble() * (r.nextBoolean() ? range : -range), y, z + r.nextDouble() * (r.nextBoolean() ? range : -range), r.nextDouble() * (r.nextBoolean() ? range : -range) * 0.001, 0.04 * r.nextDouble(), r.nextDouble() * (r.nextBoolean() ? range : -range) * 0.001, new int[0]);
            }
            if (r.nextInt(4) != 0) continue;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + r.nextDouble() * (r.nextBoolean() ? range : -range), y, z + r.nextDouble() * (r.nextBoolean() ? range : -range), r.nextDouble() * (r.nextBoolean() ? range : -range) * 0.001, 0.075 * r.nextDouble(), r.nextDouble() * (r.nextBoolean() ? range : -range) * 0.001, new int[0]);
        }
    }

    @Override
    public IThreadListener getMinecraftThread() {
        return Minecraft.func_71410_x();
    }
}

