/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.api.world.templates;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.util.TemplateUtil;
import com.gildedgames.aether.api.world.templates.TemplateDefinition;
import com.gildedgames.aether.api.world.templates.TemplateLoc;
import com.gildedgames.orbis.lib.util.mc.NBT;
import com.gildedgames.orbis.lib.util.mc.NBTHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class TemplateInstance
implements NBT {
    private final ChunkPos[] chunksOccupied;
    private TemplateDefinition def;
    private int templateID;
    private TemplateLoc loc;
    private boolean hasGeneratedAChunk;

    public TemplateInstance(TemplateDefinition def, TemplateLoc loc) {
        this.def = def;
        this.templateID = AetherAPI.content().templates().getID(this.def);
        this.loc = loc;
        this.chunksOccupied = TemplateUtil.getChunksInsideTemplate(this.getDef(), this.getLoc());
    }

    public TemplateInstance(NBTTagCompound tag) {
        this.read(tag);
        this.chunksOccupied = TemplateUtil.getChunksInsideTemplate(this.getDef(), this.getLoc());
    }

    public TemplateDefinition getDef() {
        return this.def;
    }

    public TemplateLoc getLoc() {
        return this.loc;
    }

    public ChunkPos[] getChunksOccupied() {
        return this.chunksOccupied;
    }

    public void markGeneratedAChunk() {
        this.hasGeneratedAChunk = true;
    }

    public boolean hasGeneratedAChunk() {
        return this.hasGeneratedAChunk;
    }

    public boolean equals(Object obj) {
        boolean flag = false;
        if (obj == this) {
            flag = true;
        } else if (obj instanceof TemplateInstance) {
            TemplateInstance o = (TemplateInstance)obj;
            EqualsBuilder builder = new EqualsBuilder();
            builder.append(this.templateID, o.templateID);
            builder.append((Object)this.loc, (Object)o.loc);
            builder.append(this.hasGeneratedAChunk, o.hasGeneratedAChunk);
            flag = builder.isEquals();
        }
        return flag;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.templateID);
        builder.append((Object)this.loc);
        builder.append(this.hasGeneratedAChunk);
        return builder.toHashCode();
    }

    public void write(NBTTagCompound tag) {
        tag.func_74768_a("id", this.templateID);
        tag.func_74782_a("loc", (NBTBase)NBTHelper.writeRaw((NBT)this.loc));
        tag.func_74757_a("hasGeneratedAChunk", this.hasGeneratedAChunk);
    }

    public void read(NBTTagCompound tag) {
        this.def = AetherAPI.content().templates().get(tag.func_74762_e("id"));
        this.loc = new TemplateLoc(tag.func_74775_l("loc"));
        this.hasGeneratedAChunk = tag.func_74767_n("hasGeneratedAChunk");
    }
}

