/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.api.world.templates;

import com.gildedgames.aether.api.world.templates.PlacementConditionTemplate;
import com.gildedgames.aether.api.world.templates.PostPlacementTemplate;
import com.gildedgames.orbis.lib.processing.CenterOffsetProcessor;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.gen.structure.template.Template;

public class TemplateDefinition {
    private final Template template;
    private CenterOffsetProcessor offset;
    private List<PlacementConditionTemplate> conditions = Lists.newArrayList();
    private List<PostPlacementTemplate> postPlacements = Lists.newArrayList();
    private boolean randomRotation;

    public TemplateDefinition(Template template) {
        this.template = template;
    }

    public TemplateDefinition setPostPlacements(PostPlacementTemplate postPlacement, PostPlacementTemplate ... postPlacements) {
        this.postPlacements = Lists.newArrayList((Object[])postPlacements);
        this.postPlacements.add(postPlacement);
        return this;
    }

    public List<PostPlacementTemplate> getPostPlacements() {
        return this.postPlacements;
    }

    public TemplateDefinition setConditions(PlacementConditionTemplate condition, PlacementConditionTemplate ... conditions) {
        this.conditions = Lists.newArrayList((Object[])conditions);
        this.conditions.add(condition);
        return this;
    }

    public CenterOffsetProcessor getOffset() {
        return this.offset;
    }

    public TemplateDefinition setOffset(CenterOffsetProcessor offset) {
        this.offset = offset;
        return this;
    }

    public List<PlacementConditionTemplate> getConditions() {
        return this.conditions;
    }

    public Template getTemplate() {
        return this.template;
    }

    public TemplateDefinition setRandomRotation(boolean flag) {
        this.randomRotation = flag;
        return this;
    }

    public boolean hasRandomRotation() {
        return this.randomRotation;
    }

    public TemplateDefinition clone() {
        TemplateDefinition clone = new TemplateDefinition(this.template).setOffset(this.offset).setRandomRotation(this.randomRotation);
        clone.conditions = this.conditions;
        return clone;
    }
}

