/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.api.world.generation;

import com.gildedgames.aether.api.world.decoration.WorldDecorationGenerator;
import com.gildedgames.orbis.lib.core.BlueprintDefinition;
import com.gildedgames.orbis.lib.core.CreationData;
import com.gildedgames.orbis.lib.core.ICreationData;
import com.gildedgames.orbis.lib.core.baking.BakedBlueprint;
import com.gildedgames.orbis.lib.core.util.BlueprintPlacer;
import com.gildedgames.orbis.lib.processing.BlockAccessWorldSlice;
import com.gildedgames.orbis.lib.processing.DataPrimer;
import com.gildedgames.orbis.lib.processing.IBlockAccessExtended;
import com.gildedgames.orbis.lib.world.WorldSlice;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class BlueprintWorldGen
implements WorldDecorationGenerator {
    private final BlueprintDefinition def;
    private BakedBlueprint baked;

    public BlueprintWorldGen(BlueprintDefinition def) {
        this.def = def;
    }

    @Override
    public boolean generate(WorldSlice slice, Random rand, BlockPos pos) {
        BlockPos offsetPosition;
        DataPrimer primer;
        boolean result;
        if (this.baked == null) {
            Rotation rotation = this.def.hasRandomRotation() ? BlueprintPlacer.getRandomRotation((Random)rand) : Rotation.NONE;
            CreationData data = new CreationData(slice.getWorld());
            data.rotation(rotation);
            this.baked = new BakedBlueprint(this.def, (ICreationData)data);
        }
        if (result = (primer = new DataPrimer((IBlockAccessExtended)new BlockAccessWorldSlice(slice))).canGenerate(this.baked, offsetPosition = pos.func_177981_b(this.def.getFloorHeight()))) {
            primer.place(this.baked, offsetPosition);
            this.baked = null;
        }
        return result;
    }
}

