/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.api.world.decoration;

import com.gildedgames.aether.api.util.OpenSimplexNoise;
import com.gildedgames.aether.api.world.decoration.WorldDecoration;
import com.gildedgames.orbis.lib.world.WorldSlice;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class WorldDecorationUtil {
    public static void generateDecorations(List<WorldDecoration> decorations, World world, Random rand, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        WorldSlice slice = new WorldSlice(world, chunkPos);
        for (WorldDecoration decoration : decorations) {
            for (int count = 0; count < decoration.getGenerationCount(); ++count) {
                if (!decoration.shouldGenerate(rand) || !TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)decoration.getDecorateType())) continue;
                BlockPos placeAt = decoration.findPositionToPlace(world, rand, pos);
                decoration.getGenerator(rand).generate(slice, rand, placeAt);
            }
        }
    }

    public static void generateDecorationsWithNoise(List<WorldDecoration> decorations, World world, Random rand, BlockPos pos, OpenSimplexNoise noise, float openAreaChance, float clumpedDecorationCountModifier) {
        ChunkPos chunkPos = new ChunkPos(pos);
        WorldSlice slice = new WorldSlice(world, chunkPos);
        block0: for (WorldDecoration decoration : decorations) {
            int count = 0;
            while ((float)count < (float)decoration.getGenerationCount() * clumpedDecorationCountModifier) {
                if (decoration.shouldGenerate(rand) && TerrainGen.decorate((World)world, (Random)rand, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)decoration.getDecorateType())) {
                    boolean override;
                    BlockPos placeAt = decoration.findPositionToPlace(world, rand, pos);
                    boolean isClumped = noise.eval((double)placeAt.func_177958_n() / 100.0, (double)placeAt.func_177952_p() / 100.0) + 1.0 < (double)rand.nextFloat();
                    boolean bl = override = rand.nextFloat() < openAreaChance;
                    if (isClumped || override) {
                        decoration.getGenerator(rand).generate(slice, rand, placeAt);
                        if (!isClumped) continue block0;
                    }
                }
                ++count;
            }
        }
    }
}

