/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.api.world.decoration;

import com.gildedgames.aether.api.world.decoration.WorldDecoration;
import com.gildedgames.aether.api.world.decoration.WorldDecorationGenerator;
import com.gildedgames.aether.api.world.decoration.WorldDecorationPositioner;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

public class WorldDecorationSimple
implements WorldDecoration {
    private final int count;
    private final WorldDecorationGenerator[] generators;
    private final float percentRequired;
    private final DecorateBiomeEvent.Decorate.EventType decorateType;
    private final WorldDecorationPositioner positioner;

    public WorldDecorationSimple(int count, float percentRequired, DecorateBiomeEvent.Decorate.EventType decorateType, WorldDecorationPositioner positioner, WorldDecorationGenerator ... generators) {
        this.decorateType = decorateType;
        for (WorldDecorationGenerator generator : generators) {
            if (generator != null) continue;
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this.count = count;
        this.generators = generators;
        this.percentRequired = percentRequired;
        this.positioner = positioner;
    }

    @Override
    public DecorateBiomeEvent.Decorate.EventType getDecorateType() {
        return this.decorateType;
    }

    @Override
    public boolean shouldGenerate(Random random) {
        if (this.percentRequired <= 0.0f) {
            return true;
        }
        return random.nextFloat() <= this.percentRequired;
    }

    @Override
    public int getGenerationCount() {
        return this.count;
    }

    @Override
    public WorldDecorationGenerator getGenerator(Random rand) {
        return this.generators[rand.nextInt(this.generators.length)];
    }

    @Override
    public final BlockPos findPositionToPlace(World world, Random rand, BlockPos pos) {
        return this.positioner.findPositionToPlace(world, rand, pos);
    }
}

