/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.api.util;

import com.gildedgames.aether.api.world.templates.TemplateDefinition;
import com.gildedgames.aether.api.world.templates.TemplateLoc;
import com.gildedgames.orbis.lib.processing.IBlockAccessExtended;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class TemplateUtil {
    public static StructureBoundingBox getBoundingBoxFromTemplate(TemplateDefinition def, TemplateLoc loc) {
        Rotation rotation = loc.getSettings().func_186215_c();
        BlockPos size = def.getTemplate().func_186257_a(rotation);
        StructureBoundingBox bb = new StructureBoundingBox(0, 0, 0, size.func_177958_n(), size.func_177956_o() - 1, size.func_177952_p());
        switch (rotation) {
            default: {
                break;
            }
            case CLOCKWISE_90: {
                bb.func_78886_a(-size.func_177958_n(), 0, 0);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                bb.func_78886_a(0, 0, -size.func_177952_p());
                break;
            }
            case CLOCKWISE_180: {
                bb.func_78886_a(-size.func_177958_n(), 0, -size.func_177952_p());
            }
        }
        BlockPos pos = loc.getPos();
        if (loc.isCentered()) {
            pos = TemplateUtil.getCenteredPos(def, loc);
        }
        bb.func_78886_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return bb;
    }

    public static BlockPos getCenteredPos(TemplateDefinition def, TemplateLoc info) {
        BlockPos pos = info.getPos();
        BlockPos size = def.getTemplate().func_186257_a(info.getSettings().func_186215_c());
        switch (info.getSettings().func_186215_c()) {
            default: {
                pos = pos.func_177963_a(-((double)size.func_177958_n() / 2.0) + 1.0, 0.0, -((double)size.func_177952_p() / 2.0) + 1.0);
                break;
            }
            case CLOCKWISE_90: {
                pos = pos.func_177963_a((double)size.func_177958_n() / 2.0, 0.0, -((double)size.func_177952_p() / 2.0) + 1.0);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                pos = pos.func_177963_a(-((double)size.func_177958_n() / 2.0) + 1.0, 0.0, (double)size.func_177952_p() / 2.0);
                break;
            }
            case CLOCKWISE_180: {
                pos = pos.func_177963_a((double)size.func_177958_n() / 2.0, 0.0, (double)size.func_177952_p() / 2.0);
            }
        }
        if (def.getOffset() != null) {
            pos = pos.func_177971_a((Vec3i)def.getOffset().process(info.getSettings().func_186215_c()));
        }
        return pos;
    }

    public static ChunkPos[] getChunksInsideTemplate(TemplateDefinition template, TemplateLoc loc) {
        StructureBoundingBox bb = TemplateUtil.getBoundingBoxFromTemplate(template, loc);
        int startChunkX = bb.field_78897_a >> 4;
        int startChunkY = bb.field_78896_c >> 4;
        int endChunkX = bb.field_78893_d >> 4;
        int endChunkY = bb.field_78892_f >> 4;
        int width = endChunkX - startChunkX + 1;
        int length = endChunkY - startChunkY + 1;
        ChunkPos[] chunks = new ChunkPos[width * length];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < length; ++y) {
                chunks[x + y * width] = new ChunkPos(startChunkX + x, startChunkY + y);
            }
        }
        return chunks;
    }

    public static boolean canGrowInto(Block block) {
        Material material = block.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151584_j || material == Material.field_151585_k || material == Material.field_151597_y;
    }

    public static boolean isReplaceable(IBlockAccessExtended world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || TemplateUtil.canGrowInto(state.func_177230_c());
    }

    @SafeVarargs
    public static <T> T pickRandom(Random rand, T ... objects) {
        return objects[rand.nextInt(objects.length)];
    }
}

