/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.api.util;

import com.gildedgames.aether.api.util.OpenSimplexNoise;

public class NoiseUtil {
    public static float lerpReverse(float b, float a, float f) {
        return a * (1.0f - f) + b * f;
    }

    public static float lerp(float a, float b, float f) {
        return a * (1.0f - f) + b * f;
    }

    public static double lerp(double a, double b, double f) {
        return a * (1.0 - f) + b * f;
    }

    public static double genNoise(OpenSimplexNoise noise, double nx, double ny, double nz) {
        double noise1 = noise.eval(nx, ny, nz);
        double noise2 = 0.5 * noise.eval(nx * 8.0, ny * 8.0, nz * 8.0);
        double noise3 = 0.25 * noise.eval(nx * 16.0, ny * 16.0, nz * 16.0);
        double noise4 = 0.1 * noise.eval(nx * 32.0, ny * 32.0, nz * 32.0);
        return (noise1 + noise2 + noise3 + noise4) / 4.0;
    }

    public static double normalise(double value) {
        return 0.5 + value * 0.5;
    }

    public static double something(OpenSimplexNoise noise, double x, double z) {
        double frequency = 0.5;
        double amplitude = 1.5;
        double lacunarity = 3.0;
        double gain = 0.25;
        int octaves = 3;
        double total = 0.0;
        for (int i = 0; i < 3; ++i) {
            total += noise.eval(x * frequency, z * frequency) * amplitude;
            frequency *= 3.0;
            amplitude *= 0.25;
        }
        return total;
    }
}

