/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.api.shop;

import com.gildedgames.aether.api.AetherAPI;
import com.gildedgames.aether.api.shop.IShopBuy;
import com.gildedgames.aether.api.shop.IShopFilter;
import com.gildedgames.aether.api.shop.IShopInstance;
import java.util.List;
import net.minecraft.item.ItemStack;

public class ShopUtil {
    public static int getFilteredPrice(IShopInstance instance, ItemStack stack, int price, List<IShopFilter> filters) {
        int filteredPrice = price;
        for (IShopFilter filter : filters) {
            filteredPrice = filter.getFilteredPrice(instance, stack, filteredPrice);
        }
        return filteredPrice;
    }

    public static int getFilteredPrice(IShopInstance instance, ItemStack stack, int price) {
        return ShopUtil.getFilteredPrice(instance, stack, price, AetherAPI.content().shop().getGlobalFilters());
    }

    public static double getFilteredPrice(IShopInstance instance, ItemStack stack, double price, List<IShopFilter> filters) {
        double filteredPrice = price;
        for (IShopFilter filter : filters) {
            filteredPrice = filter.getFilteredPrice(instance, stack, filteredPrice);
        }
        return filteredPrice;
    }

    public static int getFilteredPrice(IShopInstance instance, IShopBuy buy, List<IShopFilter> filters) {
        return ShopUtil.getFilteredPrice(instance, buy.getItemStack(), buy.getPrice(), filters);
    }

    public static int getFilteredPrice(IShopInstance instance, IShopBuy buy) {
        return ShopUtil.getFilteredPrice(instance, buy, AetherAPI.content().shop().getGlobalFilters());
    }

    public static double getFilteredPrice(IShopInstance instance, ItemStack stack, double price) {
        return ShopUtil.getFilteredPrice(instance, stack, price, AetherAPI.content().shop().getGlobalFilters());
    }
}

