/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.api.player.conditions.events;

import com.gildedgames.aether.api.player.conditions.events.ISeeEntityEventsListener;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SeeEntityEvents {
    private static final int SEE_ENTITY_RADIUS = 10;
    private final List<ISeeEntityEventsListener> listeners = Lists.newArrayList();

    public void listen(ISeeEntityEventsListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void unlisten(ISeeEntityEventsListener listener) {
        this.listeners.remove(listener);
    }

    @SubscribeEvent
    public void onLivingEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            double minX = entity.field_70165_t - 10.0;
            double minY = entity.field_70163_u - 10.0;
            double minZ = entity.field_70161_v - 10.0;
            double maxX = entity.field_70165_t + 10.0;
            double maxY = entity.field_70163_u + 10.0;
            double maxZ = entity.field_70161_v + 10.0;
            AxisAlignedBB checkingArea = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
            List entitiesInSight = entity.field_70170_p.func_72872_a(EntityLivingBase.class, checkingArea);
            for (EntityLivingBase e : entitiesInSight) {
                if (!player.func_70685_l((Entity)e)) continue;
                for (ISeeEntityEventsListener l : this.listeners) {
                    l.onSeeEntity((Entity)e, player);
                }
            }
        }
    }
}

