/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.api.items.properties;

import com.gildedgames.aether.api.items.EffectActivator;
import com.gildedgames.aether.api.items.equipment.ItemEquipmentSlot;
import com.gildedgames.aether.api.items.equipment.effects.IEffectPrecondition;
import com.gildedgames.aether.api.items.equipment.effects.IEffectProvider;
import com.gildedgames.aether.api.items.properties.ItemRarity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;

public class ItemPropertiesBuilder {
    private final Collection<IEffectProvider> effects = new ArrayList<IEffectProvider>();
    private final Collection<IEffectPrecondition> preconditions = new ArrayList<IEffectPrecondition>();
    private final Collection<EffectActivator> effectActivators = new ArrayList<EffectActivator>();
    private ItemEquipmentSlot slot = ItemEquipmentSlot.NONE;
    private ItemRarity rarity = ItemRarity.NONE;

    public ItemPropertiesBuilder withRarity(@Nonnull ItemRarity rarity) {
        Validate.notNull((Object)((Object)rarity), (String)"Rarity cannot be null, use ItemRarity#NONE", (Object[])new Object[0]);
        this.rarity = rarity;
        return this;
    }

    public ItemPropertiesBuilder withSlot(@Nonnull ItemEquipmentSlot slot) {
        Validate.notNull((Object)"Equipment slot cannot be null, use ItemEquipmentSlot#NONE");
        this.slot = slot;
        return this;
    }

    public ItemPropertiesBuilder withEffect(IEffectProvider effect) {
        this.effects.add(effect);
        return this;
    }

    public ItemPropertiesBuilder withPrecondition(IEffectPrecondition precondition) {
        this.preconditions.add(precondition);
        return this;
    }

    public ItemPropertiesBuilder withEffectActivators(EffectActivator ... effectActivators) {
        this.effectActivators.addAll(Arrays.asList(effectActivators));
        return this;
    }

    public Collection<IEffectProvider> getEffects() {
        return Collections.unmodifiableCollection(this.effects);
    }

    public Collection<IEffectPrecondition> getPreconditions() {
        return Collections.unmodifiableCollection(this.preconditions);
    }

    public Collection<EffectActivator> getEffectActivators() {
        return Collections.unmodifiableCollection(this.effectActivators);
    }

    public ItemEquipmentSlot getSlot() {
        return this.slot;
    }

    public ItemRarity getRarity() {
        return this.rarity;
    }
}

