/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.api.entity.effects;

import com.gildedgames.aether.api.entity.effects.EEffectIntensity;
import com.gildedgames.aether.api.entity.effects.IAetherStatusEffectPool;
import com.gildedgames.aether.api.registrar.CapabilitiesAether;
import com.gildedgames.orbis.lib.util.mc.NBT;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IAetherStatusEffects
extends NBT {
    public static final int TICKS_PER_SECOND = 20;
    public static final int NUMBER_OF_EFFECTS = 11;

    public void tick(EntityLivingBase var1);

    public void applyEffect(EntityLivingBase var1, int var2);

    public void onEffectEnd();

    public void addBuildup(@Nonnegative int var1, double var2);

    public void setBuildup(@Nonnegative int var1);

    public void setApplied(boolean var1);

    public void reduceBuildup();

    public void resetEffect();

    public void addResistance(double var1);

    public void resetResistance();

    public double calculateResistances();

    public void setActiveEffectTimeModifier(double var1);

    @SideOnly(value=Side.CLIENT)
    public void addInformation(Collection<String> var1);

    public int getBuildupFromIntensity(EEffectIntensity var1);

    public static boolean applyStatusEffect(EntityLivingBase livingBase, effectTypes effectType, @Nonnegative int buildup) {
        IAetherStatusEffectPool effects = (IAetherStatusEffectPool)livingBase.getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null);
        if (effects != null) {
            effects.applyStatusEffect(effectType, buildup);
            return true;
        }
        return false;
    }

    public static boolean isEffectApplying(EntityLivingBase livingBase, effectTypes effectType) {
        IAetherStatusEffectPool effects = (IAetherStatusEffectPool)livingBase.getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null);
        if (effects != null) {
            return effects.isEffectApplied(effectType);
        }
        return false;
    }

    public static boolean doesEffectHaveBuildup(EntityLivingBase livingBase, effectTypes effectType) {
        IAetherStatusEffectPool effects = (IAetherStatusEffectPool)livingBase.getCapability(CapabilitiesAether.STATUS_EFFECT_POOL, null);
        if (effects != null) {
            return effects.getBuildupFromEffect(effectType) > 0;
        }
        return false;
    }

    public boolean isDirty();

    public void markDirty();

    public void markClean();

    public void adjustDecrease(int var1);

    public void resetDecrease();

    public int getBuildup();

    public double getResistance();

    public int getTimer();

    public int getActiveEffectTime();

    public double getActiveEffectTimeModifier();

    public boolean getIsEffectApplied();

    public effectTypes getEffectType();

    public float getEffectTextAlpha();

    public String getEffectName();

    @Nullable
    public AttributeModifier getAttributeModifier();

    public static enum effectTypes {
        AMBROSIUM_POISONING("effect.aether.ambrosium_poisoning", 0, 1, 1, 120, 10),
        TOXIN("effect.aether.toxin", 1, 1, 1, 10, 10),
        COCKATRICE_VENOM("effect.aether.cockatrice_venom", 2, 5, 60, 60, 10),
        STUN("effect.aether.stun", 3, 5, 1, 5, 10),
        BLEED("effect.aether.bleed", 4, 1, 10, 0, 10),
        FRACTURE("effect.aether.fracture", 5, 1, 1, 300, 10),
        FUNGAL_ROT("effect.aether.fungal_rot", 6, 1, 10, 20, 10),
        FREEZE("effect.aether.freeze", 7, 1, 5, 20, 10),
        WEBBING("effect.aether.webbing", 8, 1, 10, 20, 10),
        SATURATION_BOOST("effect.aether.saturation_boost", 9, 1, 1, 300, 10),
        GUARD_BREAK("effect.aether.guard_break", 10, 20, 1, 5, 10);

        public final int numericValue;
        public final String name;
        public final int reductionRate;
        public final int timeTillReduction;
        public final int activeEffectTime;
        public final int buildupSpeed;

        private effectTypes(String name, int numericValue, int reductionRate, int timeTillReduction, int activeEffectTime, int buildupSpeed) {
            this.name = name;
            this.numericValue = numericValue;
            this.reductionRate = reductionRate;
            this.timeTillReduction = timeTillReduction;
            this.activeEffectTime = activeEffectTime;
            this.buildupSpeed = buildupSpeed;
        }

        public static effectTypes getEffectFromNumericValue(int numericValue) {
            switch (numericValue) {
                case 0: {
                    return AMBROSIUM_POISONING;
                }
                case 1: {
                    return TOXIN;
                }
                case 2: {
                    return COCKATRICE_VENOM;
                }
                case 3: {
                    return STUN;
                }
                case 4: {
                    return BLEED;
                }
                case 5: {
                    return FRACTURE;
                }
                case 6: {
                    return FUNGAL_ROT;
                }
                case 7: {
                    return FREEZE;
                }
                case 8: {
                    return WEBBING;
                }
                case 9: {
                    return SATURATION_BOOST;
                }
                case 10: {
                    return GUARD_BREAK;
                }
            }
            return null;
        }
    }
}

