/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.aether.api.entity;

import com.gildedgames.aether.api.entity.Character;
import com.gildedgames.aether.api.shop.IShopInstance;
import com.gildedgames.aether.api.shop.IShopInstanceGroup;
import com.gildedgames.aether.api.world.IWorldObjectHoverable;
import com.gildedgames.orbis.lib.util.io.NBTFunnel;
import com.gildedgames.orbis.lib.util.mc.NBT;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityCharacter
extends EntityCreature
implements Character,
IWorldObjectHoverable {
    private static final DataParameter<NBTTagCompound> SHOP_INSTANCE_GROUP_TAG = new DataParameter(16, DataSerializers.field_192734_n);
    private IShopInstanceGroup shopInstanceGroup;
    private boolean startupSynced;
    private NBTTagCompound prevShopInstanceTag;

    public EntityCharacter(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.shopInstanceGroup = this.createShopInstanceGroup();
    }

    public boolean func_180431_b(DamageSource source) {
        return !source.func_76357_e();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    @Nullable
    public abstract IShopInstanceGroup createShopInstanceGroup();

    public NBTTagCompound getShopInstanceGroupTag() {
        return (NBTTagCompound)this.field_70180_af.func_187225_a(SHOP_INSTANCE_GROUP_TAG);
    }

    public void setShopInstanceGroupTag(NBTTagCompound tag) {
        this.field_70180_af.func_187227_b(SHOP_INSTANCE_GROUP_TAG, (Object)tag);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHOP_INSTANCE_GROUP_TAG, (Object)new NBTTagCompound());
    }

    @Override
    public IShopInstanceGroup getShopInstanceGroup() {
        return this.shopInstanceGroup;
    }

    private void onClientUpdate() {
        if (this.getShopInstanceGroup() != null && this.prevShopInstanceTag != this.getShopInstanceGroupTag()) {
            this.prevShopInstanceTag = this.getShopInstanceGroupTag();
            this.getShopInstanceGroup().read(this.getShopInstanceGroupTag());
        }
    }

    private void onServerUpdate() {
        if (this.getShopInstanceGroup() != null) {
            for (IShopInstance shopInstance : this.getShopInstanceGroup().getShopInstances()) {
                if (shopInstance == null) continue;
                shopInstance.tick();
                if (!shopInstance.isDirty() && this.startupSynced) continue;
                this.startupSynced = true;
                NBTTagCompound tag = new NBTTagCompound();
                this.getShopInstanceGroup().write(tag);
                this.setShopInstanceGroupTag(tag);
                this.getShopInstanceGroup().getShopInstances().forEach(IShopInstance::markClean);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.onServerUpdate();
        } else {
            this.onClientUpdate();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTFunnel funnel = new NBTFunnel(compound);
        funnel.set("shopInstanceGroup", (NBT)this.shopInstanceGroup);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTFunnel funnel = new NBTFunnel(compound);
        this.shopInstanceGroup = (IShopInstanceGroup)funnel.getWithDefault("shopInstanceGroup", () -> this.shopInstanceGroup);
    }

    @Override
    public ITextComponent getHoverText(World world, RayTraceResult result) {
        return new TextComponentTranslation("gui.aether.hover.npc", new Object[]{this.func_70005_c_()});
    }

    @SubscribeEvent
    public static void onEntityMounted(EntityMountEvent event) {
        if (EntityCharacter.class.isAssignableFrom(event.getEntityMounting().getClass())) {
            event.setCanceled(true);
        }
    }
}

