/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.fluid;

import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.fluid.GridFluid;
import cofh.thermaldynamics.duct.fluid.GridFluidSuper;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class DuctUnitFluidSuper
extends DuctUnitFluid {
    public DuctUnitFluidSuper(TileGrid parent, Duct duct) {
        super(parent, duct);
    }

    @Override
    public GridFluidSuper createGrid() {
        return new GridFluidSuper(this.world());
    }

    @Override
    public boolean canConnectToOtherDuct(DuctUnit<DuctUnitFluid, GridFluid, DuctUnitFluid.Cache> adjDuct, byte side, byte oppositeSide) {
        Duct ductType = adjDuct.getDuctType();
        return (ductType == TDDucts.fluidSuper || ductType == TDDucts.fluidSuperOpaque) && super.canConnectToOtherDuct(adjDuct, side, oppositeSide);
    }

    @Override
    public IFluidHandler getFluidCapability(final EnumFacing from) {
        final GridFluidSuper gridFluidSuper = (GridFluidSuper)this.grid;
        if (gridFluidSuper == null) {
            return EmptyFluidHandler.INSTANCE;
        }
        return (IFluidHandler)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

            public IFluidTankProperties[] getTankProperties() {
                FluidStack info = DuctUnitFluidSuper.this.grid != null ? ((GridFluid)((DuctUnitFluidSuper)DuctUnitFluidSuper.this).grid).myTank.getInfo().fluid : null;
                int capacity = DuctUnitFluidSuper.this.grid != null ? ((GridFluid)((DuctUnitFluidSuper)DuctUnitFluidSuper.this).grid).myTank.getInfo().capacity : 0;
                return new IFluidTankProperties[]{new FluidTankProperties(info, capacity, DuctUnitFluidSuper.this.isOpen(from), DuctUnitFluidSuper.this.isOpen(from))};
            }

            public int fill(FluidStack resource, boolean doFill) {
                if (resource != null && DuctUnitFluidSuper.this.isOpen(from) && DuctUnitFluidSuper.this.matchesFilter(from, resource)) {
                    return gridFluidSuper.sendFluid(resource, !doFill);
                }
                return 0;
            }

            @Nullable
            public FluidStack drain(FluidStack resource, boolean doDrain) {
                return null;
            }

            @Nullable
            public FluidStack drain(int maxDrain, boolean doDrain) {
                if (DuctUnitFluidSuper.this.isOpen(from)) {
                    return ((GridFluid)((DuctUnitFluidSuper)DuctUnitFluidSuper.this).grid).myTank.drain(maxDrain, doDrain);
                }
                return null;
            }
        });
    }
}

