/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun.skin;

import com.craftingdead.core.world.item.gun.skin.Skin;
import com.craftingdead.core.world.item.gun.skin.Skins;
import java.util.OptionalInt;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

public interface Paint {
    public static final Capability<Paint> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Paint>(){});

    public Holder<Skin> getSkin();

    default public OptionalInt getColor() {
        return OptionalInt.empty();
    }

    public static Paint of(ResourceKey<Skin> skin) {
        return () -> Skins.REGISTRY.m_203538_(skin);
    }

    public static Paint of(ResourceKey<Skin> skin, int color) {
        return Paint.of(skin, OptionalInt.of(color));
    }

    public static Paint of(final ResourceKey<Skin> skin, final OptionalInt color) {
        return new Paint(){

            @Override
            public OptionalInt getColor() {
                return color;
            }

            @Override
            public Holder<Skin> getSkin() {
                return Skins.REGISTRY.m_203538_(skin);
            }
        };
    }

    public static boolean isValid(ItemStack gunStack, ItemStack itemStack) {
        return Paint.isValid(gunStack.m_41720_().getRegistryName(), itemStack);
    }

    public static boolean isValid(ResourceLocation gunName, ItemStack itemStack) {
        return itemStack.getCapability(CAPABILITY).map(Paint::getSkin).map(Holder::m_203334_).filter(skin -> skin.getAcceptedGuns().contains(gunName)).isPresent();
    }
}

