/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.combatslot.CombatSlot;
import com.craftingdead.core.world.item.gun.AbstractGun;
import com.craftingdead.core.world.item.gun.FireMode;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.GunType;
import com.craftingdead.core.world.item.gun.TypedGunClient;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.craftingdead.core.world.item.gun.attachment.AttachmentLike;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TypedGun<T extends GunType>
extends AbstractGun {
    private final T type;

    public static <T extends GunType> TypedGun<T> create(Function<TypedGun<T>, ? extends TypedGunClient<? super TypedGun<T>>> clientFactory, ItemStack itemStack, T type) {
        TypedGun<T> gun = new TypedGun<T>(clientFactory, itemStack, type);
        gun.initialize();
        return gun;
    }

    protected <SELF extends TypedGun<T>> TypedGun(Function<SELF, ? extends TypedGunClient<? super SELF>> clientFactory, ItemStack itemStack, T type) {
        super(clientFactory, itemStack, ((GunType)((Object)type)).getFireModes());
        this.type = type;
    }

    public T getType() {
        return this.type;
    }

    @Override
    public boolean isAcceptedAttachment(ItemStack itemStack) {
        return (Boolean)CraftingDead.serverConfig.scopeAttachmentsAllowed.get() != false && itemStack.m_41720_() instanceof AttachmentLike && ((GunType)((Object)this.type)).getAcceptedAttachments().contains((Object)((AttachmentLike)itemStack.m_41720_()).asAttachment());
    }

    @Override
    public Gun.SecondaryActionTrigger getSecondaryActionTrigger() {
        return ((GunType)((Object)this.type)).getSecondaryActionTrigger();
    }

    @Override
    public Optional<SoundEvent> getReloadSound() {
        return ((GunType)((Object)this.type)).getReloadSound();
    }

    @Override
    public int getReloadDurationTicks() {
        return ((GunType)((Object)this.type)).getReloadDurationTicks();
    }

    @Override
    public Set<? extends Item> getAcceptedMagazines() {
        return ((GunType)((Object)this.type)).getAcceptedMagazines();
    }

    @Override
    public ItemStack getDefaultMagazineStack() {
        return ((GunType)((Object)this.type)).getDefaultMagazine().m_7968_();
    }

    @Override
    public CombatSlot getCombatSlot() {
        return ((GunType)((Object)this.type)).getCombatSlot();
    }

    @Override
    protected boolean canShoot(LivingExtension<?, ?> living) {
        return super.canShoot(living) && ((GunType)((Object)this.type)).getTriggerPredicate().test(this);
    }

    @Override
    public float getAccuracy(LivingExtension<?, ?> living, Random random) {
        float accuracy = ((GunType)((Object)this.type)).getAccuracyPct() * this.getAttachmentMultiplier(Attachment.MultiplierType.ACCURACY);
        return Math.min(living.getModifiedAccuracy(accuracy, random), 1.0f);
    }

    @Override
    protected Set<FireMode> getFireModes() {
        return ((GunType)((Object)this.type)).getFireModes();
    }

    @Override
    protected AmmoProvider createAmmoProvider() {
        return ((GunType)((Object)this.type)).createAmmoProvider();
    }

    @Override
    protected double getRange() {
        return ((GunType)((Object)this.type)).getRange();
    }

    @Override
    protected long getFireDelayMs() {
        return ((GunType)((Object)this.type)).getFireDelayMs();
    }

    @Override
    protected int getRoundsPerShot() {
        return ((GunType)((Object)this.type)).getRoundsPerShot();
    }

    @Override
    protected float getDamage() {
        return ((GunType)((Object)this.type)).getDamage();
    }
}

