/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.event.GunEvent;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.SynchedData;
import com.craftingdead.core.network.message.play.HitMessage;
import com.craftingdead.core.network.message.play.SecondaryActionMessage;
import com.craftingdead.core.network.message.play.SetFireModeMessage;
import com.craftingdead.core.network.message.play.TriggerPressedMessage;
import com.craftingdead.core.sounds.ModSoundEvents;
import com.craftingdead.core.util.RayTraceUtil;
import com.craftingdead.core.world.damagesource.ModDamageSource;
import com.craftingdead.core.world.entity.extension.EntitySnapshot;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.inventory.ModEquipmentSlot;
import com.craftingdead.core.world.item.enchantment.ModEnchantments;
import com.craftingdead.core.world.item.gun.AbstractGunClient;
import com.craftingdead.core.world.item.gun.FireMode;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.PendingHit;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProviderType;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProviderTypes;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.craftingdead.core.world.item.gun.attachment.Attachments;
import com.craftingdead.core.world.item.gun.magazine.Magazine;
import com.craftingdead.core.world.item.gun.skin.Paint;
import com.craftingdead.core.world.item.gun.skin.Skin;
import com.craftingdead.core.world.item.hat.Hat;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.slf4j.Logger;

public abstract class AbstractGun
implements Gun,
INBTSerializable<CompoundTag> {
    private static final Logger logger = LogUtils.getLogger();
    public static final byte HIT_VALIDATION_DELAY_TICKS = 3;
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(3, new ThreadFactoryBuilder().setNameFormat("gun-pool-%s").setDaemon(true).setPriority(10).build());
    private static final EntityDataAccessor<ItemStack> PAINT_STACK = new EntityDataAccessor(1, EntityDataSerializers.f_135033_);
    private final SynchedData dataManager = new SynchedData();
    protected final ItemStack itemStack;
    private boolean wasTriggerPressed;
    private volatile int triggerPressedTicks;
    private volatile FireMode fireMode;
    private final AtomicInteger shotCount = new AtomicInteger();
    private Set<Attachment> attachments;
    private boolean attachmentsDirty;
    private final Iterator<FireMode> fireModeInfiniteIterator;
    private volatile boolean performingSecondaryAction;
    private final Lazy<AbstractGunClient<?>> client;
    private volatile long lastTickMs;
    private volatile AmmoProvider ammoProvider;
    private boolean ammoProviderChanged;
    @Nullable
    private volatile Future<?> gunFuture;
    protected volatile long lastShotMs;
    private boolean initialized;
    @Nullable
    private Holder<Skin> skin;
    private boolean skinDirty;

    public <SELF extends AbstractGun> AbstractGun(Function<SELF, ? extends AbstractGunClient<? super SELF>> clientFactory, ItemStack itemStack, Set<FireMode> fireModes) {
        this.itemStack = itemStack;
        this.fireModeInfiniteIterator = Iterables.cycle((Iterable)Iterables.filter(fireModes, mode -> mode != FireMode.BURST || (Boolean)CraftingDead.serverConfig.burstfireEnabled.get() != false)).iterator();
        this.fireMode = this.fireModeInfiniteIterator.next();
        this.client = FMLEnvironment.dist.isClient() ? Lazy.concurrentOf(() -> (AbstractGunClient)clientFactory.apply(this)) : Lazy.of(() -> {
            throw new IllegalStateException("Cannot access gun client on dedicated server");
        });
    }

    protected void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.initialized = true;
        GunEvent.Initialize event = new GunEvent.Initialize(this, this.itemStack, this.createAmmoProvider());
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.setAmmoProvider(event.getAmmoProvider());
        this.attachments = Set.copyOf(event.getAttachments());
        this.dataManager.register(PAINT_STACK, ItemStack.f_41583_);
    }

    protected abstract Set<FireMode> getFireModes();

    protected abstract AmmoProvider createAmmoProvider();

    @Override
    public void tick(LivingExtension<?, ?> living) {
        this.lastTickMs = Util.m_137550_();
        if (!living.getLevel().m_5776_() && !this.isTriggerPressed() && this.wasTriggerPressed) {
            this.triggerPressedTicks = living.getEntity().m_20194_().m_129921_();
        }
        this.wasTriggerPressed = this.isTriggerPressed();
        if (this.isPerformingSecondaryAction() && living.getEntity().m_20142_()) {
            this.setPerformingSecondaryAction(living, false, true);
        }
        if (living.getLevel().m_5776_()) {
            ((AbstractGunClient)this.getClient()).handleTick(living);
        }
    }

    @Override
    public void reset(LivingExtension<?, ?> living) {
        this.setTriggerPressed(living, false, false);
        if (this.isPerformingSecondaryAction()) {
            this.setPerformingSecondaryAction(living, false, false);
        }
    }

    @Override
    public void setTriggerPressed(LivingExtension<?, ?> living, boolean triggerPressed, boolean sendUpdate) {
        if (triggerPressed == this.isTriggerPressed() || triggerPressed && (!this.canShoot(living) || MinecraftForge.EVENT_BUS.post((Event)new GunEvent.TriggerPressed(this, this.itemStack, living)))) {
            return;
        }
        if (triggerPressed) {
            this.gunFuture = executorService.scheduleAtFixedRate(() -> this.shoot(living), 0L, this.getFireDelayMs(), TimeUnit.MILLISECONDS);
        } else {
            this.stopShooting();
        }
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = living.getLevel().m_5776_() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY.with(living::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new TriggerPressedMessage(living.getEntity().m_142049_(), triggerPressed));
        }
    }

    @Override
    public boolean isTriggerPressed() {
        return this.gunFuture != null && !this.gunFuture.isDone();
    }

    private void stopShooting() {
        this.shotCount.set(0);
        if (this.gunFuture != null) {
            this.gunFuture.cancel(false);
        }
    }

    @Override
    public void validatePendingHit(PlayerExtension<ServerPlayer> player, LivingExtension<?, ?> hitLiving, PendingHit pendingHit) {
        EntitySnapshot hitSnapshot;
        EntitySnapshot playerSnapshot;
        byte tickOffset = pendingHit.tickOffset();
        if (tickOffset > 3) {
            logger.warn("Bad living hit packet received, tick offset is too big!");
            return;
        }
        int latencyTicks = ((ServerPlayer)player.getEntity()).f_8943_ / 1000 * 20 + tickOffset;
        int tick = ((ServerPlayer)player.getEntity()).m_20194_().m_129921_();
        if (tick - latencyTicks > this.triggerPressedTicks && !this.isTriggerPressed()) {
            return;
        }
        try {
            playerSnapshot = player.getSnapshot(tick - latencyTicks).combineUntrustedSnapshot(pendingHit.playerSnapshot());
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        try {
            hitSnapshot = hitLiving.getSnapshot(tick - latencyTicks).combineUntrustedSnapshot(pendingHit.hitSnapshot());
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        if (hitLiving.getEntity().m_6084_()) {
            Random random = player.getRandom();
            random.setSeed(pendingHit.randomSeed());
            AbstractGun.rayTrace(player.getLevel(), playerSnapshot, hitSnapshot, this.getRange(), this.getAccuracy(player, random), pendingHit.shotCount(), random).ifPresent(hitPos -> this.hitEntity((LivingExtension<?, ?>)player, (Entity)hitLiving.getEntity(), (Vec3)hitPos, false));
        }
    }

    protected abstract double getRange();

    protected abstract long getFireDelayMs();

    private void shoot(LivingExtension<?, ?> living) {
        int maxShots;
        long time = Util.m_137550_();
        if (!this.isTriggerPressed() || time - this.lastTickMs >= 500L || !this.canShoot(living)) {
            this.stopShooting();
            return;
        }
        if (time - this.lastShotMs + 10L < this.getFireDelayMs()) {
            return;
        }
        this.lastShotMs = time;
        LogicalSide side = living.getLevel().m_5776_() ? LogicalSide.CLIENT : LogicalSide.SERVER;
        BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(side);
        if (this.ammoProvider.getMagazine().map(Magazine::getSize).orElse(0) <= 0) {
            if (side.isServer()) {
                executor.execute(() -> {
                    living.getEntity().m_5496_((SoundEvent)ModSoundEvents.DRY_FIRE.get(), 1.0f, 1.0f);
                    this.ammoProvider.reload(living);
                });
            }
            this.stopShooting();
            return;
        }
        int shotCount = this.shotCount.getAndIncrement();
        if (shotCount >= (maxShots = this.fireMode.getMaxShots().orElse(Integer.MAX_VALUE).intValue())) {
            this.stopShooting();
            return;
        }
        executor.execute(() -> this.processShot(living));
        if (side.isClient()) {
            ((AbstractGunClient)this.getClient()).handleShoot(living);
        }
        Thread.yield();
    }

    protected boolean canShoot(LivingExtension<?, ?> living) {
        PlayerExtension player;
        return !living.getActionObserver().isPresent() && !living.getEntity().m_20142_() && !living.getEntity().m_5833_() && (!(living instanceof PlayerExtension) || !(player = (PlayerExtension)living).isHandcuffed());
    }

    protected abstract int getRoundsPerShot();

    protected void processShot(LivingExtension<?, ?> living) {
        int unbreakingLevel;
        Object entity = living.getEntity();
        Level level = living.getLevel();
        Random random = entity.m_21187_();
        MinecraftForge.EVENT_BUS.post((Event)new GunEvent.Shoot(this, this.itemStack, living));
        if (!(level.m_5776_() || living.getEntity() instanceof Player && ((Player)living.getEntity()).m_7500_() || DigDurabilityEnchantment.m_44655_((ItemStack)this.itemStack, (int)(unbreakingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)this.itemStack)), (Random)level.m_5822_()))) {
            this.ammoProvider.getExpectedMagazine().decrementSize();
        }
        boolean hitEntity = false;
        HashSet<BlockState> blocksHit = new HashSet<BlockState>();
        block4: for (int i = 0; i < this.getRoundsPerShot(); ++i) {
            long randomSeed = level.m_46467_() + (long)i;
            random.setSeed(randomSeed);
            float partialTick = level.m_5776_() ? ((AbstractGunClient)this.getClient()).getPartialTick() : 1.0f;
            HitResult hitResult = AbstractGun.rayTrace(entity, this.getRange(), partialTick, this.getAccuracy(living, random), this.getShotCount(), random).orElse(null);
            if (hitResult == null) continue;
            switch (hitResult.m_6662_()) {
                case BLOCK: {
                    BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                    BlockState blockState = level.m_8055_(blockHitResult.m_82425_());
                    this.hitBlock(living, blockHitResult, blockState, level.m_5776_() && (i == 0 || !blocksHit.contains(blockState)));
                    blocksHit.add(blockState);
                    continue block4;
                }
                case ENTITY: {
                    EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                    if (!entityHitResult.m_82443_().m_6084_() || entityHitResult.m_82443_() instanceof LivingEntity && entity instanceof ServerPlayer) continue block4;
                    if (level.m_5776_()) {
                        ((AbstractGunClient)this.getClient()).handleHitEntityPre(living, entityHitResult.m_82443_(), entityHitResult.m_82450_(), randomSeed);
                    }
                    this.hitEntity(living, entityHitResult.m_82443_(), entityHitResult.m_82450_(), !hitEntity && level.m_5776_());
                    hitEntity = true;
                    continue block4;
                }
            }
        }
    }

    protected abstract float getDamage();

    private void hitEntity(LivingExtension<?, ?> living, Entity hitEntity, Vec3 hitPos, boolean playSound) {
        GunEvent.HitEntity event;
        float armorPenetration;
        Object entity = living.getEntity();
        float damage = this.getDamage();
        if (((Boolean)CraftingDead.serverConfig.damageDropOffEnable.get()).booleanValue()) {
            float distance = hitEntity.m_20270_(living.getEntity());
            float minDamage = Math.min(damage, ((Double)CraftingDead.serverConfig.damageDropOffMinimumDamage.get()).floatValue());
            damage = Math.max(minDamage, damage - (float)((Double)CraftingDead.serverConfig.damageDropOffLoss.get() / 100.0 * this.getRange() * (double)distance));
        }
        if ((armorPenetration = Math.min((1.0f + (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.ARMOR_PENETRATION.get()), (ItemStack)this.itemStack) / 255.0f) * this.ammoProvider.getExpectedMagazine().getArmorPenetration(), 1.0f)) > 0.0f && hitEntity instanceof LivingEntity) {
            LivingEntity livingEntityHit = (LivingEntity)hitEntity;
            float reducedDamage = damage - CombatRules.m_19272_((float)damage, (float)livingEntityHit.m_21230_(), (float)((float)livingEntityHit.m_21051_(Attributes.f_22285_).m_22135_()));
            damage += reducedDamage * armorPenetration;
        }
        boolean headshot = false;
        if (hitEntity instanceof LivingEntity) {
            LivingExtension<LivingEntity, ?> hitLiving = LivingExtension.getOrThrow((LivingEntity)hitEntity);
            double chinHeight = hitEntity.m_20186_() + (double)hitEntity.m_20192_() - (double)0.2f;
            boolean bl = headshot = (Boolean)CraftingDead.serverConfig.headshotEnabled.get() != false && (hitEntity instanceof Player || hitEntity instanceof Zombie || hitEntity instanceof Skeleton || hitEntity instanceof Creeper || hitEntity instanceof EnderMan || hitEntity instanceof Witch || hitEntity instanceof Villager || hitEntity instanceof Vindicator || hitEntity instanceof WanderingTrader) && hitPos.f_82480_ >= chinHeight;
            if (headshot) {
                float damagePercentage = 1.0f - hitLiving.getItemHandler().getStackInSlot(ModEquipmentSlot.HAT.getIndex()).getCapability(Hat.CAPABILITY).map(Hat::getHeadshotReductionPercentage).orElse(Float.valueOf(0.0f)).floatValue();
                damage = damagePercentage < 1.0f ? (damage *= damagePercentage) : (float)((double)damage * (Double)CraftingDead.serverConfig.headshotBonusDamage.get());
            }
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new GunEvent.HitEntity(this, this.itemStack, living, hitEntity, damage, hitPos, headshot)))) {
            return;
        }
        damage = event.getDamage();
        headshot = event.isHeadshot();
        if (living.getLevel().m_5776_()) {
            ((AbstractGunClient)this.getClient()).handleHitEntityPost(living, hitEntity, hitPos, playSound, headshot);
            return;
        }
        hitEntity.f_19802_ = 0;
        ModDamageSource.causeDamageWithoutKnockback(hitEntity, ModDamageSource.causeGunDamage(entity, this.itemStack, headshot), damage);
        AbstractGun.checkCreateExplosion(this.itemStack, entity, hitPos);
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)this.itemStack) > 0) {
            hitEntity.m_20254_(100);
        }
        if (hitEntity instanceof LivingEntity) {
            LivingEntity hitLivingEntity = (LivingEntity)hitEntity;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)new HitMessage(hitPos, hitLivingEntity.m_21224_()));
            }
        }
    }

    private void hitBlock(LivingExtension<?, ?> living, BlockHitResult result, BlockState blockState, boolean playSound) {
        Object entity = living.getEntity();
        Block block = blockState.m_60734_();
        Level level = entity.m_183503_();
        BlockPos blockPos = result.m_82425_();
        GunEvent.HitBlock event = new GunEvent.HitBlock(this, this.itemStack, result, blockState, living, level);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        if (level.m_5776_()) {
            ((AbstractGunClient)this.getClient()).handleHitBlock(living, result, blockState, playSound);
            return;
        }
        if (block instanceof BellBlock) {
            Player player;
            BellBlock bell = (BellBlock)block;
            bell.m_49701_(level, blockState, result, entity instanceof Player ? (player = (Player)entity) : null, playSound);
        }
        if (block instanceof TntBlock) {
            TntBlock tnt = (TntBlock)block;
            tnt.onCaughtFire(blockState, level, blockPos, null, entity);
            level.m_7471_(blockPos, false);
        }
        AbstractGun.checkCreateExplosion(this.itemStack, entity, result.m_82450_());
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)this.itemStack) > 0) {
            if (CampfireBlock.m_51321_((BlockState)blockState)) {
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
            } else {
                BlockPos directedPos = blockPos.m_142300_(result.m_82434_());
                if (BaseFireBlock.m_49255_((Level)level, (BlockPos)directedPos, (Direction)entity.m_6350_())) {
                    level.m_46597_(directedPos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)directedPos));
                }
            }
        }
    }

    @Override
    public Set<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public void setAttachments(Set<Attachment> attachments) {
        this.attachments = Set.copyOf(attachments);
    }

    @Override
    public ItemStack getPaintStack() {
        return this.dataManager.get(PAINT_STACK);
    }

    @Override
    public void setPaintStack(ItemStack paintStack) {
        this.dataManager.set(PAINT_STACK, paintStack);
        this.setSkin((Holder<Skin>)((Holder)paintStack.getCapability(Paint.CAPABILITY).map(Paint::getSkin).orElse(null)));
    }

    @Override
    public Skin getSkin() {
        return this.skin == null ? null : (Skin)this.skin.m_203334_();
    }

    @Override
    public void setSkin(Holder<Skin> skin) {
        this.skin = skin;
        this.skinDirty = true;
    }

    @Override
    public void toggleFireMode(LivingExtension<?, ?> living, boolean sendUpdate) {
        if (this.fireModeInfiniteIterator.hasNext()) {
            this.setFireMode(living, this.fireModeInfiniteIterator.next(), sendUpdate);
        }
    }

    @Override
    public void setFireMode(LivingExtension<?, ?> living, FireMode fireMode, boolean sendUpdate) {
        this.fireMode = fireMode;
        living.getEntity().m_5496_((SoundEvent)ModSoundEvents.TOGGLE_FIRE_MODE.get(), 1.0f, 1.0f);
        Object obj = living.getEntity();
        if (obj instanceof Player) {
            Player player = (Player)obj;
            player.m_5661_((Component)new TranslatableComponent("message.switch_fire_mode", new Object[]{new TranslatableComponent(this.fireMode.getTranslationKey())}), true);
        }
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = living.getLevel().m_5776_() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY.with(living::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new SetFireModeMessage(living.getEntity().m_142049_(), this.fireMode));
        }
    }

    @Override
    public boolean isPerformingSecondaryAction() {
        return this.performingSecondaryAction;
    }

    protected boolean canPerformSecondaryAction(LivingExtension<?, ?> living) {
        PlayerExtension player;
        return !living.getEntity().m_20142_() && (!(living instanceof PlayerExtension) || !(player = (PlayerExtension)living).isHandcuffed());
    }

    @Override
    public void setPerformingSecondaryAction(LivingExtension<?, ?> living, boolean performingAction, boolean sendUpdate) {
        if (performingAction == this.performingSecondaryAction || performingAction && !this.canPerformSecondaryAction(living)) {
            return;
        }
        this.performingSecondaryAction = performingAction;
        if (living.getLevel().m_5776_()) {
            ((AbstractGunClient)this.getClient()).handleToggleSecondaryAction(living);
        }
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = living.getLevel().m_5776_() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY.with(living::getEntity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new SecondaryActionMessage(living.getEntity().m_142049_(), this.isPerformingSecondaryAction()));
        }
    }

    protected int getShotCount() {
        return this.shotCount.get();
    }

    @Override
    public FireMode getFireMode() {
        return this.fireMode;
    }

    @Override
    public AbstractGunClient<?> getClient() {
        return (AbstractGunClient)this.client.get();
    }

    @Override
    public AmmoProvider getAmmoProvider() {
        return this.ammoProvider;
    }

    @Override
    public void setAmmoProvider(AmmoProvider ammoProvider) {
        this.ammoProvider = ammoProvider;
        this.ammoProviderChanged = true;
    }

    @Override
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("ammoProviderType", this.ammoProvider.getType().getRegistryName().toString());
        nbt.m_128365_("ammoProvider", this.ammoProvider.serializeNBT());
        ListTag attachmentsNbt = this.attachments.stream().map(ForgeRegistryEntry::getRegistryName).map(ResourceLocation::toString).map(StringTag::m_129297_).collect(ListTag::new, AbstractList::add, List::addAll);
        nbt.m_128365_("attachments", (Tag)attachmentsNbt);
        nbt.m_128365_("paintStack", (Tag)this.getPaintStack().serializeNBT());
        if (this.skin != null) {
            nbt.m_128365_("skin", (Tag)Skin.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.skin).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0)));
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_("ammoProviderType", 8)) {
            this.setAmmoProvider(((AmmoProviderType)AmmoProviderTypes.registry.get().getValue(new ResourceLocation(nbt.m_128461_("ammoProviderType")))).create());
            this.ammoProvider.deserializeNBT((Tag)nbt.m_128469_("ammoProvider"));
            this.ammoProviderChanged = true;
        }
        this.setAttachments(nbt.m_128437_("attachments", 8).stream().map(Tag::m_7916_).map(ResourceLocation::new).map(arg_0 -> Attachments.registry.get().getValue(arg_0)).collect(Collectors.toSet()));
        this.setPaintStack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("paintStack")));
        this.skin = Skin.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_("skin")).result().orElse(null);
    }

    @Override
    public void encode(FriendlyByteBuf out, boolean writeAll) {
        SynchedData.pack(writeAll ? this.dataManager.getAll() : this.dataManager.packDirty(), out);
        if (writeAll || this.attachmentsDirty) {
            out.m_130130_(this.attachments.size());
            this.attachments.forEach(arg_0 -> ((FriendlyByteBuf)out).writeRegistryId(arg_0));
        } else {
            out.m_130130_(-1);
        }
        this.attachmentsDirty = false;
        if (this.ammoProviderChanged || writeAll) {
            out.writeBoolean(true);
            out.writeRegistryId((IForgeRegistryEntry)this.ammoProvider.getType());
        } else {
            out.writeBoolean(false);
        }
        this.ammoProvider.encode(out, this.ammoProviderChanged || writeAll);
        this.ammoProviderChanged = false;
        if (this.skinDirty || writeAll) {
            this.skinDirty = false;
            out.writeBoolean(true);
            if (this.skin == null) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
                out.m_130059_(Skin.CODEC, this.skin);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void decode(FriendlyByteBuf in) {
        this.dataManager.assignValues(SynchedData.unpack(in));
        int size = in.m_130242_();
        if (size > -1) {
            ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                builder.add((Object)((Attachment)in.readRegistryIdSafe(Attachment.class)));
            }
            this.attachments = builder.build();
        }
        if (in.readBoolean()) {
            this.ammoProvider = ((AmmoProviderType)in.readRegistryIdSafe(AmmoProviderType.class)).create();
        }
        this.ammoProvider.decode(in);
        if (in.readBoolean()) {
            this.skin = in.readBoolean() ? null : (Holder)in.m_130057_(Skin.CODEC);
        }
    }

    @Override
    public boolean requiresSync() {
        return this.attachmentsDirty || this.dataManager.isDirty() || this.ammoProvider.requiresSync() || this.skinDirty;
    }

    private static void checkCreateExplosion(ItemStack magazineStack, Entity entity, Vec3 position) {
        float explosionSize = (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)magazineStack) / (float)Enchantments.f_44988_.m_6586_();
        if (explosionSize > 0.0f) {
            entity.m_183503_().m_46511_(entity, position.m_7096_(), position.m_7098_(), position.m_7094_(), explosionSize, Explosion.BlockInteraction.NONE);
        }
    }

    public static Optional<? extends HitResult> rayTrace(Entity fromEntity, double distance, float partialTick, float accuracy, int shotCount, Random random) {
        return RayTraceUtil.rayTrace(fromEntity, distance, partialTick, AbstractGun.getAccuracyOffset(accuracy, shotCount, random), AbstractGun.getAccuracyOffset(accuracy, shotCount, random));
    }

    public static Optional<Vec3> rayTrace(Level level, EntitySnapshot fromSnapshot, EntitySnapshot targetSnapshot, double distance, float accuracy, int shotCount, Random random) {
        if (!fromSnapshot.complete() || !targetSnapshot.complete()) {
            return Optional.empty();
        }
        Vec3 startPos = fromSnapshot.position().m_82520_(0.0, (double)fromSnapshot.eyeHeight(), 0.0);
        Vec3 look = RayTraceUtil.calculateViewVector(fromSnapshot.rotation().f_82470_ + AbstractGun.getAccuracyOffset(accuracy, shotCount, random), fromSnapshot.rotation().f_82471_ + AbstractGun.getAccuracyOffset(accuracy, shotCount, random));
        Optional<BlockHitResult> blockRayTraceResult = RayTraceUtil.rayTraceBlocks(startPos, distance, look, level);
        Vec3 scaledLook = look.m_82490_(distance);
        Vec3 endPos = blockRayTraceResult.map(HitResult::m_82450_).orElse(startPos.m_82549_(scaledLook));
        Optional potentialHit = targetSnapshot.boundingBox().m_82371_(startPos, endPos);
        if (targetSnapshot.boundingBox().m_82390_(startPos)) {
            return Optional.of(potentialHit.orElse(startPos));
        }
        return potentialHit;
    }

    public static float getAccuracyOffset(float accuracy, int shotCount, Random random) {
        return (1.0f - accuracy * accuracy) * ((float)Math.min(20, shotCount + 1) / 2.0f) * ((1.0f - accuracy) * (float)(random.nextInt(9) + 1)) * (random.nextInt(5) % 2 == 0 ? -1.0f : 1.0f);
    }
}

