/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.combatslot;

import com.craftingdead.core.world.item.combatslot.CombatSlotProvider;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CombatSlot implements CombatSlotProvider,
StringRepresentable
{
    PRIMARY("primary", true),
    SECONDARY("secondary", true),
    MELEE("melee", false),
    GRENADE("grenade", false){

        @Override
        protected int getAvailableSlot(Inventory playerInventory, boolean ignoreEmpty) {
            int index = super.getAvailableSlot(playerInventory, false);
            return index == -1 ? 3 : index;
        }
    }
    ,
    EXTRA("extra", false);

    public static final Codec<CombatSlot> CODEC;
    private static final Map<String, CombatSlot> BY_NAME;
    private final String name;
    private final boolean dropExistingItems;

    private CombatSlot(String name, boolean dropExistingItems) {
        this.name = name;
        this.dropExistingItems = dropExistingItems;
    }

    public String m_7912_() {
        return this.name;
    }

    @Override
    public CombatSlot getCombatSlot() {
        return this;
    }

    protected int getAvailableSlot(Inventory playerInventory, boolean ignoreEmpty) {
        for (int i = 0; i < 6; ++i) {
            if (!ignoreEmpty && !playerInventory.m_8020_(i).m_41619_() || CombatSlot.getSlotType(i) != this) continue;
            return i;
        }
        return -1;
    }

    public boolean addToInventory(ItemStack itemStack, Inventory playerInventory, boolean ignoreEmpty) {
        int index = this.getAvailableSlot(playerInventory, ignoreEmpty);
        if (index == -1) {
            return false;
        }
        if (this.dropExistingItems && !playerInventory.m_8020_(index).m_41619_()) {
            ItemStack oldStack = playerInventory.m_8016_(index);
            playerInventory.f_35978_.m_7197_(oldStack, true, true);
        }
        playerInventory.m_6836_(index, itemStack);
        return true;
    }

    public static Optional<CombatSlot> getSlotType(ItemStack itemStack) {
        return itemStack.getCapability(CAPABILITY).map(CombatSlotProvider::getCombatSlot);
    }

    public boolean isItemValid(ItemStack itemStack) {
        return itemStack.m_41619_() || CombatSlot.getSlotType(itemStack).map(this::equals).orElse(false) != false;
    }

    public static boolean isInventoryValid(Inventory inventory) {
        for (int i = 0; i < 7; ++i) {
            if (CombatSlot.isItemValidForSlot(inventory.m_8020_(i), i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isItemValidForSlot(ItemStack itemStack, int slot) {
        return CombatSlot.getSlotType(slot).isItemValid(itemStack);
    }

    public static CombatSlot getSlotType(int slot) {
        switch (slot) {
            case 0: {
                return PRIMARY;
            }
            case 1: {
                return SECONDARY;
            }
            case 2: {
                return MELEE;
            }
            case 3: 
            case 4: 
            case 5: {
                return GRENADE;
            }
            case 6: {
                return EXTRA;
            }
        }
        throw new IllegalArgumentException("Invalid slot");
    }

    public static CombatSlot byName(String name) {
        return BY_NAME.get(name);
    }

    static {
        CODEC = StringRepresentable.m_14350_(CombatSlot::values, CombatSlot::byName);
        BY_NAME = Arrays.stream(CombatSlot.values()).collect(Collectors.toMap(CombatSlot::m_7912_, Function.identity()));
    }
}

