/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.world.item.hat.DefaultHat;
import com.craftingdead.core.world.item.hat.Hat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class HatItem
extends Item {
    private final float headshotReductionPercentage;
    private final boolean immuneToFlashes;
    private final boolean immuneToGas;
    private final boolean nightVision;

    public HatItem(Properties properties) {
        super((Item.Properties)properties);
        this.headshotReductionPercentage = properties.headshotReductionPercentage;
        this.immuneToFlashes = properties.immuneToFlashes;
        this.immuneToGas = properties.immuneToGas;
        this.nightVision = properties.nightVision;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> lore, TooltipFlag tooltipFlag) {
        if (this.headshotReductionPercentage > 0.0f) {
            MutableComponent percentageText = new TextComponent(String.format("%.1f", Float.valueOf(this.headshotReductionPercentage)) + "%").m_130940_(ChatFormatting.RED);
            lore.add((Component)new TranslatableComponent("hat.headshot_reduction").m_130940_(ChatFormatting.GRAY).m_7220_((Component)percentageText));
        }
        if (this.immuneToFlashes) {
            lore.add((Component)new TranslatableComponent("hat.immune_to_flashes").m_130940_(ChatFormatting.GRAY));
        }
        if (this.immuneToGas) {
            lore.add((Component)new TranslatableComponent("hat.immune_to_gas").m_130940_(ChatFormatting.GRAY));
        }
        if (this.nightVision) {
            lore.add((Component)new TranslatableComponent("hat.has_night_vision").m_130940_(ChatFormatting.GRAY));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundTag nbt) {
        return CapabilityUtil.provider(() -> new DefaultHat(this.nightVision, this.headshotReductionPercentage, this.immuneToFlashes), Hat.CAPABILITY);
    }

    public static class Properties
    extends Item.Properties {
        private float headshotReductionPercentage;
        private boolean immuneToFlashes;
        private boolean immuneToGas;
        private boolean nightVision;

        public Properties setHeadshotReductionPercentage(float headshotReductionPercentage) {
            this.headshotReductionPercentage = headshotReductionPercentage;
            return this;
        }

        public Properties setNightVision(boolean nightVision) {
            this.nightVision = nightVision;
            return this;
        }

        public Properties setImmuneToFlashes(boolean immuneToFlashes) {
            this.immuneToFlashes = immuneToFlashes;
            return this;
        }

        public Properties setImmuneToGas(boolean immuneToGas) {
            this.immuneToGas = immuneToGas;
            return this;
        }
    }
}

