/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.inventory;

import com.craftingdead.core.world.inventory.AbstractMenu;
import com.craftingdead.core.world.inventory.ModMenuTypes;
import com.craftingdead.core.world.inventory.PredicateItemHandlerSlot;
import com.craftingdead.core.world.inventory.storage.Storage;
import com.craftingdead.core.world.item.GunItem;
import java.util.function.BiPredicate;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class GenericMenu
extends AbstractMenu {
    private final int rows;

    public GenericMenu(MenuType<?> menuType, int windowId, Inventory inventory, int rows, BiPredicate<PredicateItemHandlerSlot, ItemStack> predicate) {
        this(menuType, windowId, inventory, (IItemHandler)new ItemStackHandler(9 * rows), rows, predicate);
    }

    public GenericMenu(MenuType<?> type, int id, Inventory inventory, IItemHandler itemHandler, int rows, BiPredicate<PredicateItemHandlerSlot, ItemStack> predicate) {
        super(type, id, (Container)inventory, itemHandler);
        assert (itemHandler.getSlots() >= rows * 9);
        this.rows = rows;
        this.addPlayerInventorySlots();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_((Slot)new PredicateItemHandlerSlot(itemHandler, j + i * 9, 8 + j * 18, 18 + i * 18, predicate));
            }
        }
    }

    public int getRows() {
        return this.rows;
    }

    @Override
    public int getInventoryOffset() {
        return 19 + (this.rows - 4) * 18;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public static GenericMenu createVest(int windowId, Inventory inventory, IItemHandler itemHandler) {
        return new GenericMenu((MenuType)ModMenuTypes.VEST.get(), windowId, inventory, itemHandler, 2, (slot, itemStack) -> !itemStack.getCapability(Storage.CAPABILITY).isPresent() && !(itemStack.m_41720_() instanceof GunItem));
    }

    public static GenericMenu createVest(int windowId, Inventory inventory) {
        return new GenericMenu((MenuType)ModMenuTypes.VEST.get(), windowId, inventory, 2, (slot, itemStack) -> !itemStack.getCapability(Storage.CAPABILITY).isPresent() && !(itemStack.m_41720_() instanceof GunItem));
    }

    public static GenericMenu createSmallBackpack(int windowId, Inventory inventory, IItemHandler itemHandler) {
        return new GenericMenu((MenuType)ModMenuTypes.SMALL_BACKPACK.get(), windowId, inventory, itemHandler, 2, (slot, itemStack) -> !itemStack.getCapability(Storage.CAPABILITY).isPresent() && !(itemStack.m_41720_() instanceof GunItem));
    }

    public static GenericMenu createSmallBackpack(int windowId, Inventory inventory) {
        return new GenericMenu((MenuType)ModMenuTypes.SMALL_BACKPACK.get(), windowId, inventory, 2, (slot, itemStack) -> !itemStack.getCapability(Storage.CAPABILITY).isPresent() && !(itemStack.m_41720_() instanceof GunItem));
    }

    public static GenericMenu createMediumBackpack(int windowId, Inventory inventory, IItemHandler itemHandler) {
        return new GenericMenu((MenuType)ModMenuTypes.MEDIUM_BACKPACK.get(), windowId, inventory, itemHandler, 4, (slot, itemStack) -> !itemStack.getCapability(Storage.CAPABILITY).isPresent() && !(itemStack.m_41720_() instanceof GunItem));
    }

    public static GenericMenu createMediumBackpack(int windowId, Inventory inventory) {
        return new GenericMenu((MenuType)ModMenuTypes.MEDIUM_BACKPACK.get(), windowId, inventory, 4, (slot, itemStack) -> !itemStack.getCapability(Storage.CAPABILITY).isPresent() && !(itemStack.m_41720_() instanceof GunItem));
    }

    public static GenericMenu createLargeBackpack(int windowId, Inventory inventory, IItemHandler itemHandler) {
        return new GenericMenu((MenuType)ModMenuTypes.LARGE_BACKPACK.get(), windowId, inventory, itemHandler, 6, (slot, itemStack) -> !itemStack.getCapability(Storage.CAPABILITY).isPresent() && !(itemStack.m_41720_() instanceof GunItem));
    }

    public static GenericMenu createLargeBackpack(int windowId, Inventory inventory) {
        return new GenericMenu((MenuType)ModMenuTypes.LARGE_BACKPACK.get(), windowId, inventory, 6, (slot, itemStack) -> !itemStack.getCapability(Storage.CAPABILITY).isPresent() && !(itemStack.m_41720_() instanceof GunItem));
    }

    public static GenericMenu createGunBag(int windowId, Inventory inventory, IItemHandler itemHandler) {
        return new GenericMenu((MenuType)ModMenuTypes.GUN_BAG.get(), windowId, inventory, itemHandler, 4, (slot, itemStack) -> !itemStack.getCapability(Storage.CAPABILITY).isPresent());
    }

    public static GenericMenu createGunBag(int windowId, Inventory inventory) {
        return new GenericMenu((MenuType)ModMenuTypes.GUN_BAG.get(), windowId, inventory, 4, (slot, itemStack) -> !itemStack.getCapability(Storage.CAPABILITY).isPresent());
    }
}

