/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.grenade;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.particle.GrenadeSmokeParticleData;
import com.craftingdead.core.world.entity.ModEntityTypes;
import com.craftingdead.core.world.entity.grenade.Grenade;
import com.craftingdead.core.world.item.GrenadeItem;
import com.craftingdead.core.world.item.ModItems;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SmokeGrenadeEntity
extends Grenade {
    public static final GrenadeSmokeParticleData LARGE_WHITE_SMOKE = new GrenadeSmokeParticleData(1.0f, 1.0f, 1.0f, 10.0f);
    private static final float START_DECREASING_PITCH_AT = 0.65f;
    private static final int FIRE_BLOCK_STATE_FLAGS = 1;

    public SmokeGrenadeEntity(EntityType<? extends Grenade> entityIn, Level worldIn) {
        super(entityIn, worldIn);
    }

    public SmokeGrenadeEntity(LivingEntity thrower, Level worldIn) {
        super((EntityType<? extends Grenade>)((EntityType)ModEntityTypes.SMOKE_GRENADE.get()), thrower, worldIn);
    }

    @Override
    public OptionalInt getMinimumTicksUntilAutoDeactivation() {
        return OptionalInt.of((Integer)CraftingDead.serverConfig.explosivesSmokeGrenadeTicksBeforeDeactivation.get());
    }

    @Override
    public void onMotionStop(int stopsCount) {
        if (stopsCount == 1) {
            this.setActivated(true);
        }
    }

    @Override
    public void activatedChanged(boolean activated) {
        if (!activated && !this.f_19853_.m_5776_()) {
            this.m_6074_();
        }
    }

    @Override
    public void onGrenadeTick() {
        int activatedTicksCount = this.getActivatedTicksCount();
        double radius = Mth.m_14139_((double)(Math.min((double)activatedTicksCount, 30.0) / 30.0), (double)2.0, (double)5.0) * (Double)CraftingDead.serverConfig.explosivesSmokeGrenadeRadius.get();
        if (this.f_19853_.m_5776_()) {
            if (activatedTicksCount % 10 == 0) {
                this.getMinimumTicksUntilAutoDeactivation().ifPresent(maximumDuration -> {
                    float progress = Math.max((float)activatedTicksCount - (float)maximumDuration * 0.65f, 0.0f) / ((float)maximumDuration * 0.35000002f);
                    float gradualPitch = Mth.m_14179_((float)(1.0f - progress), (float)0.5f, (float)1.7f);
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11937_, SoundSource.HOSTILE, 1.5f, gradualPitch, false);
                });
            }
            if (activatedTicksCount % 5 == 0) {
                double halfSphereVolume = 4.1887902047863905 * Math.pow(radius / 2.0, 3.0);
                int i = 0;
                while ((double)i < halfSphereVolume) {
                    double theta = this.f_19796_.nextDouble() * 2.0 * Math.PI;
                    double phi = Math.acos(2.0 * this.f_19796_.nextDouble() - 1.0);
                    double extraX = radius * Math.sin(phi) * Math.cos(theta);
                    double extraY = radius * Math.abs(Math.sin(phi) * Math.sin(theta)) * this.f_19796_.nextDouble();
                    double extraZ = radius * Math.cos(phi);
                    this.f_19853_.m_6493_((ParticleOptions)LARGE_WHITE_SMOKE, true, this.m_20185_() + extraX, this.m_20186_() + extraY, this.m_20189_() + extraZ, 0.0, 0.0, 0.0);
                    ++i;
                }
            }
        } else if (activatedTicksCount % 10 == 0) {
            double detectionRadius = radius + 1.5;
            BlockPos from = this.m_142538_().m_142022_(-detectionRadius, 0.0, -detectionRadius);
            BlockPos to = this.m_142538_().m_142022_(detectionRadius, detectionRadius, detectionRadius);
            BlockPos.m_121990_((BlockPos)from, (BlockPos)to).forEach(blockPos -> {
                BlockState blockState;
                double zDiff;
                double xDiff = this.m_20185_() - (double)blockPos.m_123341_();
                double distance2D = Mth.m_14116_((float)((float)(xDiff * xDiff + (zDiff = this.m_20189_() - (double)blockPos.m_123343_()) * zDiff)));
                if (distance2D <= detectionRadius && (blockState = this.f_19853_.m_8055_(blockPos)).m_60734_() instanceof FireBlock) {
                    this.f_19853_.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)FireBlock.f_53408_, (Comparable)Integer.valueOf(15)), 1);
                }
            });
        }
    }

    @Override
    public GrenadeItem asItem() {
        return (GrenadeItem)((Object)ModItems.SMOKE_GRENADE.get());
    }
}

