/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.grenade;

import com.craftingdead.core.world.damagesource.ModDamageSource;
import com.craftingdead.core.world.entity.BounceableProjectileEntity;
import com.craftingdead.core.world.entity.grenade.FireGrenadeEntity;
import com.craftingdead.core.world.item.GrenadeItem;
import java.util.OptionalInt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public abstract class Grenade
extends BounceableProjectileEntity {
    private static final FireGrenadeEntity.BounceSound DEFAULT_BOUNCE_SOUND = new FireGrenadeEntity.BounceSound(SoundEvents.f_12336_, 0.5f, 2.0f);
    private static final EntityDataAccessor<Boolean> ACTIVATED = SynchedEntityData.m_135353_(Grenade.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int activatedTicksCount = 0;
    private int deactivatedTicksCount = 0;
    private boolean lastActivated;

    public Grenade(EntityType<? extends Grenade> type, Level level) {
        super(type, level);
    }

    public Grenade(EntityType<? extends Grenade> type, LivingEntity thrower, Level level) {
        super(type, thrower, level);
    }

    public abstract GrenadeItem asItem();

    public abstract void onGrenadeTick();

    public abstract void activatedChanged(boolean var1);

    @Override
    public void m_8119_() {
        super.m_8119_();
        boolean activated = this.isActivated();
        if (this.lastActivated != activated) {
            this.lastActivated = activated;
            if (!activated) {
                this.deactivatedTicksCount = 0;
            } else {
                this.activatedTicksCount = 0;
            }
            this.activatedChanged(activated);
        }
        if (this.m_6084_()) {
            if (this.isActivated()) {
                ++this.activatedTicksCount;
            } else {
                ++this.deactivatedTicksCount;
            }
            this.onGrenadeTick();
        }
        if (this.m_6084_()) {
            this.getMinimumTicksUntilAutoActivation().ifPresent(ticks -> {
                if (!this.isActivated() && this.deactivatedTicksCount >= ticks) {
                    this.setActivated(true);
                }
            });
        }
        if (this.m_6084_()) {
            this.getMinimumTicksUntilAutoDeactivation().ifPresent(ticks -> {
                if (this.isActivated() && this.activatedTicksCount >= ticks) {
                    this.setActivated(false);
                }
            });
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_19360_()) {
            EntityDamageSource entitySource = (EntityDamageSource)source;
            this.m_20256_(entitySource.m_7639_().m_20154_().m_82490_(1.5));
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public void onSurfaceHit(BlockHitResult blockRayTraceResult) {
        FireGrenadeEntity.BounceSound bounceSound = this.getBounceSound(blockRayTraceResult);
        if (this.f_19853_.m_5776_()) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), bounceSound.soundEvent(), SoundSource.NEUTRAL, bounceSound.volume(), bounceSound.pitch(), false);
        }
    }

    public final InteractionResult m_6096_(Player playerEntity, InteractionHand hand) {
        boolean canPickup;
        boolean bl = canPickup = !playerEntity.m_36341_() && this.canBePickedUp(playerEntity);
        if (canPickup) {
            this.m_6074_();
            playerEntity.m_36356_(new ItemStack((ItemLike)this.asItem(), 1));
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 1.4f + 2.0f, false);
        }
        return canPickup ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public boolean canBePickedUp(Player playerFrom) {
        return false;
    }

    public FireGrenadeEntity.BounceSound getBounceSound(BlockHitResult blockRayTraceResult) {
        return DEFAULT_BOUNCE_SOUND;
    }

    public boolean canBeRemotelyActivated() {
        return false;
    }

    public boolean isAttracting() {
        return false;
    }

    public void setActivated(boolean activated) {
        this.m_20088_().m_135381_(ACTIVATED, (Object)activated);
    }

    public OptionalInt getMinimumTicksUntilAutoActivation() {
        return OptionalInt.empty();
    }

    public OptionalInt getMinimumTicksUntilAutoDeactivation() {
        return OptionalInt.empty();
    }

    public boolean isActivated() {
        return (Boolean)this.m_20088_().m_135370_(ACTIVATED);
    }

    public int getActivatedTicksCount() {
        return this.activatedTicksCount;
    }

    public boolean m_6087_() {
        return true;
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("activated", this.isActivated());
        compound.m_128405_("activatedTicksCount", this.activatedTicksCount);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setActivated(compound.m_128471_("activated"));
        this.activatedTicksCount = compound.m_128451_("activatedTicksCount");
    }

    @Override
    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(this.activatedTicksCount);
    }

    @Override
    public void readSpawnData(FriendlyByteBuf buffer) {
        super.readSpawnData(buffer);
        this.activatedTicksCount = buffer.readInt();
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(ACTIVATED, (Object)false);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public DamageSource createDamageSource() {
        return ModDamageSource.grenade(this, this.getSource().orElse(null));
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6783_(double distance) {
        double range = this.m_142469_().m_82309_() * 10.0;
        if (Double.isNaN(range)) {
            range = 1.0;
        }
        return distance < (range *= 64.0 * Grenade.m_20150_()) * range;
    }
}

