/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.grenade;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.world.entity.ModEntityTypes;
import com.craftingdead.core.world.entity.grenade.Grenade;
import com.craftingdead.core.world.item.GrenadeItem;
import com.craftingdead.core.world.item.GunItem;
import com.craftingdead.core.world.item.ModItems;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

public class DecoyGrenadeEntity
extends Grenade {
    private long lastShotMs;
    private final GunItem gunItem;

    public DecoyGrenadeEntity(EntityType<? extends Grenade> entityIn, Level worldIn) {
        super(entityIn, worldIn);
        this.gunItem = DecoyGrenadeEntity.getRandomGun(this.f_19796_);
    }

    public DecoyGrenadeEntity(LivingEntity thrower, Level worldIn) {
        super((EntityType<? extends Grenade>)((EntityType)ModEntityTypes.DECOY_GRENADE.get()), thrower, worldIn);
        this.gunItem = DecoyGrenadeEntity.getRandomGun(this.f_19796_);
    }

    @Override
    public void onMotionStop(int stopsCount) {
        if (stopsCount == 1) {
            this.setActivated(true);
        }
    }

    @Override
    public void activatedChanged(boolean activated) {
        if (!activated) {
            if (!this.f_19853_.m_5776_()) {
                this.m_6074_();
                this.f_19853_.m_7703_((Entity)this, this.createDamageSource(), null, this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_(), 1.3f, false, Explosion.BlockInteraction.NONE);
            }
        } else {
            this.playFakeShoot();
        }
    }

    @Override
    public OptionalInt getMinimumTicksUntilAutoDeactivation() {
        return OptionalInt.of((Integer)CraftingDead.serverConfig.explosivesDecoyGrenadeTicksBeforeDeactivation.get());
    }

    @Override
    public void onGrenadeTick() {
        if (!this.isActivated()) {
            return;
        }
        if (!this.f_19853_.m_5776_()) {
            if (this.f_19796_.nextInt(20) == 0 && this.canShoot()) {
                this.playFakeShoot();
            }
        } else {
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_(), this.m_20186_() + 0.4, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public boolean canShoot() {
        long fireDelayMs = this.gunItem.asGun().getFireDelayMs();
        return Util.m_137550_() - this.lastShotMs >= fireDelayMs;
    }

    public void playFakeShoot() {
        this.m_5496_(this.gunItem.asGun().getShootSound(), 1.5f, 1.0f);
        this.lastShotMs = Util.m_137550_();
    }

    @Override
    public boolean isAttracting() {
        return this.isActivated();
    }

    @Override
    public GrenadeItem asItem() {
        return (GrenadeItem)((Object)ModItems.DECOY_GRENADE.get());
    }

    private static GunItem getRandomGun(Random random) {
        List possibleGuns = ModItems.deferredRegister.getEntries().stream().map(RegistryObject::get).filter(GunItem.class::isInstance).map(GunItem.class::cast).collect(Collectors.toList());
        return (GunItem)possibleGuns.get(random.nextInt(possibleGuns.size()));
    }
}

