/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.grenade;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.world.entity.ExplosionSource;
import com.craftingdead.core.world.entity.ModEntityTypes;
import com.craftingdead.core.world.entity.grenade.FireGrenadeEntity;
import com.craftingdead.core.world.entity.grenade.Grenade;
import com.craftingdead.core.world.item.GrenadeItem;
import com.craftingdead.core.world.item.ModItems;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class C4Explosive
extends Grenade
implements ExplosionSource {
    private static final FireGrenadeEntity.BounceSound C4_BOUNCE_SOUND = new FireGrenadeEntity.BounceSound(SoundEvents.f_12276_, 1.0f, 1.5f);
    private int knockbackPenalty;

    public C4Explosive(EntityType<? extends Grenade> entityIn, Level worldIn) {
        super(entityIn, worldIn);
    }

    public C4Explosive(LivingEntity thrower, Level worldIn) {
        super((EntityType<? extends Grenade>)((EntityType)ModEntityTypes.C4_EXPLOSIVE.get()), thrower, worldIn);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_19372_() || source.m_19384_()) {
            if (source.m_7639_() != null) {
                this.setSource(source.m_7639_());
            }
            this.setActivated(true);
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public void onGrenadeTick() {
    }

    @Override
    public void activatedChanged(boolean activated) {
        if (activated && !this.f_19853_.m_5776_()) {
            this.m_6074_();
            if (this.knockbackPenalty == 0) {
                List<C4Explosive> others = this.f_19853_.m_45933_((Entity)this, this.m_142469_().m_82400_(2.0)).stream().filter(e -> e instanceof C4Explosive).map(e -> (C4Explosive)e).toList();
                for (C4Explosive other : others) {
                    other.setKnockbackPenalty(others.size() * 2);
                }
                this.setKnockbackPenalty(others.size());
            }
            this.f_19853_.m_7703_((Entity)this, this.createDamageSource(), null, this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_(), ((Double)CraftingDead.serverConfig.explosivesC4Radius.get()).floatValue(), false, (Explosion.BlockInteraction)CraftingDead.serverConfig.explosivesC4ExplosionMode.get());
        }
    }

    @Override
    public boolean canBePickedUp(Player playerFrom) {
        return this.hasStoppedMoving();
    }

    @Override
    public Optional<Float> getBounceFactor(BlockHitResult blockRayTraceResult) {
        return blockRayTraceResult.m_82434_() == Direction.UP ? Optional.empty() : super.getBounceFactor(blockRayTraceResult);
    }

    @Override
    public boolean canBeRemotelyActivated() {
        return true;
    }

    @Override
    public FireGrenadeEntity.BounceSound getBounceSound(BlockHitResult blockRayTraceResult) {
        return C4_BOUNCE_SOUND;
    }

    @Override
    public GrenadeItem asItem() {
        return this.isSticky ? (GrenadeItem)((Object)ModItems.STICKY_C4_EXPLOSIVE.get()) : (GrenadeItem)((Object)ModItems.C4_EXPLOSIVE.get());
    }

    @Override
    public void onMotionStop(int stopsCount) {
    }

    @Override
    public float getDamageMultiplier() {
        return ((Double)CraftingDead.serverConfig.explosivesC4KnockbackMultiplier.get()).floatValue();
    }

    @Override
    public double getKnockbackMultiplier() {
        return (Double)CraftingDead.serverConfig.explosivesC4DamageMultiplier.get() / (double)(this.knockbackPenalty > 0 ? this.knockbackPenalty : 1);
    }

    public void setKnockbackPenalty(int penalty) {
        this.knockbackPenalty = penalty;
    }
}

