/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.extension;

import com.craftingdead.core.event.OpenEquipmentMenuEvent;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.SynchedData;
import com.craftingdead.core.network.message.play.AddKillFeedEntryMessage;
import com.craftingdead.core.network.message.play.EnableCombatModeMessage;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.damagesource.KillFeedProvider;
import com.craftingdead.core.world.entity.extension.BaseLivingExtension;
import com.craftingdead.core.world.entity.extension.LivingHandlerType;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.entity.extension.PlayerHandler;
import com.craftingdead.core.world.inventory.EquipmentMenu;
import com.craftingdead.core.world.inventory.ModEquipmentSlot;
import com.craftingdead.core.world.inventory.storage.Storage;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableInt;

final class PlayerExtensionImpl<E extends Player>
extends BaseLivingExtension<E, PlayerHandler>
implements PlayerExtension<E> {
    private static final float HANDCUFFS_DAMAGE_CHANCE = 0.1f;
    private final SynchedData data = new SynchedData();
    private static final EntityDataAccessor<Boolean> COMBAT_MODE_ENABLED = new EntityDataAccessor(0, EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> HANDCUFFS = new EntityDataAccessor(1, EntityDataSerializers.f_135033_);
    private boolean cachedCombatModeEnabled;

    PlayerExtensionImpl(E entity) {
        super(entity);
        this.data.register(COMBAT_MODE_ENABLED, false);
        this.data.register(HANDCUFFS, ItemStack.f_41583_);
    }

    @Override
    public void tick() {
        this.cachedCombatModeEnabled = false;
        super.tick();
    }

    @Override
    protected void tickHandler(LivingHandlerType<? extends PlayerHandler> type, PlayerHandler extension) {
        super.tickHandler(type, extension);
        if (extension.isCombatModeEnabled()) {
            this.cachedCombatModeEnabled = true;
        }
    }

    @Override
    public boolean performAction(Action action, boolean force, boolean sendUpdate) {
        return !this.isHandcuffed() && super.performAction(action, force, sendUpdate);
    }

    @Override
    public void playerTick() {
        if (this.isCrouching()) {
            ((Player)this.getEntity()).m_20124_(Pose.SWIMMING);
        }
        for (PlayerHandler handler : this.handlers.values()) {
            handler.playerTick();
        }
    }

    @Override
    public boolean isMovementBlocked() {
        return !((Player)this.getEntity()).m_5833_() && super.isMovementBlocked();
    }

    @Override
    public boolean handleAttack(Entity target) {
        if (this.handlers.values().stream().anyMatch(e -> e.handleAttack(target))) {
            return true;
        }
        if (this.isHandcuffed()) {
            if (!this.getLevel().m_5776_()) {
                this.handcuffInteract(0.1f);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleInteract(InteractionHand hand, Entity target) {
        if (this.handlers.values().stream().anyMatch(e -> e.handleInteract(hand, target))) {
            return true;
        }
        if (this.isHandcuffed()) {
            if (!this.getLevel().m_5776_()) {
                this.handcuffInteract(0.1f);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleLeftClickBlock(BlockPos pos, Direction face, Consumer<Event.Result> attackResult, Consumer<Event.Result> mineResult) {
        if (this.handlers.values().stream().anyMatch(e -> e.handleLeftClickBlock(pos, face, attackResult, mineResult))) {
            return true;
        }
        if (this.isHandcuffed()) {
            if (this.getLevel().m_5776_()) {
                mineResult.accept(Event.Result.DENY);
            } else {
                this.handcuffInteract(0.1f);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleRightClickBlock(InteractionHand hand, BlockPos pos, Direction face) {
        if (this.handlers.values().stream().anyMatch(e -> e.handleRightClickBlock(hand, pos, face))) {
            return true;
        }
        if (this.isHandcuffed()) {
            if (!this.getLevel().m_5776_()) {
                this.handcuffInteract(0.1f);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleRightClickItem(InteractionHand hand) {
        if (this.handlers.values().stream().anyMatch(e -> e.handleRightClickItem(hand))) {
            return true;
        }
        if (this.isHandcuffed()) {
            if (!this.getLevel().m_5776_()) {
                this.handcuffInteract(0.1f);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleBlockBreak(BlockPos pos, BlockState block, MutableInt xp) {
        return this.handlers.values().stream().anyMatch(e -> e.handleBlockBreak(pos, block, xp));
    }

    private void handcuffInteract(float chance) {
        if (this.getRandom().nextFloat() < chance && !this.damageHandcuffs(1) && !((Player)this.getEntity()).m_20067_()) {
            this.getLevel().m_6263_(null, ((Player)this.getEntity()).m_20185_(), ((Player)this.getEntity()).m_20186_(), ((Player)this.getEntity()).m_20189_(), SoundEvents.f_12018_, ((Player)this.getEntity()).m_5720_(), 0.8f, 0.8f + this.getLevel().m_5822_().nextFloat() * 0.4f);
        }
    }

    @Override
    public boolean isCombatModeEnabled() {
        return !((Player)this.getEntity()).m_5833_() && (this.cachedCombatModeEnabled || this.data.get(COMBAT_MODE_ENABLED) != false);
    }

    @Override
    public void setCombatModeEnabled(boolean combatModeEnabled) {
        if (this.getLevel().m_5776_() && combatModeEnabled != this.isCombatModeEnabled()) {
            NetworkChannel.PLAY.getSimpleChannel().sendToServer((Object)new EnableCombatModeMessage(combatModeEnabled));
        } else {
            this.data.set(COMBAT_MODE_ENABLED, combatModeEnabled);
        }
    }

    @Override
    public void openEquipmentMenu() {
        if (MinecraftForge.EVENT_BUS.post((Event)new OpenEquipmentMenuEvent(this))) {
            return;
        }
        ((Player)this.getEntity()).m_5893_((MenuProvider)new SimpleMenuProvider((windowId, inventory, player) -> new EquipmentMenu(windowId, ((Player)this.getEntity()).m_150109_(), (IItemHandler)this.getItemHandler()), (Component)new TranslatableComponent("container.equipment")));
    }

    @Override
    public void openStorage(ModEquipmentSlot slotType) {
        ItemStack storageStack = this.getItemHandler().getStackInSlot(slotType.getIndex());
        storageStack.getCapability(Storage.CAPABILITY).ifPresent(storage -> ((Player)this.getEntity()).m_5893_((MenuProvider)new SimpleMenuProvider((MenuConstructor)storage, storageStack.m_41786_())));
    }

    @Override
    public boolean handleDeath(DamageSource source) {
        if (super.handleDeath(source)) {
            return true;
        }
        if (source instanceof KillFeedProvider) {
            KillFeedProvider provider = (KillFeedProvider)source;
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.ALL.noArg(), (Object)new AddKillFeedEntryMessage(provider.createKillFeedEntry((Player)this.getEntity())));
        }
        return false;
    }

    @Override
    public boolean handleDeathLoot(DamageSource cause, Collection<ItemEntity> drops, int lootingLevel) {
        if (super.handleDeathLoot(cause, drops, lootingLevel)) {
            return true;
        }
        ItemStack handcuffs = this.getHandcuffs();
        if (!handcuffs.m_41619_()) {
            ItemEntity itemEntity = new ItemEntity(this.getLevel(), ((Player)this.getEntity()).m_20185_(), ((Player)this.getEntity()).m_20186_(), ((Player)this.getEntity()).m_20189_(), handcuffs);
            itemEntity.m_32060_();
            drops.add(itemEntity);
        }
        return false;
    }

    @Override
    protected boolean keepInventory() {
        return this.getLevel().m_46469_().m_46207_(GameRules.f_46133_);
    }

    @Override
    public void copyFrom(PlayerExtension<ServerPlayer> that, boolean wasDeath) {
        for (int i = 0; i < that.getItemHandler().getSlots(); ++i) {
            this.getItemHandler().setStackInSlot(i, that.getItemHandler().getStackInSlot(i));
        }
        for (PlayerHandler extension : this.handlers.values()) {
            extension.copyFrom(that, wasDeath);
        }
        this.setCombatModeEnabled(that.isCombatModeEnabled());
        if (!wasDeath) {
            this.setHandcuffs(that.getHandcuffs());
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("handcuffs", (Tag)this.getHandcuffs().serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        if (tag.m_128425_("handcuffs", 10)) {
            this.setHandcuffs(ItemStack.m_41712_((CompoundTag)tag.m_128469_("handcuffs")));
        }
    }

    @Override
    public void encode(FriendlyByteBuf out, boolean writeAll) {
        super.encode(out, writeAll);
        SynchedData.pack(writeAll ? this.data.getAll() : this.data.packDirty(), out);
    }

    @Override
    public void decode(FriendlyByteBuf in) {
        super.decode(in);
        this.data.assignValues(SynchedData.unpack(in));
    }

    @Override
    public boolean requiresSync() {
        return super.requiresSync() || this.data.isDirty();
    }

    @Override
    public ItemStack getHandcuffs() {
        return this.data.get(HANDCUFFS);
    }

    @Override
    public void setHandcuffs(ItemStack itemStack) {
        this.data.set(HANDCUFFS, itemStack);
    }
}

