/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.extension;

import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtensionImpl;
import com.craftingdead.core.world.entity.extension.PlayerHandler;
import com.craftingdead.core.world.inventory.ModEquipmentSlot;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface PlayerExtension<E extends Player>
extends LivingExtension<E, PlayerHandler>,
PlayerHandler {
    public static <E extends Player> PlayerExtension<E> create(E entity) {
        return new PlayerExtensionImpl<E>(entity);
    }

    public static <P extends Player> PlayerExtension<P> getOrThrow(P player) {
        return CapabilityUtil.getOrThrow(LivingExtension.CAPABILITY, player, PlayerExtension.class);
    }

    @Nullable
    public static <P extends Player> PlayerExtension<P> get(P player) {
        return CapabilityUtil.get(LivingExtension.CAPABILITY, player, PlayerExtension.class);
    }

    @Override
    public boolean isCombatModeEnabled();

    public void setCombatModeEnabled(boolean var1);

    public void openEquipmentMenu();

    public void openStorage(ModEquipmentSlot var1);

    public ItemStack getHandcuffs();

    default public boolean isHandcuffed() {
        return !this.getHandcuffs().m_41619_();
    }

    public void setHandcuffs(ItemStack var1);

    default public boolean damageHandcuffs(int damage) {
        ItemStack handcuffs = this.getHandcuffs().m_41777_();
        handcuffs.m_41622_(damage, (LivingEntity)((Player)this.getEntity()), __ -> this.breakItem(handcuffs));
        if (handcuffs.m_41619_()) {
            this.setHandcuffs(ItemStack.f_41583_);
            return true;
        }
        this.setHandcuffs(handcuffs);
        return false;
    }
}

