/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.extension;

import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.ActionObserver;
import com.craftingdead.core.world.entity.extension.EntitySnapshot;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.entity.extension.LivingHandlerType;
import com.craftingdead.core.world.inventory.ModEquipmentSlot;
import com.craftingdead.core.world.item.gun.Gun;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface LivingExtension<E extends LivingEntity, H extends LivingHandler>
extends LivingHandler {
    public static final Capability<LivingExtension<?, ?>> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<LivingExtension<?, ?>>(){});
    public static final ResourceLocation CAPABILITY_KEY = new ResourceLocation("craftingdead", "living_extension");

    public static <E extends LivingEntity> LivingExtension<E, ?> getOrThrow(E entity) {
        return CapabilityUtil.getOrThrow(CAPABILITY, entity, LivingExtension.class);
    }

    @Nullable
    public static <E extends LivingEntity> LivingExtension<E, ?> get(E entity) {
        return CapabilityUtil.get(CAPABILITY, entity, LivingExtension.class);
    }

    public void load();

    public <T extends LivingHandler> Optional<T> getHandler(LivingHandlerType<T> var1);

    @Nonnull
    public <T extends LivingHandler> T getHandlerOrThrow(LivingHandlerType<T> var1) throws IllegalStateException;

    public <T extends H> void registerHandler(LivingHandlerType<T> var1, T var2);

    public Optional<Action> getAction();

    default public boolean performAction(Action action, boolean sendUpdate) {
        return this.performAction(action, false, sendUpdate);
    }

    public <T extends Action> boolean performAction(T var1, boolean var2, boolean var3);

    public void cancelAction(boolean var1);

    public void setActionObserver(@Nullable ActionObserver var1);

    public Optional<ActionObserver> getActionObserver();

    default public boolean isObservingAction() {
        return this.getActionObserver().isPresent();
    }

    public void setMovementBlocked(boolean var1);

    public boolean isMoving();

    public IItemHandlerModifiable getItemHandler();

    public EntitySnapshot getSnapshot(int var1) throws IndexOutOfBoundsException;

    public boolean isCrouching();

    public void setCrouching(boolean var1, boolean var2);

    default public float getModifiedAccuracy(float accuracy, Random random) {
        if (this.isMoving()) {
            accuracy -= 0.15f;
        } else if (this.isCrouching()) {
            accuracy += 0.15f;
        }
        if (!(this.getEntity() instanceof Player)) {
            accuracy -= random.nextFloat();
        }
        return accuracy;
    }

    public E getEntity();

    public float[] getEquipmentDropChances();

    public float getEquipmentDropChance(ModEquipmentSlot var1);

    public void setEquipmentDropChances(float[] var1);

    public void setEquipmentDropChance(ModEquipmentSlot var1, float var2);

    default public Level getLevel() {
        return this.getEntity().m_183503_();
    }

    default public Random getRandom() {
        return this.getEntity().m_21187_();
    }

    default public ItemStack getMainHandItem() {
        ItemStack item = this.getEntity().m_21205_();
        return item.m_41619_() ? ItemStack.f_41583_ : item;
    }

    default public LazyOptional<Gun> getMainHandGun() {
        return this.getMainHandItem().getCapability(Gun.CAPABILITY);
    }

    default public void breakItem(ItemStack itemStack) {
        if (!itemStack.m_41619_()) {
            if (!this.getEntity().m_20067_()) {
                this.getLevel().m_7785_(this.getEntity().m_20185_(), this.getEntity().m_20186_(), this.getEntity().m_20189_(), SoundEvents.f_12018_, this.getEntity().m_5720_(), 0.8f, 0.8f + this.getLevel().m_5822_().nextFloat() * 0.4f, false);
            }
            this.spawnItemParticles(itemStack, 5);
        }
    }

    default public void spawnItemParticles(ItemStack itemStack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 velocity = new Vec3(((double)this.getRandom().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            velocity = velocity.m_82496_(-this.getEntity().m_146909_() * ((float)Math.PI / 180));
            velocity = velocity.m_82524_(-this.getEntity().m_146908_() * ((float)Math.PI / 180));
            double yPos = (double)(-this.getRandom().nextFloat()) * 0.6 - 0.3;
            Vec3 pos = new Vec3(((double)this.getRandom().nextFloat() - 0.5) * 0.3, yPos, 0.6);
            pos = pos.m_82496_(-this.getEntity().m_146909_() * ((float)Math.PI / 180));
            pos = pos.m_82524_(-this.getEntity().m_146908_() * ((float)Math.PI / 180));
            pos = pos.m_82520_(this.getEntity().m_20185_(), this.getEntity().m_20188_(), this.getEntity().m_20189_());
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, velocity.f_82479_, velocity.f_82480_ + 0.05, velocity.f_82481_, 0.0);
                continue;
            }
            this.getLevel().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), pos.f_82479_, pos.f_82480_, pos.f_82481_, velocity.f_82479_, velocity.f_82480_ + 0.05, velocity.f_82481_);
        }
    }
}

