/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity;

import com.craftingdead.core.util.MutableVector2f;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class EntityUtil {
    private static final MutableVector2f ROTATIONS_TO_TARGET = new MutableVector2f();

    public static boolean canSee(LivingEntity viewer, Entity target, float fov) {
        EntityUtil.getRotationsToTarget(viewer, target, ROTATIONS_TO_TARGET);
        float yawToTarget = ROTATIONS_TO_TARGET.getX();
        float pitchToTarget = ROTATIONS_TO_TARGET.getY();
        float currentYaw = Mth.m_14177_((float)viewer.f_20885_);
        float currentPitch = Mth.m_14177_((float)viewer.m_146909_());
        float yawDifference = Math.abs(Mth.m_14177_((float)(currentYaw - yawToTarget)));
        float pitchDifference = Math.abs(Mth.m_14177_((float)(currentPitch - pitchToTarget)));
        boolean insideYaw = yawDifference <= fov;
        boolean insidePitch = pitchDifference <= fov;
        return insideYaw && insidePitch;
    }

    public static void getRotationsToTarget(LivingEntity viewer, Entity target, MutableVector2f result) {
        Vec3 entityVec = target.m_20182_();
        Vec3 livingVec = viewer.m_20182_();
        double xDiff = livingVec.f_82479_ - entityVec.f_82479_;
        double zDiff = entityVec.f_82481_ - livingVec.f_82481_;
        double yDiff = entityVec.f_82480_ + (double)target.m_20192_() - (livingVec.f_82480_ + (double)viewer.m_20192_());
        float distance2D = Mth.m_14116_((float)((float)(xDiff * xDiff + zDiff * zDiff)));
        float yawToTarget = (float)(Math.atan2(xDiff, zDiff) * 180.0 / Math.PI);
        float pitchToTarget = (float)(-(Math.atan2(yDiff, distance2D) * 180.0 / Math.PI));
        result.set(Mth.m_14177_((float)yawToTarget), Mth.m_14177_((float)pitchToTarget));
    }
}

