/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.reload;

import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.ActionTypes;
import com.craftingdead.core.world.action.reload.AbstractReloadAction;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.RefillableAmmoProvider;

public class RefillableReloadAction
extends AbstractReloadAction {
    private final RefillableAmmoProvider ammoProvider;
    private int oldAmmoCount;

    public RefillableReloadAction(LivingExtension<?, ?> performer) {
        super(performer);
        AmmoProvider ammoProvider = this.gun.getAmmoProvider();
        if (!(ammoProvider instanceof RefillableAmmoProvider)) {
            throw new IllegalStateException("No RefillableAmmoProvider present");
        }
        this.ammoProvider = (RefillableAmmoProvider)ammoProvider;
    }

    @Override
    public ActionType<?> getType() {
        return (ActionType)ActionTypes.REFILLABLE_RELOAD.get();
    }

    @Override
    public boolean start(boolean simulate) {
        return (this.ammoProvider.hasInfiniteAmmo() || this.ammoProvider.getReserveSize() > 0) && super.start(simulate);
    }

    @Override
    protected void loadNewMagazineStack(boolean displayOnly) {
        if (!displayOnly) {
            this.oldAmmoCount = this.ammoProvider.getExpectedMagazine().getSize();
            this.ammoProvider.refillMagazine();
        }
    }

    @Override
    protected void revert() {
        this.ammoProvider.moveAmmoToReserve(this.ammoProvider.getExpectedMagazine().getSize());
        this.ammoProvider.moveAmmoToMagazine(this.oldAmmoCount);
    }
}

