/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.reload;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.client.animation.Animation;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.TimedAction;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.GunAnimationEvent;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractReloadAction
extends TimedAction {
    protected final LivingExtension<?, ?> performer;
    protected final Gun gun;
    protected final ItemStack oldMagazineStack;
    @Nullable
    private Animation animation;

    public AbstractReloadAction(LivingExtension<?, ?> performer) {
        this.performer = performer;
        this.gun = (Gun)performer.getMainHandItem().getCapability(Gun.CAPABILITY).orElseThrow(() -> new IllegalStateException("Performer not holding gun"));
        this.oldMagazineStack = this.gun.getAmmoProvider().getMagazineStack();
    }

    @Override
    public LivingExtension<?, ?> getPerformer() {
        return this.performer;
    }

    @Override
    protected int getTotalDurationTicks() {
        return this.gun.getReloadDurationTicks() + (Integer)CraftingDead.serverConfig.reloadDuration.get();
    }

    @Override
    public boolean start(boolean simulate) {
        if (this.getPerformer().getEntity().m_20142_()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (this.gun.isPerformingSecondaryAction()) {
            this.gun.setPerformingSecondaryAction(this.getPerformer(), false, false);
        }
        this.gun.getReloadSound().ifPresent(sound -> this.getPerformer().getLevel().m_6269_(null, this.getPerformer().getEntity(), sound, SoundSource.PLAYERS, 1.0f, 1.0f));
        if (this.getPerformer().getLevel().m_5776_()) {
            this.animation = this.gun.getClient().getAnimation(GunAnimationEvent.RELOAD);
            this.gun.getClient().getAnimationController().addAnimation(this.animation);
        }
        return true;
    }

    protected abstract void loadNewMagazineStack(boolean var1);

    @Override
    public boolean tick() {
        if (!this.getPerformer().getLevel().m_5776_() && !this.performer.getMainHandItem().m_150930_(this.gun.getItemStack().m_41720_()) || this.getPerformer().getEntity().m_20142_()) {
            this.getPerformer().cancelAction(true);
            return false;
        }
        return super.tick();
    }

    @Override
    public void stop(Action.StopReason reason) {
        super.stop(reason);
        if (reason.isCompleted()) {
            if (this.getPerformer().getLevel().m_5776_()) {
                return;
            }
            this.loadNewMagazineStack(false);
            return;
        }
        if (this.getPerformer().getLevel().m_5776_()) {
            if (this.gun.getReloadSound().isPresent()) {
                Minecraft.m_91087_().m_91106_().m_120386_(this.gun.getReloadSound().get().getRegistryName(), SoundSource.PLAYERS);
            }
            if (this.animation != null) {
                this.animation.remove();
            }
        }
        this.revert();
    }

    protected abstract void revert();
}

