/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.item;

import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.item.ItemActionType;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class ItemAction
implements Action {
    private final InteractionHand hand;
    private ItemStack originalStack;

    public ItemAction(InteractionHand hand) {
        this.hand = hand;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public ItemStack getItemStack() {
        return this.getPerformer().getEntity().m_21120_(this.hand);
    }

    public int getTicksUsingItem() {
        return this.getPerformer().getEntity().m_21252_();
    }

    private boolean checkHeldItem() {
        return ((ItemActionType)this.getType()).getHeldItemPredicate().test(this.getItemStack());
    }

    @Override
    public boolean start(boolean simulate) {
        if (this.checkHeldItem()) {
            if (!simulate) {
                this.originalStack = this.getItemStack();
                if (!this.getPerformer().getLevel().m_5776_()) {
                    this.getPerformer().getEntity().m_6672_(this.hand);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void stop(Action.StopReason reason) {
        this.getPerformer().getEntity().m_5810_();
        if (!reason.isCompleted()) {
            return;
        }
        ItemStack heldStack = this.getItemStack();
        ItemStack resultStack = this.getResultItem(this.getPerformer()).map(Item::m_7968_).orElse(ItemStack.f_41583_);
        if (this.shouldConsumeItem(this.getPerformer())) {
            heldStack.m_41774_(1);
        }
        if (!resultStack.m_41619_()) {
            if (heldStack.m_41619_()) {
                this.getPerformer().getEntity().m_21008_(this.hand, resultStack);
            } else {
                Player player;
                Object obj = this.getPerformer().getEntity();
                if (obj instanceof Player && (player = (Player)obj).m_150109_().m_36054_(resultStack)) {
                    this.getPerformer().getEntity().m_19983_(resultStack);
                }
            }
        }
        ((ItemActionType)this.getType()).getFinishSound().ifPresent(sound -> this.getPerformer().getEntity().m_5496_(sound, 1.0f, 1.0f));
    }

    protected boolean shouldConsumeItem(LivingExtension<?, ?> performer) {
        Player player;
        Object obj;
        return ((ItemActionType)this.getType()).shouldConsumeItem() && (!((obj = performer.getEntity()) instanceof Player) || !(player = (Player)obj).m_7500_()) || ((ItemActionType)this.getType()).shouldConsumeItemInCreative();
    }

    protected Optional<Item> getResultItem(LivingExtension<?, ?> performer) {
        Player player;
        Object obj;
        return !((ItemActionType)this.getType()).useResultItemInCreative() && (obj = performer.getEntity()) instanceof Player && (player = (Player)obj).m_7500_() ? Optional.empty() : ((ItemActionType)this.getType()).getReturnItem();
    }

    @Override
    public boolean tick() {
        if (!this.getPerformer().getEntity().m_6117_() || this.originalStack != this.getItemStack()) {
            this.getPerformer().cancelAction(true);
            return false;
        }
        if (((ItemActionType)this.getType()).isFreezeMovement()) {
            this.getPerformer().setMovementBlocked(true);
        }
        return this.getPerformer().getEntity().m_21212_() == 1;
    }

    public float getProgress(float partialTicks) {
        if (!this.getPerformer().getEntity().m_6117_()) {
            return 0.0f;
        }
        return ((float)this.getPerformer().getEntity().m_21252_() + partialTicks) / (float)((ItemActionType)this.getType()).getTotalDurationTicks();
    }

    public abstract ItemActionType<?> getType();
}

