/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.item;

import com.craftingdead.core.util.RayTraceUtil;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.ActionObserver;
import com.craftingdead.core.world.action.ProgressBar;
import com.craftingdead.core.world.action.item.EntityItemActionType;
import com.craftingdead.core.world.action.item.ItemAction;
import com.craftingdead.core.world.action.item.ItemActionType;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.phys.EntityHitResult;

public final class EntityItemAction<T extends LivingExtension<?, ?>>
extends ItemAction {
    private final EntityItemActionType<T> type;
    private final LivingExtension<?, ?> performer;
    @Nullable
    private final T selectedTarget;

    protected EntityItemAction(InteractionHand hand, EntityItemActionType<T> type, LivingExtension<?, ?> performer, T selectedTarget) {
        super(hand);
        this.type = type;
        this.performer = performer;
        this.selectedTarget = selectedTarget;
    }

    public T getSelectedTarget() {
        return this.selectedTarget;
    }

    @Override
    public boolean start(boolean simulate) {
        return this.selectedTarget != null && super.start(simulate);
    }

    @Override
    public ActionObserver createPerformerObserver() {
        return ActionObserver.create(this, ProgressBar.create(this.getType(), (Component)(this.performer == this.selectedTarget ? null : new TranslatableComponent("action.target", new Object[]{this.selectedTarget.getEntity().m_5446_().getString()})), this::getProgress));
    }

    @Override
    public ActionObserver createTargetObserver() {
        return ActionObserver.create(this, ProgressBar.create(this.getType(), (Component)new TranslatableComponent("action.performer", new Object[]{this.performer.getEntity().m_5446_().getString()}), this::getProgress));
    }

    @Override
    public boolean tick() {
        EntityHitResult result;
        if (this.selectedTarget != this.performer && ((result = (EntityHitResult)RayTraceUtil.rayTraceEntities(this.performer.getEntity()).orElse(null)) == null || result.m_82443_() != this.selectedTarget.getEntity())) {
            this.performer.cancelAction(true);
            return false;
        }
        return super.tick();
    }

    @Override
    public void stop(Action.StopReason reason) {
        if (reason.isCompleted()) {
            if (this.type.getCustomAction() != null && this.performer.getEntity().m_21187_().nextFloat() < this.type.getCustomAction().chance()) {
                this.type.getCustomAction().consumer().accept(this.performer, (LivingExtension<?, ?>)this.selectedTarget);
            }
            this.selectedTarget.getEntity().curePotionEffects(this.getItemStack());
            for (EntityItemActionType.EffectAction action : this.type.getEffects()) {
                if (!(this.performer.getEntity().m_21187_().nextFloat() < action.chance())) continue;
                MobEffectInstance effectInstance = action.effect().get();
                if (effectInstance.m_19544_().m_8093_()) {
                    effectInstance.m_19544_().m_19461_(this.selectedTarget.getEntity(), this.selectedTarget.getEntity(), this.selectedTarget.getEntity(), effectInstance.m_19564_(), 1.0);
                    continue;
                }
                this.selectedTarget.getEntity().m_7292_(new MobEffectInstance(effectInstance));
            }
        }
        super.stop(reason);
    }

    @Override
    public LivingExtension<?, ?> getPerformer() {
        return this.performer;
    }

    @Override
    public Optional<LivingExtension<?, ?>> getTarget() {
        return this.selectedTarget == this.performer ? Optional.empty() : Optional.ofNullable(this.selectedTarget);
    }

    @Override
    public ItemActionType<?> getType() {
        return this.type;
    }
}

